/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spell;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellEventType;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.Target;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Skeleton;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.inventory.ItemStack;

public class FamiliarSpell
extends Spell {
    private String DEFAULT_FAMILIARS = "Chicken,Sheep,Cow,Pig,Wolf,Villager,MushroomCow,Ozelot,HorseEntity";
    private String DEFAULT_MONSTERS = "Creeper,PigZombie,Skeleton,Spider,Zombie,Giant,Silverfish,CaveSpider,Blaze,Bat,Witch";
    private final Random rand = new Random();
    private PlayerFamiliar familiars = new PlayerFamiliar();
    private int spawnCount = 0;

    @Override
    public SpellResult onCast(ConfigurationNode parameters) {
        Block originalTarget;
        this.spawnCount = 0;
        if (!this.hasBuildPermission(this.getLocation().getBlock())) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        this.noTargetThrough(Material.STATIONARY_WATER);
        this.noTargetThrough(Material.WATER);
        Target target = this.getTarget();
        if (!target.hasTarget()) {
            return SpellResult.NO_TARGET;
        }
        Block targetBlock = originalTarget = target.getBlock();
        LivingEntity targetEntity = null;
        boolean hasFamiliar = this.familiars.hasFamiliar();
        if (hasFamiliar) {
            boolean isFamiliar;
            boolean bl = isFamiliar = target.hasEntity() && this.familiars.isFamiliar(target.getEntity());
            if (isFamiliar) {
                this.checkListener();
                this.familiars.releaseFamiliar(target.getEntity());
                return SpellResult.COST_FREE;
            }
            this.familiars.releaseFamiliar();
        }
        if (target.hasEntity()) {
            targetBlock = targetBlock.getRelative(BlockFace.SOUTH);
            Entity e = target.getEntity();
            if (e instanceof LivingEntity) {
                targetEntity = (LivingEntity)e;
            }
        }
        targetBlock = targetBlock.getRelative(BlockFace.UP);
        EntityType famType = EntityType.PIG;
        FamiliarClass famClass = FamiliarClass.FRIENDLY;
        int famCount = parameters.getInt("count", 1);
        String famTypeName = parameters.getString("type", "");
        if (famTypeName.equalsIgnoreCase("any")) {
            famClass = FamiliarClass.ANY;
        } else if (famTypeName.equalsIgnoreCase("mob")) {
            famClass = FamiliarClass.MONSTER;
        } else if (famTypeName.length() > 1) {
            String testType = famTypeName.toUpperCase();
            EntityType[] entityTypeArray = EntityType.values();
            int n = entityTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                EntityType ct = entityTypeArray[n2];
                String name = ct.getName();
                if (name != null && name.toUpperCase().equals(testType)) {
                    famType = ct;
                    famClass = FamiliarClass.SPECIFIC;
                }
                ++n2;
            }
        }
        if (originalTarget.getType() == Material.WATER || originalTarget.getType() == Material.STATIONARY_WATER) {
            famType = EntityType.SQUID;
            famClass = FamiliarClass.SPECIFIC;
        }
        ArrayList<Creature> newFamiliars = new ArrayList<Creature>();
        Location centerLoc = targetBlock.getLocation();
        int i = 0;
        while (i < famCount) {
            Creature entity;
            if (famClass != FamiliarClass.SPECIFIC) {
                if (famClass == FamiliarClass.ANY) {
                    int randomFamiliar = this.rand.nextInt(EntityType.values().length - 1);
                    famType = EntityType.values()[randomFamiliar];
                } else {
                    String[] types = StringUtils.split((String)this.DEFAULT_FAMILIARS, (char)',');
                    if (famClass == FamiliarClass.MONSTER) {
                        types = StringUtils.split((String)this.DEFAULT_MONSTERS, (char)',');
                    }
                    int randomFamiliar = this.rand.nextInt(types.length);
                    famType = EntityType.fromName((String)types[randomFamiliar]);
                }
            }
            Location targetLoc = centerLoc.clone();
            if (famCount > 1) {
                targetLoc.setX(targetLoc.getX() + (double)this.rand.nextInt(2 * famCount) - (double)famCount);
                targetLoc.setZ(targetLoc.getZ() + (double)this.rand.nextInt(2 * famCount) - (double)famCount);
            }
            if (famType != null && (entity = this.spawnFamiliar(targetLoc, famType, targetEntity)) != null) {
                newFamiliars.add(entity);
                ++this.spawnCount;
            }
            ++i;
        }
        this.familiars.setFamiliars(newFamiliars);
        this.checkListener();
        return SpellResult.CAST;
    }

    protected Creature spawnFamiliar(Location target, EntityType famType, LivingEntity targetEntity) {
        Entity famEntity;
        Creature familiar;
        block5: {
            familiar = null;
            famEntity = this.getWorld().spawnEntity(target, famType);
            if (famEntity instanceof Creature) break block5;
            return null;
        }
        try {
            familiar = (Creature)famEntity;
            if (familiar instanceof Skeleton) {
                Skeleton skellie = (Skeleton)familiar;
                skellie.getEquipment().setItemInHand(new ItemStack(Material.BOW));
            }
            if (targetEntity != null) {
                familiar.setTarget(targetEntity);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return familiar;
    }

    protected void checkListener() {
        if (this.familiars.hasFamiliar()) {
            this.controller.registerEvent(SpellEventType.PLAYER_QUIT, this);
        } else {
            this.controller.unregisterEvent(SpellEventType.PLAYER_QUIT, this);
        }
    }

    public void onPlayerQuit(PlayerEvent event) {
        if (this.familiars.hasFamiliar()) {
            this.familiars.releaseFamiliar();
            this.checkListener();
        }
    }

    @Override
    public String getMessage(String messageKey, String def) {
        String message = super.getMessage(messageKey, def);
        return message.replace("$count", Integer.toString(this.spawnCount));
    }

    public static enum FamiliarClass {
        SPECIFIC,
        ANY,
        FRIENDLY,
        MONSTER;

    }

    public class PlayerFamiliar {
        public List<Creature> familiars = null;

        public boolean hasFamiliar() {
            return this.familiars != null;
        }

        public void setFamiliars(List<Creature> f) {
            this.familiars = f;
        }

        public void releaseFamiliar() {
            if (this.familiars != null) {
                for (Creature familiar : this.familiars) {
                    familiar.setHealth(0.0);
                }
                this.familiars = null;
            }
        }

        public void releaseFamiliar(Entity entity) {
            if (this.familiars != null) {
                ArrayList<Creature> iterate = new ArrayList<Creature>(this.familiars);
                for (Creature familiar : iterate) {
                    if (familiar.getUniqueId() != entity.getUniqueId()) continue;
                    familiar.setHealth(0.0);
                    this.familiars.remove(familiar);
                }
                this.familiars = null;
            }
        }

        public boolean isFamiliar(Entity e) {
            if (this.familiars == null) {
                return false;
            }
            for (Creature c : this.familiars) {
                if (c.getEntityId() != e.getEntityId()) continue;
                return true;
            }
            return false;
        }
    }
}

