/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.effects;

import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.effects.EffectUtils;
import com.elmakers.mine.bukkit.effects.ParticleType;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.security.InvalidParameterException;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Effect;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public abstract class EffectPlayer {
    public static boolean SOUNDS_ENABLED = true;
    protected Plugin plugin;
    protected Location origin;
    protected Location target;
    protected boolean playAtOrigin = true;
    protected boolean playAtTarget = false;
    protected Color color;
    protected MaterialAndData material;
    protected int delayTicks = 0;
    protected MaterialAndData material1;
    protected Color color1 = Color.PURPLE;
    protected Color color2 = Color.TEAL;
    protected Effect effect = null;
    protected Integer effectData = null;
    protected Sound sound = null;
    protected float soundVolume = 0.7f;
    protected float soundPitch = 1.5f;
    protected boolean hasFirework = false;
    protected FireworkEffect.Type fireworkType;
    protected int fireworkPower = 1;
    protected Boolean fireworkFlicker;
    protected FireworkEffect fireworkEffect;
    protected ParticleType particleType = null;
    protected String particleSubType = "";
    protected float particleData = 0.0f;
    protected float particleXOffset = 0.3f;
    protected float particleYOffset = 0.3f;
    protected float particleZOffset = 0.3f;
    protected int particleCount = 1;
    protected Vector offset = new Vector(0, 0, 0);

    public EffectPlayer() {
    }

    public EffectPlayer(Plugin plugin) {
        this.plugin = plugin;
    }

    public void load(Plugin plugin, ConfigurationNode configuration) {
        String typeName;
        this.plugin = plugin;
        this.delayTicks = configuration.getInt("delay", this.delayTicks) * 20 / 1000;
        this.material1 = configuration.getMaterialAndData("material");
        this.color1 = configuration.getColor("color", Color.PURPLE);
        this.color2 = configuration.getColor("color2", Color.TEAL);
        if (configuration.containsKey("effect")) {
            String effectName = configuration.getString("effect");
            this.effect = Effect.valueOf((String)effectName.toUpperCase());
            if (this.effect == null) {
                plugin.getLogger().warning("Unknown effect type " + effectName);
            } else {
                this.effectData = configuration.getInteger("effect_data", this.effectData);
            }
        }
        if (configuration.containsKey("sound")) {
            String soundName = configuration.getString("sound");
            this.sound = Sound.valueOf((String)soundName.toUpperCase());
            if (this.sound == null) {
                plugin.getLogger().warning("Unknown sound type " + soundName);
            } else {
                this.soundVolume = configuration.getFloat("sound_volume", this.soundVolume);
                this.soundPitch = configuration.getFloat("sound_pitch", this.soundPitch);
            }
        }
        if (configuration.containsKey("firework") || configuration.containsKey("firework_power")) {
            this.hasFirework = true;
            this.fireworkType = null;
            if (configuration.containsKey("firework")) {
                typeName = configuration.getString("firework");
                this.fireworkType = FireworkEffect.Type.valueOf((String)typeName.toUpperCase());
                if (this.fireworkType == null) {
                    plugin.getLogger().warning("Unknown firework type " + typeName);
                }
            }
            this.fireworkPower = configuration.getInt("firework_power", this.fireworkPower);
            Boolean bl = this.fireworkFlicker = configuration.containsKey("firework_flicker") ? Boolean.valueOf(configuration.getBoolean("firework_flicker", false)) : null;
        }
        if (configuration.containsKey("particle")) {
            typeName = configuration.getString("particle");
            this.particleType = ParticleType.valueOf(typeName.toUpperCase());
            if (this.particleType == null) {
                plugin.getLogger().warning("Unknown particle type " + typeName);
            } else {
                this.particleSubType = configuration.getString("particle_sub_type", this.particleSubType);
                this.particleData = configuration.getFloat("particle_data", this.particleData);
                this.particleXOffset = configuration.getFloat("particle_offset_x", this.particleXOffset);
                this.particleYOffset = configuration.getFloat("particle_offset_y", this.particleYOffset);
                this.particleZOffset = configuration.getFloat("particle_offset_z", this.particleZOffset);
                this.particleCount = configuration.getInt("particle_count", this.particleCount);
            }
        }
        this.setLocationType(configuration.getString("location", "origin"));
    }

    public void setLocationType(String locationType) {
        if (locationType.equals("target")) {
            this.playAtOrigin = false;
            this.playAtTarget = true;
        } else if (locationType.equals("origin")) {
            this.playAtTarget = false;
            this.playAtOrigin = true;
        } else if (locationType.equals("both")) {
            this.playAtTarget = true;
            this.playAtOrigin = true;
        }
    }

    public FireworkEffect getFireworkEffect(Color color1, Color color2, FireworkEffect.Type fireworkType) {
        return this.getFireworkEffect(color1, color2, fireworkType, null, null);
    }

    public FireworkEffect getFireworkEffect(Color color1, Color color2, FireworkEffect.Type fireworkType, Boolean flicker, Boolean trail) {
        Random rand = new Random();
        if (color1 == null) {
            color1 = Color.fromRGB((int)rand.nextInt(255), (int)rand.nextInt(255), (int)rand.nextInt(255));
        }
        if (color2 == null) {
            color2 = Color.fromRGB((int)rand.nextInt(255), (int)rand.nextInt(255), (int)rand.nextInt(255));
        }
        if (fireworkType == null) {
            fireworkType = FireworkEffect.Type.values()[rand.nextInt(FireworkEffect.Type.values().length)];
        }
        if (flicker == null) {
            flicker = rand.nextBoolean();
        }
        if (trail == null) {
            trail = rand.nextBoolean();
        }
        return FireworkEffect.builder().flicker(flicker.booleanValue()).withColor(color1).withFade(color2).with(fireworkType).trail(trail.booleanValue()).build();
    }

    public void setEffect(Effect effect) {
        this.effect = effect;
    }

    public void setParticleType(ParticleType particleType) {
        this.particleType = particleType;
    }

    public void setParticleSubType(String particleSubType) {
        this.particleSubType = particleSubType;
    }

    public void setEffectData(int data) {
        this.effectData = data;
    }

    protected MaterialAndData getWorkingMaterial() {
        if (this.material1 != null) {
            return this.material1;
        }
        MaterialAndData result = this.material;
        if (result == null && this.target != null) {
            result = new MaterialAndData(this.target.getBlock().getType(), this.target.getBlock().getData());
        } else if (result == null && this.origin != null) {
            result = new MaterialAndData(this.origin.getBlock().getType(), this.target.getBlock().getData());
        } else if (result == null) {
            result = new MaterialAndData(Material.AIR);
        }
        return result;
    }

    protected void playEffect(Location targetLocation) {
        Material material;
        Location location = targetLocation.clone();
        location.add(this.offset);
        if (this.effect != null) {
            int data;
            int n = data = this.effectData == null ? 0 : this.effectData;
            if (this.effect == Effect.STEP_SOUND && this.effectData == null) {
                material = this.getWorkingMaterial().getMaterial();
                if (!material.isSolid()) {
                    return;
                }
                data = material.getId();
            }
            location.getWorld().playEffect(location, this.effect, data);
        }
        if (this.sound != null) {
            location.getWorld().playSound(location, this.sound, this.soundVolume, this.soundPitch);
        }
        if (this.fireworkEffect != null) {
            EffectUtils.spawnFireworkEffect(location, this.fireworkEffect, this.fireworkPower);
        }
        if (this.particleType != null) {
            String subType = this.particleSubType;
            if ((this.particleType == ParticleType.BLOCK_BREAKING || this.particleType == ParticleType.TOOL_BREAKING) && this.particleSubType.length() == 0) {
                material = this.getWorkingMaterial().getMaterial();
                if (this.particleType == ParticleType.BLOCK_BREAKING && !material.isSolid()) {
                    return;
                }
                if (this.particleType == ParticleType.TOOL_BREAKING) {
                    material = Material.DIAMOND_AXE;
                }
                subType = "" + material.getId();
            }
            EffectUtils.playEffect(location, this.particleType, subType, this.particleXOffset, this.particleYOffset, this.particleZOffset, this.particleData, this.particleCount);
        }
    }

    public void setParticleData(float effectData) {
        this.particleData = effectData;
    }

    public void setParticleCount(int particleCount) {
        this.particleCount = particleCount;
    }

    public void setParticleOffset(float xOffset, float yOffset, float zOffset) {
        this.particleXOffset = xOffset;
        this.particleYOffset = yOffset;
        this.particleZOffset = zOffset;
    }

    public void setSound(Sound sound) {
        this.sound = sound;
    }

    public void setSound(Sound sound, float volume, float pitch) {
        this.sound = sound;
        this.soundVolume = volume;
        this.soundPitch = pitch;
    }

    public void setDelayTicks(int ticks) {
        this.delayTicks = ticks;
    }

    public void start(Location origin, Location target) {
        if (origin == null) {
            throw new InvalidParameterException("Origin cannot be null");
        }
        if (target != null && !origin.getWorld().equals(target.getWorld())) {
            return;
        }
        this.origin = origin;
        this.target = target;
        this.fireworkEffect = this.hasFirework ? this.getFireworkEffect(this.getColor1(), this.getColor2(), this.fireworkType, this.fireworkFlicker, false) : null;
        if (this.delayTicks > 0 && this.plugin != null) {
            final EffectPlayer player = this;
            Bukkit.getScheduler().scheduleSyncDelayedTask(this.plugin, new Runnable(){

                @Override
                public void run() {
                    player.play();
                }
            }, (long)this.delayTicks);
        } else {
            this.play();
        }
    }

    protected Vector getDirection() {
        Vector direction = this.target == null ? this.origin.getDirection() : this.target.toVector().subtract(this.origin.toVector());
        return direction.normalize();
    }

    public void setMaterial(MaterialAndData material) {
        this.material = new MaterialAndData(material);
    }

    public void setMaterial(Block block) {
        this.material = new MaterialAndData(block);
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor1() {
        return this.color != null ? this.color : this.color1;
    }

    public Color getColor2() {
        return this.color != null ? this.color1 : this.color2;
    }

    public void setOffset(float x, float y, float z) {
        this.offset.setX(x);
        this.offset.setY(y);
        this.offset.setZ(z);
    }

    public abstract void play();
}

