/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.block;

import com.elmakers.mine.bukkit.block.BlockBatch;
import com.elmakers.mine.bukkit.block.BlockData;
import com.elmakers.mine.bukkit.plugins.magic.MagicController;
import org.bukkit.util.BlockVector;

public abstract class VolumeBatch
implements BlockBatch {
    protected final MagicController controller;
    private String worldName;
    protected boolean finished = false;
    private Integer minx = null;
    private Integer miny = null;
    private Integer minz = null;
    private Integer maxx = null;
    private Integer maxy = null;
    private Integer maxz = null;

    public VolumeBatch(MagicController controller, String worldName) {
        this.controller = controller;
        this.worldName = worldName;
    }

    protected void updateBlock(BlockData data) {
        BlockVector location = data.getPosition();
        this.updateBlock(this.worldName, location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    protected void updateBlock(int x, int y, int z) {
        if (this.minx == null) {
            this.minx = x;
            this.miny = y;
            this.minz = z;
            this.maxx = x;
            this.maxy = y;
            this.maxz = z;
        } else {
            this.minx = Math.min(x, this.minx);
            this.miny = Math.min(z, this.miny);
            this.minz = Math.min(z, this.minz);
            this.maxx = Math.max(x, this.maxx);
            this.maxy = Math.max(z, this.maxy);
            this.maxz = Math.max(z, this.maxz);
        }
    }

    protected void updateBlock(String worldName, int x, int y, int z) {
        this.worldName = worldName;
        this.updateBlock(x, y, z);
    }

    @Override
    public void finish() {
        if (!this.finished) {
            if (this.worldName != null && this.minx != null && this.miny != null && this.minz != null && this.maxx != null && this.maxy != null && this.maxz != null) {
                this.controller.updateVolume(this.worldName, this.minx, this.miny, this.minz, this.maxx, this.maxy, this.maxz);
            }
            this.finished = true;
        }
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }
}

