/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.block;

import com.elmakers.mine.bukkit.block.BlockData;
import com.elmakers.mine.bukkit.utilities.Messages;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.block.Block;

public class Automaton
extends BlockData {
    private String message;
    private String name;
    private long createdAt;

    public Automaton(ConfigurationNode node) {
        super(node);
        this.name = node.getString("name");
        this.message = node.getString("message");
        this.createdAt = node.getLong("created", 0L);
    }

    public Automaton(Block block, String name, String message) {
        super(block);
        this.name = name;
        this.message = message;
        this.createdAt = System.currentTimeMillis();
    }

    @Override
    public void save(ConfigurationNode node) {
        super.save(node);
        node.setProperty("name", this.name);
        node.setProperty("message", this.message);
        node.setProperty("created", this.createdAt);
    }

    public String getMessage() {
        if (this.message == null || this.message.length() == 0 || this.name == null || this.name.length() == 0) {
            return "";
        }
        String contents = Messages.get(this.message);
        if (contents == null || contents.length() == 0) {
            return "";
        }
        return contents.replace("$name", this.name);
    }

    public String getName() {
        return this.name;
    }

    public long getCreatedTime() {
        return this.createdAt;
    }
}

