/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.TreeType;
import org.bukkit.block.Block;

public class TreeSpell
extends Spell {
    private TreeType defaultTreeType = null;
    private TreeType lastTreeType = null;

    @Override
    public SpellResult onCast(ConfigurationNode parameters) {
        boolean result;
        Block target = this.getTargetBlock();
        this.lastTreeType = null;
        if (target == null) {
            return SpellResult.NO_TARGET;
        }
        boolean requireSapling = parameters.getBoolean("require_sapling", false);
        if (requireSapling && target.getType() != Material.SAPLING) {
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(target)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        Location treeLoc = new Location(this.getWorld(), (double)target.getX(), (double)(target.getY() + 1), (double)target.getZ(), 0.0f, 0.0f);
        TreeType treeType = this.defaultTreeType;
        String typeString = parameters.getString("type", "");
        treeType = TreeSpell.parseTreeString(typeString, this.defaultTreeType);
        if (treeType == null) {
            treeType = TreeType.values()[(int)(Math.random() * (double)TreeType.values().length)];
        }
        if (result = this.getWorld().generateTree(treeLoc, treeType)) {
            this.controller.updateBlock(target);
            this.lastTreeType = treeType;
        }
        return result ? SpellResult.CAST : SpellResult.FAIL;
    }

    public String getTreeName(TreeType treeType) {
        return treeType.name().toLowerCase();
    }

    public static TreeType parseTreeString(String s, TreeType defaultTreeType) {
        if (s.equalsIgnoreCase("big")) {
            return TreeType.BIG_TREE;
        }
        if (s.equalsIgnoreCase("tall")) {
            return TreeType.TALL_REDWOOD;
        }
        TreeType tree = defaultTreeType;
        TreeType[] treeTypeArray = TreeType.values();
        int n = treeTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeType t = treeTypeArray[n2];
            if (t.name().equalsIgnoreCase(s)) {
                tree = t;
            }
            ++n2;
        }
        return tree;
    }

    @Override
    public String getMessage(String messageKey, String def) {
        String message = super.getMessage(messageKey, def);
        return message.replace("$tree", this.getTreeName(this.lastTreeType));
    }
}

