/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.effects.EffectUtils;
import com.elmakers.mine.bukkit.effects.ParticleType;
import com.elmakers.mine.bukkit.plugins.magic.MagicPlugin;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.plugins.magic.wand.LostWand;
import com.elmakers.mine.bukkit.utilities.Target;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class RecallSpell
extends Spell {
    public Location location;
    public boolean isActive;
    private static int MAX_RETRY_COUNT = 8;
    private static int RETRY_INTERVAL = 10;
    private int retryCount = 0;
    private RecallType selectedType = RecallType.MARKER;

    @Override
    public SpellResult onCast(ConfigurationNode parameters) {
        int selectedTypeIndex = 0;
        boolean allowMarker = true;
        ArrayList<RecallType> enabledTypes = new ArrayList<RecallType>();
        RecallType[] recallTypeArray = RecallType.values();
        int n = recallTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            RecallType testType = recallTypeArray[n2];
            if (parameters.getBoolean("allow_" + testType.name().toLowerCase(), true)) {
                enabledTypes.add(testType);
                if (testType == this.selectedType) {
                    selectedTypeIndex = enabledTypes.size() - 1;
                }
            } else if (testType == RecallType.MARKER) {
                allowMarker = false;
            }
            ++n2;
        }
        if (parameters.containsKey("type")) {
            String typeString = parameters.getString("type", "");
            if (this.isActive && typeString.equalsIgnoreCase("remove")) {
                this.removeMarker();
                return SpellResult.TARGET_SELECTED;
            }
            RecallType newType = RecallType.valueOf(typeString.toUpperCase());
            if (newType == null) {
                this.controller.getLogger().warning("Unknown recall type " + typeString);
                return SpellResult.FAIL;
            }
            this.selectedType = newType;
        } else if (this.getYRotation() > 70.0 || this.getYRotation() < -70.0 || !allowMarker) {
            selectedTypeIndex = this.getYRotation() > 70.0 ? ++selectedTypeIndex : --selectedTypeIndex;
            if (selectedTypeIndex < 0) {
                selectedTypeIndex = enabledTypes.size() - 1;
            }
            if (selectedTypeIndex >= enabledTypes.size()) {
                selectedTypeIndex = 0;
            }
            this.selectedType = (RecallType)((Object)enabledTypes.get(selectedTypeIndex));
        } else {
            Target target = this.getTarget();
            if (!target.isBlock()) {
                return SpellResult.NO_TARGET;
            }
            return this.placeMarker(target.getBlock());
        }
        Player player = this.getPlayer();
        if (player == null) {
            return SpellResult.PLAYER_REQUIRED;
        }
        switch (this.selectedType) {
            case MARKER: {
                if (!this.isActive) {
                    return this.placeMarker(this.getLocation().getBlock());
                }
                this.castMessage(this.getMessage("cast_marker"));
                this.tryTeleport(this.location);
                break;
            }
            case DEATH: {
                Location deathLocation = this.mage.getLastDeathLocation();
                if (deathLocation == null) {
                    this.sendMessage(this.getMessage("no_target_death"));
                    return SpellResult.NO_TARGET;
                }
                this.castMessage(this.getMessage("cast_death"));
                this.tryTeleport(deathLocation);
                return SpellResult.CAST;
            }
            case SPAWN: {
                this.castMessage(this.getMessage("cast_spawn"));
                this.tryTeleport(this.getWorld().getSpawnLocation());
                break;
            }
            case HOME: {
                this.castMessage(this.getMessage("cast_home"));
                this.tryTeleport(player.getBedSpawnLocation());
                break;
            }
            case WAND: {
                Location wandLocation;
                List<LostWand> lostWands = this.mage.getLostWands();
                Location location = wandLocation = lostWands.size() > 0 ? lostWands.get(0).getLocation() : null;
                if (wandLocation == null) {
                    this.sendMessage(this.getMessage("no_target_wand"));
                    return SpellResult.NO_TARGET;
                }
                this.castMessage(this.getMessage("cast_wand"));
                this.tryTeleport(wandLocation);
                return SpellResult.CAST;
            }
            default: {
                return SpellResult.FAIL;
            }
        }
        return SpellResult.CAST;
    }

    protected boolean removeMarker() {
        if (!this.isActive || this.location == null) {
            return false;
        }
        this.isActive = false;
        return true;
    }

    protected void tryTeleport(final Location targetLocation) {
        Player player;
        Chunk chunk = targetLocation.getBlock().getChunk();
        if (!chunk.isLoaded()) {
            chunk.load(true);
            if (this.retryCount < MAX_RETRY_COUNT) {
                MagicPlugin plugin = this.controller.getPlugin();
                final RecallSpell me = this;
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)plugin, new Runnable(){

                    @Override
                    public void run() {
                        me.tryTeleport(targetLocation);
                    }
                }, (long)RETRY_INTERVAL);
                return;
            }
        }
        if ((player = this.getPlayer()) != null) {
            Location playerLocation = player.getLocation();
            targetLocation.setYaw(playerLocation.getYaw());
            targetLocation.setPitch(playerLocation.getPitch());
            player.teleport(this.tryFindPlaceToStand(targetLocation));
        }
    }

    protected SpellResult placeMarker(Block target) {
        if (target == null) {
            return SpellResult.NO_TARGET;
        }
        Block targetBlock = target.getRelative(BlockFace.UP);
        if (targetBlock.getType() != Material.AIR) {
            targetBlock = this.getFaceBlock();
        }
        if (targetBlock.getType() != Material.AIR) {
            return SpellResult.NO_TARGET;
        }
        if (this.removeMarker()) {
            this.castMessage(this.getMessage("cast_marker_move"));
        } else {
            this.castMessage(this.getMessage("cast_marker_place"));
        }
        this.location = this.getLocation();
        this.location.setX((double)targetBlock.getX());
        this.location.setY((double)targetBlock.getY());
        this.location.setZ((double)targetBlock.getZ());
        this.getPlayer().setCompassTarget(this.location);
        EffectUtils.playEffect(targetBlock.getLocation(), ParticleType.CLOUD, 1.0f, 1);
        this.isActive = true;
        return SpellResult.CAST;
    }

    @Override
    public void onLoad(ConfigurationNode node) {
        this.isActive = node.getBoolean("active", false);
        this.location = node.getLocation("location");
    }

    @Override
    public void onSave(ConfigurationNode node) {
        node.setProperty("active", this.isActive);
        node.setProperty("location", this.location);
    }

    private static enum RecallType {
        MARKER,
        DEATH,
        SPAWN,
        HOME,
        WAND;

    }
}

