/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.MagicPlugin;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PhaseSpell
extends Spell {
    private static int MAX_RETRY_COUNT = 8;
    private static int RETRY_INTERVAL = 10;
    private int retryCount = 0;

    @Override
    public SpellResult onCast(ConfigurationNode parameters) {
        int maxY = 250;
        Location playerLocation = this.getLocation();
        String worldName = playerLocation.getWorld().getName();
        Location targetLocation = null;
        if (worldName.contains("_the_end")) {
            World targetWorld = Bukkit.getWorld((String)(worldName = worldName.replace("_the_end", "")));
            if (targetWorld != null) {
                targetLocation = targetWorld.getSpawnLocation();
            }
        } else if (worldName.contains("_nether")) {
            World targetWorld = Bukkit.getWorld((String)(worldName = worldName.replace("_nether", "")));
            if (targetWorld != null) {
                targetLocation = new Location(targetWorld, playerLocation.getX() * 8.0, playerLocation.getY(), playerLocation.getZ() * 8.0);
            }
        } else {
            maxY = 118;
            World targetWorld = Bukkit.getWorld((String)(worldName = String.valueOf(worldName) + "_nether"));
            if (targetWorld != null) {
                targetLocation = new Location(targetWorld, playerLocation.getX() / 8.0, Math.min(125.0, playerLocation.getY()), playerLocation.getZ() / 8.0);
            }
        }
        if (targetLocation == null) {
            return SpellResult.NO_TARGET;
        }
        this.retryCount = 0;
        this.tryPhase(targetLocation, maxY);
        return SpellResult.CAST;
    }

    protected void tryPhase(final Location targetLocation, final int maxY) {
        Player player;
        Chunk chunk = targetLocation.getBlock().getChunk();
        if (!chunk.isLoaded()) {
            chunk.load(true);
            if (this.retryCount < MAX_RETRY_COUNT) {
                MagicPlugin plugin = this.controller.getPlugin();
                final PhaseSpell me = this;
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)plugin, new Runnable(){

                    @Override
                    public void run() {
                        me.tryPhase(targetLocation, maxY);
                    }
                }, (long)RETRY_INTERVAL);
                return;
            }
        }
        if ((player = this.getPlayer()) != null) {
            Location playerLocation = player.getLocation();
            targetLocation.setYaw(playerLocation.getYaw());
            targetLocation.setPitch(playerLocation.getPitch());
            Location destination = this.tryFindPlaceToStand(targetLocation, 4, maxY);
            if (destination != null) {
                player.teleport(destination);
            }
        }
    }
}

