/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.blocks.ConstructBatch;
import com.elmakers.mine.bukkit.blocks.ConstructionType;
import com.elmakers.mine.bukkit.blocks.MaterialBrush;
import com.elmakers.mine.bukkit.plugins.magic.BrushSpell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.plugins.magic.TargetType;
import com.elmakers.mine.bukkit.utilities.Target;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.HashSet;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.util.Vector;

public class ConstructSpell
extends BrushSpell {
    private static final ConstructionType DEFAULT_CONSTRUCTION_TYPE = ConstructionType.SPHERE;
    private static final int DEFAULT_RADIUS = 2;
    private static final int DEFAULT_MAX_DIMENSION = 128;
    private Block targetBlock = null;
    private boolean powered = false;

    @Override
    public SpellResult onCast(ConfigurationNode parameters) {
        String typeString;
        ConstructionType testType;
        Target t = this.getTarget();
        Block target = t.getBlock();
        if (target == null) {
            return SpellResult.NO_TARGET;
        }
        int timeToLive = parameters.getInt("undo", 0);
        int radius = parameters.getInt("radius", 2);
        radius = parameters.getInt("r", radius);
        radius = parameters.getInt("size", radius);
        boolean falling = parameters.getBoolean("falling", false);
        float force = 0.0f;
        force = (float)parameters.getDouble("speed", force);
        Location orientTo = null;
        if (this.getTargetType() == TargetType.SELECT) {
            if (this.targetBlock == null) {
                this.targetBlock = target;
                this.activate();
                return SpellResult.TARGET_SELECTED;
            }
            radius = (int)this.targetBlock.getLocation().distance(target.getLocation());
            orientTo = target.getLocation();
            target = this.targetBlock;
        }
        int maxDimension = parameters.getInteger("max_dimension", 128);
        maxDimension = parameters.getInteger("md", maxDimension);
        int diameter = radius * 2;
        maxDimension = (int)(this.mage.getConstructionMultiplier() * (float)maxDimension);
        if (diameter > maxDimension) {
            return SpellResult.FAIL;
        }
        if (!this.hasBuildPermission(target)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        if (parameters.getBoolean("replace", false)) {
            HashSet<Material> destructible = new HashSet<Material>();
            Material targetMaterial = this.targetBlock != null ? this.targetBlock.getType() : target.getType();
            destructible.add(targetMaterial);
            if (targetMaterial == Material.STATIONARY_WATER) {
                destructible.add(Material.WATER);
            } else if (targetMaterial == Material.WATER) {
                destructible.add(Material.STATIONARY_WATER);
            } else if (targetMaterial == Material.STATIONARY_LAVA) {
                destructible.add(Material.LAVA);
            } else if (targetMaterial == Material.LAVA) {
                destructible.add(Material.STATIONARY_LAVA);
            }
            this.setDestructible(destructible);
        }
        if (parameters.containsKey("y_offset")) {
            target = target.getRelative(BlockFace.UP, parameters.getInt("y_offset", 0));
        }
        MaterialBrush buildWith = this.getMaterialBrush();
        buildWith.setTarget(target.getLocation());
        ConstructionType conType = DEFAULT_CONSTRUCTION_TYPE;
        boolean hollow = false;
        String fillType = parameters.getString("fill", "");
        hollow = fillType.equals("hollow");
        Vector forceVector = null;
        if (falling && force != 0.0f) {
            forceVector = this.getLocation().getDirection();
            forceVector.setY(-forceVector.getY()).normalize().multiply(force);
        }
        if ((testType = ConstructionType.parseString(typeString = parameters.getString("type", ""), ConstructionType.UNKNOWN)) != ConstructionType.UNKNOWN) {
            conType = testType;
        }
        ConstructBatch batch = new ConstructBatch(this, target.getLocation(), conType, radius, !hollow, falling, orientTo);
        if (forceVector != null) {
            batch.setFallingBlockVelocity(forceVector);
        }
        if (parameters.containsKey("orient_dimension_max")) {
            batch.setOrientDimensionMax(parameters.getInteger("orient_dimension_max", null));
        }
        if (parameters.containsKey("orient_dimension_min")) {
            batch.setOrientDimensionMin(parameters.getInteger("orient_dimension_min", null));
        }
        if (timeToLive > 0) {
            batch.setTimeToLive(timeToLive);
        }
        if (parameters.getBoolean("power", false)) {
            batch.setPower(true);
        }
        this.mage.addPendingBlockBatch(batch);
        this.deactivate();
        return SpellResult.CAST;
    }

    @Override
    public void onDeactivate() {
        this.targetBlock = null;
    }

    @Override
    public boolean onCancel() {
        if (this.targetBlock != null) {
            this.deactivate();
            return true;
        }
        return false;
    }

    @Override
    public boolean hasBrushOverride() {
        return this.powered || super.hasBrushOverride();
    }

    @Override
    protected void loadTemplate(ConfigurationNode node) {
        super.loadTemplate(node);
        this.powered = this.parameters.getBoolean("power", false);
    }
}

