/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.blocks.BlockList;
import com.elmakers.mine.bukkit.plugins.magic.BlockSpell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.Target;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.List;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Wolf;

public class AlterSpell
extends BlockSpell {
    static final String DEFAULT_ADJUSTABLES = "3 ,5, 6, 8, 9, 10,11,12,17,162,18,161,23,24,27,28,29,31,33,35,37,38,43,44,50,52,53,54,55,58,59,60,61,62,63,64,65,66,67,68,69,71,75,76,77,78,81,83,85,86,93,94,95,98,99,100,104,105,108,109,114,115,125,126,128,134,135,136,140,141,142,144,155,156,159,160,171,172,175";
    static final String DEFAULT_ADJUST_MAX = "2 ,5, 5 ,15,15,15,15,1 ,15,15 ,3 ,1  ,5 ,2 ,9 ,9 ,5 ,2 ,5 ,15,8 ,8 ,15,15,5, 15,3 ,5 ,15,5 ,7 ,8 ,5 ,5 ,15,15,3 ,9 ,3 ,2 ,14,15,5 ,5 ,15,7 ,15,15,5 ,0 ,5 ,5 ,15 ,3 ,15,15 ,7  ,7  ,3  ,3  ,3  ,7  ,15 ,15 ,3  ,3  ,3  ,3  ,15 ,7  ,7  ,4  ,4  ,3  ,15 ,15 ,15 ,15 ,6";
    static final String DEFAULT_ADJUST_MIN = "0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0  ,0 ,0  ,2 ,0 ,0, 0, 0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,2 ,0 ,2 ,0 ,0 ,2 ,2 ,0 ,0 ,0 ,0 ,0 ,5 ,6 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,3 ,2 ,2 ,0  ,0 ,0 ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0";
    static final int DEFAULT_RECURSE_DISTANCE = 0;

    @Override
    public SpellResult onCast(ConfigurationNode parameters) {
        SpellResult result;
        Target target = this.getTarget();
        if (target.isEntity() && (result = this.alterEntity(target.getEntity())) != SpellResult.NO_TARGET) {
            return result;
        }
        Block targetBlock = target.getBlock();
        if (targetBlock == null) {
            return SpellResult.NO_TARGET;
        }
        int recurseDistance = parameters.getInteger("depth", 0);
        recurseDistance = (int)(this.mage.getRadiusMultiplier() * (float)recurseDistance);
        List<Integer> adjustableMaterials = csv.parseIntegers(DEFAULT_ADJUSTABLES);
        List<Integer> maxData = csv.parseIntegers(DEFAULT_ADJUST_MAX);
        List<Integer> minData = csv.parseIntegers(DEFAULT_ADJUST_MIN);
        if (adjustableMaterials.size() != maxData.size() || maxData.size() != minData.size()) {
            this.controller.getLogger().warning("Spells:Alter: Mis-match in adjustable material lists!");
        }
        if (!adjustableMaterials.contains(targetBlock.getTypeId())) {
            return SpellResult.FAIL;
        }
        if (!this.hasBuildPermission(targetBlock)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        if (this.mage.isIndestructible(targetBlock)) {
            return SpellResult.NO_TARGET;
        }
        BlockList undoList = new BlockList();
        byte originalData = targetBlock.getData();
        int materialIndex = adjustableMaterials.indexOf(targetBlock.getTypeId());
        int minValue = minData.get(materialIndex);
        int maxValue = maxData.get(materialIndex);
        int dataSize = maxValue - minValue + 1;
        byte data = (byte)((originalData - minValue + 1) % dataSize + minValue);
        boolean recursive = recurseDistance > 0;
        this.adjust(targetBlock, data, undoList, recursive, recurseDistance, 0);
        this.registerForUndo(undoList);
        this.controller.updateBlock(targetBlock);
        return SpellResult.CAST;
    }

    protected void adjust(Block block, byte dataValue, BlockList adjustedBlocks, boolean recursive, int recurseDistance, int rDepth) {
        adjustedBlocks.add(block);
        block.setData(dataValue);
        if (recursive && rDepth < recurseDistance) {
            Material targetMaterial = block.getType();
            this.tryAdjust(block.getRelative(BlockFace.NORTH), dataValue, targetMaterial, adjustedBlocks, recurseDistance, rDepth + 1);
            this.tryAdjust(block.getRelative(BlockFace.WEST), dataValue, targetMaterial, adjustedBlocks, recurseDistance, rDepth + 1);
            this.tryAdjust(block.getRelative(BlockFace.SOUTH), dataValue, targetMaterial, adjustedBlocks, recurseDistance, rDepth + 1);
            this.tryAdjust(block.getRelative(BlockFace.EAST), dataValue, targetMaterial, adjustedBlocks, recurseDistance, rDepth + 1);
            this.tryAdjust(block.getRelative(BlockFace.UP), dataValue, targetMaterial, adjustedBlocks, recurseDistance, rDepth + 1);
            this.tryAdjust(block.getRelative(BlockFace.DOWN), dataValue, targetMaterial, adjustedBlocks, recurseDistance, rDepth + 1);
        }
    }

    protected SpellResult alterEntity(Entity entity) {
        EntityType entityType = entity.getType();
        switch (entityType) {
            case HORSE: {
                Horse horse = (Horse)entity;
                Horse.Color color = horse.getColor();
                Horse.Color[] colorValues = Horse.Color.values();
                color = colorValues[(color.ordinal() + 1) % colorValues.length];
                Horse.Variant variant = horse.getVariant();
                Horse.Variant[] variantValues = Horse.Variant.values();
                variant = variantValues[(variant.ordinal() + 1) % variantValues.length];
                Horse.Style horseStyle = horse.getStyle();
                Horse.Style[] styleValues = Horse.Style.values();
                horseStyle = styleValues[(horseStyle.ordinal() + 1) % styleValues.length];
                horse.setStyle(horseStyle);
                horse.setColor(color);
                horse.setVariant(variant);
                break;
            }
            case OCELOT: {
                Ocelot ocelot = (Ocelot)entity;
                Ocelot.Type catType = ocelot.getCatType();
                Ocelot.Type[] typeValues = Ocelot.Type.values();
                catType = typeValues[(catType.ordinal() + 1) % typeValues.length];
                ocelot.setCatType(catType);
                break;
            }
            case VILLAGER: {
                Villager villager = (Villager)entity;
                Villager.Profession profession = villager.getProfession();
                Villager.Profession[] professionValues = Villager.Profession.values();
                profession = professionValues[(profession.ordinal() + 1) % professionValues.length];
                villager.setProfession(profession);
                break;
            }
            case WOLF: {
                Wolf wolf = (Wolf)entity;
                DyeColor dyeColor = wolf.getCollarColor();
                DyeColor[] dyeColorValues = DyeColor.values();
                dyeColor = dyeColorValues[(dyeColor.ordinal() + 1) % dyeColorValues.length];
                wolf.setCollarColor(dyeColor);
                break;
            }
            case SHEEP: {
                Sheep sheep = (Sheep)entity;
                DyeColor dyeColor = sheep.getColor();
                DyeColor[] dyeColorValues = DyeColor.values();
                dyeColor = dyeColorValues[(dyeColor.ordinal() + 1) % dyeColorValues.length];
                sheep.setColor(dyeColor);
                break;
            }
            case SKELETON: {
                Skeleton skeleton = (Skeleton)entity;
                Skeleton.SkeletonType skeletonType = skeleton.getSkeletonType();
                Skeleton.SkeletonType[] skeletonTypeValues = Skeleton.SkeletonType.values();
                skeletonType = skeletonTypeValues[(skeletonType.ordinal() + 1) % skeletonTypeValues.length];
                skeleton.setSkeletonType(skeletonType);
                break;
            }
            default: {
                return SpellResult.NO_TARGET;
            }
        }
        return SpellResult.CAST;
    }

    protected void tryAdjust(Block target, byte dataValue, Material targetMaterial, BlockList adjustedBlocks, int recurseDistance, int rDepth) {
        if (target.getType() != targetMaterial || adjustedBlocks.contains(target)) {
            return;
        }
        this.adjust(target, dataValue, adjustedBlocks, true, recurseDistance, rDepth);
    }
}

