/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.blocks;

import com.elmakers.mine.bukkit.blocks.BlockData;
import com.elmakers.mine.bukkit.blocks.BlockList;
import com.elmakers.mine.bukkit.blocks.VolumeBatch;
import com.elmakers.mine.bukkit.plugins.magic.BlockSpell;
import com.elmakers.mine.bukkit.plugins.magic.Mage;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.CommandBlock;

public class SimulateBatch
extends VolumeBatch {
    private static BlockFace[] neighborFaces = new BlockFace[]{BlockFace.NORTH, BlockFace.NORTH_EAST, BlockFace.EAST, BlockFace.SOUTH_EAST, BlockFace.SOUTH, BlockFace.SOUTH_WEST, BlockFace.WEST, BlockFace.NORTH_WEST};
    private static Material POWER_MATERAIL = Material.REDSTONE_BLOCK;
    private static int COMMAND_UPDATE_DELAY = 0;
    private Mage mage;
    private BlockSpell spell;
    private Block castCommandBlock;
    private int commandDistanceSquared;
    private String castCommand;
    private Block commandTarget;
    private World world;
    private Material birthMaterial;
    private Material deathMaterial;
    private boolean includeCommands;
    private BlockFace powerDirection;
    int y;
    int startX;
    int startZ;
    int endX;
    int endZ;
    int x;
    int z;
    int updatingIndex;
    int commandDelay;
    int blockCount;
    private SimulationState state;
    BlockList deadBlocks = new BlockList();
    BlockList bornBlocks = new BlockList();
    BlockList modifiedBlocks = new BlockList();

    public SimulateBatch(BlockSpell spell, Location center, int radius, Material birth, Material death) {
        super(spell.getMage().getController(), center.getWorld().getName());
        this.mage = spell.getMage();
        this.spell = spell;
        this.birthMaterial = birth;
        this.deathMaterial = death;
        this.world = center.getWorld();
        this.includeCommands = false;
        this.y = center.getBlockY();
        this.startX = center.getBlockX() - radius / 2;
        this.startZ = center.getBlockZ() - radius / 2;
        this.endX = center.getBlockX() + radius / 2;
        this.endZ = center.getBlockZ() + radius / 2;
        this.x = this.startX;
        this.z = this.startZ;
        this.state = SimulationState.SCANNING;
        this.updatingIndex = 0;
        this.commandDistanceSquared = 0;
        this.commandDelay = 0;
        this.powerDirection = null;
        this.blockCount = 0;
    }

    @Override
    public int process(int maxBlocks) {
        int processedBlocks = 0;
        while (this.state == SimulationState.SCANNING && processedBlocks <= maxBlocks) {
            Block block = this.world.getBlockAt(this.x, this.y, this.z);
            if (!block.getChunk().isLoaded()) {
                block.getChunk().load();
                return processedBlocks;
            }
            Material blockMaterial = block.getType();
            if (blockMaterial == this.birthMaterial) {
                int neighborCount = this.getNeighborCount(block, this.birthMaterial, this.includeCommands);
                if (neighborCount < 2 || neighborCount > 3) {
                    this.deadBlocks.add(block);
                } else {
                    ++this.blockCount;
                }
            } else if (blockMaterial == this.deathMaterial) {
                if (this.getNeighborCount(block, this.birthMaterial, this.includeCommands) == 3) {
                    this.bornBlocks.add(block);
                    ++this.blockCount;
                }
            } else if (this.includeCommands && blockMaterial == Material.COMMAND && this.castCommandBlock != null && BlockData.getBlockId(block) == BlockData.getBlockId(this.castCommandBlock)) {
                int neighborCount = this.getNeighborCount(block, this.birthMaterial, this.includeCommands);
                if (neighborCount < 2 || neighborCount > 3) {
                    this.deadBlocks.add(block);
                } else {
                    this.commandTarget = block;
                    ++this.blockCount;
                }
            }
            ++this.z;
            if (this.z > this.endZ) {
                this.z = this.startZ;
                ++this.x;
            }
            if (this.x <= this.endX) continue;
            if (this.castCommandBlock != null && this.castCommandBlock.getType() == Material.COMMAND) {
                if (this.castCommandBlock.getRelative(BlockFace.DOWN).getType() == POWER_MATERAIL) {
                    this.powerDirection = BlockFace.DOWN;
                } else if (this.castCommandBlock.getRelative(BlockFace.UP).getType() == POWER_MATERAIL) {
                    this.powerDirection = BlockFace.UP;
                }
                if (this.powerDirection != null) {
                    Block powerBlock = this.castCommandBlock.getRelative(this.powerDirection);
                    this.modifiedBlocks.add(powerBlock);
                    powerBlock.setType(Material.AIR);
                }
            }
            this.state = SimulationState.UPDATING;
        }
        while (this.state == SimulationState.UPDATING && processedBlocks <= maxBlocks) {
            ArrayList<BlockData> deadBlockList = this.deadBlocks.getBlockList();
            if (deadBlockList != null && this.updatingIndex < deadBlockList.size()) {
                BlockData killBlock = (BlockData)deadBlockList.get(this.updatingIndex);
                this.modifiedBlocks.add(killBlock);
                Block block = killBlock.getBlock();
                block.setType(this.deathMaterial);
                this.controller.updateBlock(block);
                ++processedBlocks;
            }
            ArrayList<BlockData> bornBlockList = this.bornBlocks.getBlockList();
            int bornIndex = this.updatingIndex - this.deadBlocks.size();
            if (bornBlockList != null && bornIndex >= 0 && bornIndex < bornBlockList.size()) {
                BlockData birthBlock = (BlockData)bornBlockList.get(bornIndex);
                this.modifiedBlocks.add(birthBlock);
                Block block = birthBlock.getBlock();
                if (this.includeCommands && (this.commandTarget == null || block.getLocation().distanceSquared(this.commandTarget.getLocation()) < (double)this.commandDistanceSquared)) {
                    this.commandTarget = block;
                }
                block.setType(this.birthMaterial);
                this.controller.updateBlock(block);
            }
            ++this.updatingIndex;
            if (this.updatingIndex <= this.deadBlocks.size() + this.bornBlocks.size()) continue;
            this.state = SimulationState.COMMAND;
            return maxBlocks;
        }
        if (this.state == SimulationState.COMMAND) {
            if (this.commandTarget != null && this.commandDelay == 0) {
                this.commandTarget.setType(Material.AIR);
            }
            ++this.commandDelay;
            if (this.commandDelay >= COMMAND_UPDATE_DELAY) {
                if (this.commandTarget != null) {
                    this.commandTarget.setType(Material.COMMAND);
                    BlockState commandData = this.commandTarget.getState();
                    if (this.castCommand != null && commandData != null && commandData instanceof CommandBlock) {
                        Block powerBlock;
                        CommandBlock copyCommand = (CommandBlock)commandData;
                        copyCommand.setCommand(this.castCommand);
                        copyCommand.update();
                        if (this.powerDirection != null && this.spell.isDestructible(powerBlock = this.commandTarget.getRelative(this.powerDirection))) {
                            this.commandTarget.getRelative(this.powerDirection).setType(POWER_MATERAIL);
                            this.modifiedBlocks.add(powerBlock);
                        }
                    }
                }
                this.state = SimulationState.CLEANUP;
            }
            return maxBlocks;
        }
        if (this.state == SimulationState.CLEANUP) {
            if (this.blockCount == 0 && this.powerDirection != null && this.commandTarget != null && this.commandTarget.getRelative(this.powerDirection).getType() == POWER_MATERAIL) {
                Block powerBlock = this.commandTarget.getRelative(this.powerDirection);
                this.modifiedBlocks.add(powerBlock);
                powerBlock.setType(Material.AIR);
            }
            this.state = SimulationState.FINISHED;
            return maxBlocks;
        }
        if (this.state == SimulationState.FINISHED) {
            this.finish();
        }
        return processedBlocks;
    }

    public void setCommandBlock(Block block) {
        this.castCommandBlock = block;
        if (this.castCommandBlock.getType() == Material.COMMAND) {
            BlockState commandData = this.castCommandBlock.getState();
            if (commandData != null && commandData instanceof CommandBlock) {
                this.castCommand = ((CommandBlock)commandData).getCommand();
            }
            this.includeCommands = this.castCommand != null && this.castCommand.length() > 0;
        }
    }

    protected int getNeighborCount(Block block, Material liveMaterial, boolean includeCommands) {
        int liveCount = 0;
        BlockFace[] blockFaceArray = neighborFaces;
        int n = neighborFaces.length;
        int n2 = 0;
        while (n2 < n) {
            BlockFace face = blockFaceArray[n2];
            Material neighborType = block.getRelative(face).getType();
            if (neighborType == liveMaterial || includeCommands && neighborType == Material.COMMAND) {
                ++liveCount;
            }
            ++n2;
        }
        return liveCount;
    }

    @Override
    public void finish() {
        if (!this.finished) {
            super.finish();
            this.mage.registerForUndo(this.modifiedBlocks);
        }
    }

    private static enum SimulationState {
        SCANNING,
        UPDATING,
        COMMAND,
        CLEANUP,
        FINISHED;

    }
}

