/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utilities;

import com.elmakers.mine.bukkit.utilities.NMSUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class LightSource
extends NMSUtils {
    public static void createLightSource(Location l, int level) {
        LightSource.createLightSource(l, level, null);
    }

    public static void createLightSource(Location l, int level, Collection<Player> players) {
        Object blockEnum = Enum.valueOf(class_EnumSkyBlock, "Block");
        Method addLightMethod = null;
        Object worldHandle = LightSource.getHandle(l.getWorld());
        try {
            addLightMethod = class_World.getMethod("b", class_EnumSkyBlock, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable ex) {
            addLightMethod = null;
            ex.printStackTrace();
        }
        if (worldHandle == null || addLightMethod == null) {
            return;
        }
        try {
            addLightMethod.invoke(worldHandle, blockEnum, l.getBlockX(), l.getBlockY(), l.getBlockZ(), level);
            LightSource.updateChunk(l, players);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public static void deleteLightSource(Location l) {
        LightSource.deleteLightSource(l, null);
    }

    public static void deleteLightSource(Location l, Collection<Player> players) {
        int t = l.getBlock().getTypeId();
        l.getBlock().setTypeId(t == 1 ? 2 : 1);
        LightSource.updateChunk(l, players);
        l.getBlock().setTypeId(t);
    }

    private static void updateChunk(Location l, Collection<Player> players) {
        try {
            Constructor packetConstructor;
            ArrayList<Object> chunks = new ArrayList<Object>();
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    chunks.add(LightSource.getHandle(l.clone().add((double)(16 * x), 0.0, (double)(16 * z)).getChunk()));
                }
            }
            Object packet = null;
            if (class_PacketPlayOutMapChunkBulk != null) {
                packetConstructor = class_PacketPlayOutMapChunkBulk.getConstructor(List.class);
                packet = packetConstructor.newInstance(chunks);
            } else {
                packetConstructor = class_Packet56MapChunkBulk.getConstructor(List.class);
                packet = packetConstructor.newInstance(chunks);
            }
            int t = l.clone().add(0.0, 1.0, 0.0).getBlock().getTypeId();
            l.clone().add(0.0, 1.0, 0.0).getBlock().setTypeId(t == 1 ? 2 : 1);
            LightSource.sendPacket(l, players, packet);
            l.clone().add(0.0, 1.0, 0.0).getBlock().setTypeId(t);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

