/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.blocks.SimulateBatch;
import com.elmakers.mine.bukkit.plugins.magic.BlockSpell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.Target;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.ArrayList;
import java.util.HashSet;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class SimulateSpell
extends BlockSpell {
    private static final int DEFAULT_RADIUS = 32;
    private Integer taskId = null;

    @Override
    public SpellResult onCast(ConfigurationNode parameters) {
        Target t = this.getTarget();
        if (t == null) {
            return SpellResult.NO_TARGET;
        }
        Block target = t.getBlock();
        if (target == null) {
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(target)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        int radius = parameters.getInt("radius", 32);
        radius = parameters.getInt("r", radius);
        radius = (int)((float)radius * this.mage.getConstructionMultiplier());
        int yRadius = parameters.getInt("yradius", 0);
        yRadius = (int)((float)yRadius * this.mage.getConstructionMultiplier());
        Material birthMaterial = target.getType();
        birthMaterial = parameters.getMaterial("material", birthMaterial);
        birthMaterial = parameters.getMaterial("m", birthMaterial);
        Double dmxValue = parameters.getDouble("dmx", null);
        Double dmyValue = parameters.getDouble("dmy", null);
        Double dmzValue = parameters.getDouble("dmz", null);
        if (dmxValue != null || dmyValue != null || dmzValue != null) {
            Vector offset = new Vector(dmxValue == null ? 0.0 : dmxValue, dmyValue == null ? 0.0 : dmyValue, dmzValue == null ? 0.0 : dmzValue);
            Location targetLocation = target.getLocation().add(offset);
            if (!targetLocation.getBlock().getChunk().isLoaded()) {
                return SpellResult.FAIL;
            }
            birthMaterial = targetLocation.getBlock().getType();
        }
        Material deathMaterial = parameters.getMaterial("death_material", Material.AIR);
        HashSet<Integer> birthCounts = new HashSet<Integer>();
        HashSet<Integer> liveCounts = new HashSet<Integer>();
        if (parameters.containsKey("live_rules")) {
            liveCounts.addAll(parameters.getIntList("live_rules", new ArrayList<Integer>()));
        } else {
            liveCounts.add(2);
            liveCounts.add(3);
        }
        if (parameters.containsKey("birth_rules")) {
            birthCounts.addAll(parameters.getIntList("birth_rules", new ArrayList<Integer>()));
        } else {
            birthCounts.add(3);
        }
        if (liveCounts.size() == 0 || birthCounts.size() == 0) {
            return SpellResult.FAIL;
        }
        Location location = this.getLocation();
        Location targetLocation = target.getLocation();
        targetLocation.setPitch(location.getPitch());
        targetLocation.setYaw(location.getYaw());
        final SimulateBatch batch = new SimulateBatch(this, targetLocation, radius, yRadius, birthMaterial, deathMaterial, liveCounts, birthCounts);
        boolean includeCommands = parameters.getBoolean("animate", false);
        if (includeCommands) {
            if (this.mage.getCommandSender() instanceof BlockCommandSender) {
                BlockCommandSender commandBlock = (BlockCommandSender)this.mage.getCommandSender();
                batch.setCommandBlock(commandBlock.getBlock());
            } else if (target.getType() == Material.COMMAND) {
                batch.setCommandBlock(target);
            }
            SimulateBatch.TargetMode targetMode = null;
            String targetModeString = parameters.getString("target_mode", "");
            if (targetModeString.length() > 0) {
                try {
                    targetMode = SimulateBatch.TargetMode.valueOf(targetModeString.toUpperCase());
                }
                catch (Exception ex) {
                    this.controller.getLogger().warning(ex.getMessage());
                }
            }
            batch.setCommandMoveRange(parameters.getInt("move", 3), parameters.getBoolean("reload", true));
            SimulateBatch.TargetType targetType = null;
            String targetTypeString = parameters.getString("target_types", "");
            if (targetTypeString.length() > 0) {
                try {
                    targetType = SimulateBatch.TargetType.valueOf(targetTypeString.toUpperCase());
                }
                catch (Exception ex) {
                    this.controller.getLogger().warning(ex.getMessage());
                }
            }
            batch.setTargetType(targetType);
            batch.setMinHuntRange(parameters.getInt("target_min_range", 4));
            batch.setMaxHuntRange(parameters.getInt("target_max_range", 128));
            batch.target(targetMode);
        }
        batch.setBirthRange(parameters.getInt("birth_range", 0));
        batch.setLiveRange(parameters.getInt("live_range", 0));
        int delay = parameters.getInt("delay", 0);
        boolean success = true;
        if ((delay /= 50) > 0 && this.taskId == null) {
            this.taskId = Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.controller.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    SimulateSpell.this.taskId = null;
                    SimulateSpell.this.mage.addPendingBlockBatch(batch);
                }
            }, (long)delay);
        } else {
            success = this.mage.addPendingBlockBatch(batch);
        }
        this.clearTarget();
        return success ? SpellResult.CAST : SpellResult.FAIL;
    }
}

