/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.blocks.BlockList;
import com.elmakers.mine.bukkit.plugins.magic.BlockSpell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;

public class CushionSpell
extends BlockSpell {
    private static final int DEFAULT_CUSHION_WIDTH = 3;
    private static final int DEFAULT_CUSHION_HEIGHT = 4;

    @Override
    public SpellResult onCast(ConfigurationNode parameters) {
        World world = this.getWorld();
        Block targetFace = this.getTargetBlock();
        if (targetFace == null) {
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(targetFace)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        int cushionWidth = parameters.getInteger("width", 3);
        int cushionHeight = parameters.getInteger("height", 4);
        BlockList cushionBlocks = new BlockList();
        cushionBlocks.setTimeToLive(7000);
        this.controller.disablePhysics(8000);
        int bubbleStart = -cushionWidth / 2;
        int bubbleEnd = cushionWidth / 2;
        int dx = bubbleStart;
        while (dx < bubbleEnd) {
            int dz = bubbleStart;
            while (dz < bubbleEnd) {
                int dy = 0;
                while (dy < cushionHeight) {
                    int z;
                    int y;
                    int x = targetFace.getX() + dx;
                    Block block = world.getBlockAt(x, y = targetFace.getY() + dy, z = targetFace.getZ() + dz);
                    if (block.getType() == Material.AIR) {
                        cushionBlocks.add(block);
                        block.setType(Material.STATIONARY_WATER);
                    }
                    ++dy;
                }
                ++dz;
            }
            ++dx;
        }
        this.registerForUndo(cushionBlocks);
        return SpellResult.CAST;
    }
}

