/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.blocks.BlockList;
import com.elmakers.mine.bukkit.blocks.SimulateBatch;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.plugins.magic.spells.SimulateSpell;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.CommandBlock;
import org.bukkit.plugin.Plugin;

public class AnimateSpell
extends SimulateSpell {
    @Override
    public SpellResult onCast(ConfigurationNode parameters) {
        if (parameters.getBoolean("animate", false)) {
            return super.onCast(parameters);
        }
        Block targetBlock = this.getTargetBlock();
        if (targetBlock == null) {
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(targetBlock)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        BlockFace powerFace = SimulateBatch.findPowerLocation(targetBlock, targetBlock.getType());
        if (powerFace == null) {
            return SpellResult.NO_TARGET;
        }
        final Block powerBlock = targetBlock.getRelative(powerFace);
        final BlockList modifiedBlocks = new BlockList();
        modifiedBlocks.add(targetBlock);
        modifiedBlocks.add(powerBlock);
        if (!this.isDestructible(targetBlock) || !this.isDestructible(powerBlock)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        boolean simCheckDestructible = parameters.getBoolean("sim_check_destructible", true);
        simCheckDestructible = parameters.getBoolean("scd", simCheckDestructible);
        String commandLine = "cast " + this.getKey() + " animate true target self cooldown 0 bu true m " + targetBlock.getType().name().toLowerCase() + " cd " + (simCheckDestructible ? "true" : "false");
        String commandName = parameters.getString("name", "Automata");
        commandName = String.valueOf(this.mage.getName()) + "@" + commandName;
        targetBlock.setType(Material.COMMAND);
        BlockState commandData = targetBlock.getState();
        if (commandData == null || !(commandData instanceof CommandBlock)) {
            return SpellResult.FAIL;
        }
        CommandBlock copyCommand = (CommandBlock)commandData;
        copyCommand.setCommand(commandLine);
        copyCommand.setName(commandName);
        copyCommand.update();
        this.controller.updateBlock(targetBlock);
        Bukkit.getScheduler().runTaskLater((Plugin)this.controller.getPlugin(), new Runnable(){

            @Override
            public void run() {
                powerBlock.setType(Material.REDSTONE_BLOCK);
                AnimateSpell.this.controller.updateBlock(powerBlock);
                AnimateSpell.this.registerForUndo(modifiedBlocks);
            }
        }, 1L);
        return SpellResult.CAST;
    }
}

