/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic;

import com.elmakers.mine.bukkit.blocks.BlockBatch;
import com.elmakers.mine.bukkit.blocks.BlockList;
import com.elmakers.mine.bukkit.blocks.MaterialBrush;
import com.elmakers.mine.bukkit.blocks.UndoBatch;
import com.elmakers.mine.bukkit.blocks.UndoQueue;
import com.elmakers.mine.bukkit.plugins.magic.CostReducer;
import com.elmakers.mine.bukkit.plugins.magic.MagicController;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellEventType;
import com.elmakers.mine.bukkit.plugins.magic.wand.LostWand;
import com.elmakers.mine.bukkit.plugins.magic.wand.Wand;
import com.elmakers.mine.bukkit.utilities.InventoryUtils;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.util.Vector;

public class Mage
implements CostReducer {
    protected WeakReference<Player> player;
    protected WeakReference<CommandSender> commandSender;
    protected String playerName;
    protected final MagicController controller;
    protected HashMap<String, Spell> spells = new HashMap();
    private Inventory storedInventory = null;
    private Wand activeWand = null;
    private final List<Spell> quitListeners = new ArrayList<Spell>();
    private final List<Spell> deathListeners = new ArrayList<Spell>();
    private final List<Spell> damageListeners = new ArrayList<Spell>();
    private final Set<Spell> activeSpells = new HashSet<Spell>();
    private UndoQueue undoQueue = null;
    private LinkedList<BlockBatch> pendingBatches = new LinkedList();
    private Location location;
    private float costReduction = 0.0f;
    private float cooldownReduction = 0.0f;
    private float powerMultiplier = 1.0f;
    private long lastClick = 0L;
    private long blockPlaceTimeout = 0L;
    private Location lastDeathLocation = null;
    private final MaterialBrush brush;
    private static String defaultMageName = "Automaton";
    private static final Set<Material> EMPTY_MATERIAL_SET = new HashSet<Material>();

    public void removeExperience(int xp) {
        if (this.activeWand != null && this.activeWand.hasExperience()) {
            this.activeWand.removeExperience(xp);
            return;
        }
        Player player = this.getPlayer();
        if (player == null) {
            return;
        }
        float expProgress = player.getExp();
        int expLevel = player.getLevel();
        while ((expProgress > 0.0f || expLevel > 0) && xp > 0) {
            if (expProgress > 0.0f) {
                int expAtLevel = (int)(expProgress * (float)player.getExpToLevel());
                if (expAtLevel > xp) {
                    xp = 0;
                    expProgress = (float)(expAtLevel -= xp) / (float)Mage.getExpToLevel(expLevel);
                    continue;
                }
                expProgress = 0.0f;
                xp -= expAtLevel;
                continue;
            }
            --expLevel;
            if ((xp -= player.getExpToLevel()) >= 0) continue;
            expProgress = (float)(-xp) / (float)Mage.getExpToLevel(expLevel);
            xp = 0;
        }
        player.setExp(expProgress);
        player.setLevel(expLevel);
    }

    public static int getExpToLevel(int expLevel) {
        return expLevel >= 30 ? 62 + (expLevel - 30) * 7 : (expLevel >= 15 ? 17 + (expLevel - 15) * 3 : 17);
    }

    public int getExperience() {
        if (this.activeWand != null && this.activeWand.hasExperience()) {
            return this.activeWand.getExperience();
        }
        Player player = this.getPlayer();
        if (player == null) {
            return 0;
        }
        int xp = 0;
        float expProgress = player.getExp();
        int expLevel = player.getLevel();
        int level = 0;
        while (level < expLevel) {
            xp += Mage.getExpToLevel(level);
            ++level;
        }
        return xp + (int)(expProgress * (float)Mage.getExpToLevel(expLevel));
    }

    public void setCostReduction(float reduction) {
        this.costReduction = reduction;
    }

    public boolean hasStoredInventory() {
        return this.storedInventory != null;
    }

    public Inventory getStoredInventory() {
        return this.storedInventory;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public void clearCache() {
        if (this.brush != null) {
            this.brush.clearSchematic();
        }
    }

    @Override
    public float getCostReduction() {
        return this.activeWand == null ? this.costReduction + this.controller.getCostReduction() : this.activeWand.getCostReduction() + this.costReduction;
    }

    public float getCooldownReduction() {
        return this.activeWand == null ? this.cooldownReduction + this.controller.getCooldownReduction() : this.activeWand.getCooldownReduction() + this.cooldownReduction;
    }

    public void setCooldownReduction(float reduction) {
        this.cooldownReduction = reduction;
    }

    public void setPowerMultiplier(float mutliplier) {
        this.powerMultiplier = mutliplier;
    }

    @Override
    public boolean usesMana() {
        return this.activeWand == null ? false : this.activeWand.usesMana();
    }

    protected float getWandPower() {
        float power = Math.min(this.controller.getMaxPower(), this.activeWand == null ? 0.0f : this.activeWand.getPower());
        return power * this.powerMultiplier;
    }

    public float getDamageMultiplier() {
        float maxPowerMultiplier = this.controller.getMaxDamagePowerMultiplier() - 1.0f;
        return 1.0f + maxPowerMultiplier * this.getWandPower();
    }

    public float getRangeMultiplier() {
        if (this.activeWand == null) {
            return 1.0f;
        }
        float maxPowerMultiplier = this.controller.getMaxRangePowerMultiplier() - 1.0f;
        float maxPowerMultiplierMax = this.controller.getMaxRangePowerMultiplierMax();
        float multiplier = 1.0f + maxPowerMultiplier * this.getWandPower();
        return Math.min(multiplier, maxPowerMultiplierMax);
    }

    public float getConstructionMultiplier() {
        float maxPowerMultiplier = this.controller.getMaxConstructionPowerMultiplier() - 1.0f;
        return 1.0f + maxPowerMultiplier * this.getWandPower();
    }

    public float getRadiusMultiplier() {
        if (this.activeWand == null) {
            return 1.0f;
        }
        float maxPowerMultiplier = this.controller.getMaxRadiusPowerMultiplier() - 1.0f;
        float maxPowerMultiplierMax = this.controller.getMaxRadiusPowerMultiplierMax();
        float multiplier = 1.0f + maxPowerMultiplier * this.getWandPower();
        return Math.min(multiplier, maxPowerMultiplierMax);
    }

    public boolean addToStoredInventory(ItemStack item) {
        if (this.storedInventory == null) {
            return false;
        }
        Player player = this.getPlayer();
        HashMap remainder = this.storedInventory.addItem(new ItemStack[]{item});
        for (ItemStack remains : remainder.values()) {
            if (player == null) continue;
            player.getWorld().dropItemNaturally(player.getLocation(), remains);
        }
        return true;
    }

    public boolean storeInventory() {
        if (this.storedInventory != null) {
            return false;
        }
        Player player = this.getPlayer();
        if (player == null) {
            return false;
        }
        PlayerInventory inventory = player.getInventory();
        this.storedInventory = InventoryUtils.createInventory(null, inventory.getSize(), "Stored Inventory");
        ItemStack[] contents = inventory.getContents();
        int i = 0;
        while (i < contents.length) {
            if (Wand.isSpell(contents[i])) {
                contents[i] = null;
            }
            ++i;
        }
        this.storedInventory.setContents(contents);
        inventory.clear();
        return true;
    }

    public boolean restoreInventory() {
        if (this.storedInventory == null) {
            return false;
        }
        Player player = this.getPlayer();
        if (player == null) {
            return false;
        }
        PlayerInventory inventory = player.getInventory();
        inventory.setContents(this.storedInventory.getContents());
        this.storedInventory = null;
        return true;
    }

    public void registerEvent(SpellEventType type, Spell spell) {
        switch (type) {
            case PLAYER_QUIT: {
                if (this.quitListeners.contains(spell)) break;
                this.quitListeners.add(spell);
                break;
            }
            case PLAYER_DAMAGE: {
                if (this.damageListeners.contains(spell)) break;
                this.damageListeners.add(spell);
                break;
            }
            case PLAYER_DEATH: {
                if (this.deathListeners.contains(spell)) break;
                this.deathListeners.add(spell);
            }
        }
    }

    public void unregisterEvent(SpellEventType type, Spell spell) {
        switch (type) {
            case PLAYER_DAMAGE: {
                this.damageListeners.remove(spell);
                break;
            }
            case PLAYER_QUIT: {
                this.quitListeners.remove(spell);
                break;
            }
            case PLAYER_DEATH: {
                this.deathListeners.remove(spell);
            }
        }
    }

    public Player getPlayer() {
        return (Player)this.player.get();
    }

    public CommandSender getCommandSender() {
        return (CommandSender)this.commandSender.get();
    }

    public boolean cancel() {
        boolean result = false;
        for (Spell spell : this.spells.values()) {
            boolean bl = result = result || spell.cancel();
        }
        return result;
    }

    public void onPlayerQuit(PlayerQuitEvent event) {
        ArrayList<Spell> active = new ArrayList<Spell>();
        active.addAll(this.quitListeners);
        for (Spell listener : active) {
            listener.onPlayerQuit(event);
        }
    }

    public void onPlayerDeath(EntityDeathEvent event) {
        Player player = this.getPlayer();
        if (player == null) {
            return;
        }
        this.lastDeathLocation = player.getLocation();
        ArrayList<Spell> active = new ArrayList<Spell>();
        active.addAll(this.deathListeners);
        for (Spell listener : active) {
            if (player != listener.getPlayer()) continue;
            listener.onPlayerDeath(event);
        }
    }

    public void onPlayerCombust(EntityCombustEvent event) {
        if (this.activeWand != null && this.activeWand.getDamageReductionFire() > 0.0f) {
            event.setCancelled(true);
        }
    }

    public boolean isSuperProtected() {
        if (this.controller.hasPermission(this.getPlayer(), "Magic.protected")) {
            return true;
        }
        return this.activeWand != null && this.activeWand.getDamageReduction() > 1.0f;
    }

    public boolean isSuperPowered() {
        return this.activeWand != null && this.activeWand.getPower() > 1.0f;
    }

    public void onPlayerDamage(EntityDamageEvent event) {
        Player player = this.getPlayer();
        if (player == null) {
            return;
        }
        ArrayList<Spell> active = new ArrayList<Spell>();
        active.addAll(this.damageListeners);
        for (Spell listener : active) {
            listener.onPlayerDamage(event);
        }
        if (event.isCancelled()) {
            return;
        }
        float reduction = 0.0f;
        if (this.activeWand != null) {
            reduction = this.activeWand.getDamageReduction();
            float damageReductionFire = this.activeWand.getDamageReductionFire();
            switch (event.getCause()) {
                case CONTACT: 
                case ENTITY_ATTACK: {
                    reduction += this.activeWand.getDamageReductionPhysical();
                    break;
                }
                case PROJECTILE: {
                    reduction += this.activeWand.getDamageReductionProjectiles();
                    break;
                }
                case FALL: {
                    reduction += this.activeWand.getDamageReductionFalling();
                    break;
                }
                case FIRE: 
                case FIRE_TICK: 
                case LAVA: {
                    if (damageReductionFire > 0.0f && player.getFireTicks() > 0) {
                        player.setFireTicks(0);
                    }
                    reduction += damageReductionFire;
                    break;
                }
                case BLOCK_EXPLOSION: 
                case ENTITY_EXPLOSION: {
                    reduction += this.activeWand.getDamageReductionExplosions();
                }
            }
        }
        if (reduction > 1.0f) {
            event.setCancelled(true);
            return;
        }
        if (reduction > 0.0f) {
            double newDamage = (double)(1.0f - reduction) * event.getDamage();
            if (newDamage <= 0.0) {
                newDamage = 0.1;
            }
            event.setDamage(newDamage);
        }
    }

    public Spell getSpell(String name) {
        return this.getSpell(name, this.getPlayer());
    }

    public Spell getSpell(String name, Player usePermissions) {
        Spell spell = this.controller.getSpell(name);
        if (spell == null || !spell.hasSpellPermission(usePermissions)) {
            return null;
        }
        Spell playerSpell = this.spells.get(spell.getKey());
        if (playerSpell == null) {
            playerSpell = (Spell)spell.clone();
            this.spells.put(spell.getKey(), playerSpell);
        }
        playerSpell.setMage(this);
        return playerSpell;
    }

    public MagicController getController() {
        return this.controller;
    }

    public Inventory getInventory() {
        Player player = this.getPlayer();
        return this.hasStoredInventory() ? this.getStoredInventory() : (player == null ? null : player.getInventory());
    }

    public Wand getActiveWand() {
        return this.activeWand;
    }

    public void setActiveWand(Wand activeWand) {
        this.activeWand = activeWand;
        this.blockPlaceTimeout = System.currentTimeMillis() + 200L;
    }

    public long getBlockPlaceTimeout() {
        return this.blockPlaceTimeout;
    }

    public MaterialBrush getBrush() {
        return this.brush;
    }

    public void castMessage(String message) {
        if (this.activeWand != null && !this.activeWand.showCastMessages()) {
            return;
        }
        CommandSender sender = this.getCommandSender();
        if (sender != null && this.controller.showCastMessages() && this.controller.showMessages()) {
            sender.sendMessage(String.valueOf(this.controller.getCastMessagePrefix()) + message);
        }
    }

    public void sendMessage(String message) {
        if (this.activeWand != null && !this.activeWand.showMessages()) {
            return;
        }
        CommandSender sender = this.getCommandSender();
        if (sender != null && this.controller.showMessages()) {
            sender.sendMessage(String.valueOf(this.controller.getMessagePrefix()) + message);
        }
    }

    public void clearBuildingMaterial() {
        this.brush.setMaterial(this.controller.getDefaultMaterial(), (byte)1);
    }

    public boolean hasBuildPermission(Block block) {
        return this.controller.hasBuildPermission(this.getPlayer(), block);
    }

    public boolean isIndestructible(Block block) {
        return this.controller.isIndestructible(block);
    }

    public boolean isDestructible(Block block) {
        return this.controller.isDestructible(block);
    }

    public void playSound(Sound sound, float volume, float pitch) {
        Player player = this.getPlayer();
        if (player != null && this.controller.soundsEnabled()) {
            player.playSound(player.getLocation(), sound, volume, pitch);
        }
    }

    public UndoQueue getUndoQueue() {
        if (this.undoQueue == null) {
            this.undoQueue = new UndoQueue();
            this.undoQueue.setMaxSize(this.controller.getUndoQueueDepth());
        }
        return this.undoQueue;
    }

    public boolean undo(Block target) {
        return this.getUndoQueue().undo(this, target);
    }

    public boolean undo() {
        boolean stoppedPending = false;
        if (this.pendingBatches.size() > 0) {
            ArrayList<BlockBatch> batches = new ArrayList<BlockBatch>();
            batches.addAll(this.pendingBatches);
            for (BlockBatch batch : batches) {
                if (batch instanceof UndoBatch) continue;
                batch.finish();
                this.pendingBatches.remove(batch);
                stoppedPending = true;
            }
        }
        if (stoppedPending) {
            return true;
        }
        return this.getUndoQueue().undo(this);
    }

    public boolean commit() {
        return this.getUndoQueue().commit();
    }

    public void registerForUndo(BlockList blockList) {
        UndoQueue queue = this.getUndoQueue();
        int autoUndo = this.controller.getAutoUndoInterval();
        if (autoUndo > 0 && blockList.getTimeToLive() == 0) {
            blockList.setTimeToLive(autoUndo);
        }
        if (blockList.getTimeToLive() > 0) {
            queue.scheduleCleanup(this, blockList);
        } else {
            queue.add(blockList);
        }
    }

    public Color getEffectColor() {
        if (this.activeWand == null) {
            return null;
        }
        return Color.fromRGB((int)this.activeWand.getEffectColor());
    }

    public FireworkEffect getFireworkEffect() {
        return this.getFireworkEffect(null, null, null, null, null);
    }

    public FireworkEffect getFireworkEffect(Color color1, Color color2, FireworkEffect.Type fireworkType) {
        return this.getFireworkEffect(color1, color2, fireworkType, null, null);
    }

    public FireworkEffect getFireworkEffect(Color color1, Color color2, FireworkEffect.Type fireworkType, Boolean flicker, Boolean trail) {
        Color wandColor = this.getEffectColor();
        Random rand = new Random();
        if (wandColor != null) {
            color1 = wandColor;
            color2 = wandColor.mixColors(new Color[]{color1, Color.WHITE});
        } else {
            if (color1 == null) {
                color1 = Color.fromRGB((int)rand.nextInt(255), (int)rand.nextInt(255), (int)rand.nextInt(255));
            }
            if (color2 == null) {
                color2 = Color.fromRGB((int)rand.nextInt(255), (int)rand.nextInt(255), (int)rand.nextInt(255));
            }
        }
        if (fireworkType == null) {
            fireworkType = FireworkEffect.Type.values()[rand.nextInt(FireworkEffect.Type.values().length)];
        }
        if (flicker == null) {
            flicker = rand.nextBoolean();
        }
        if (trail == null) {
            trail = rand.nextBoolean();
        }
        return FireworkEffect.builder().flicker(flicker.booleanValue()).withColor(color1).withFade(color2).with(fireworkType).trail(trail.booleanValue()).build();
    }

    public Location getLastDeathLocation() {
        return this.lastDeathLocation;
    }

    protected Mage(MagicController master, Player player) {
        this.controller = master;
        this.player = new WeakReference<Player>(player);
        this.brush = new MaterialBrush(this, Material.DIRT, 0);
    }

    protected void setPlayer(Player player) {
        if (player != null) {
            this.playerName = player.getName();
            this.player = new WeakReference<Player>(player);
            this.commandSender = new WeakReference<Player>(player);
        } else {
            if (this.player != null) {
                this.player.clear();
            }
            if (this.commandSender != null) {
                this.commandSender.clear();
            }
        }
    }

    protected void setCommandSender(CommandSender sender) {
        if (sender != null) {
            this.commandSender = new WeakReference<CommandSender>(sender);
            if (sender instanceof BlockCommandSender) {
                BlockCommandSender commandBlock = (BlockCommandSender)sender;
                this.playerName = commandBlock.getName();
                Location location = this.getLocation();
                if (location == null) {
                    location = commandBlock.getBlock().getLocation();
                } else {
                    Location blockLocation = commandBlock.getBlock().getLocation();
                    location.setX(blockLocation.getX());
                    location.setY(blockLocation.getY());
                    location.setZ(blockLocation.getZ());
                }
                this.setLocation(location);
            } else {
                this.setLocation(null);
            }
        } else if (this.commandSender != null) {
            this.commandSender.clear();
            this.setLocation(null);
        } else {
            this.setLocation(null);
        }
    }

    protected void load(ConfigurationNode configNode) {
        try {
            if (configNode == null) {
                return;
            }
            this.playerName = configNode.getString("name", this.playerName);
            this.lastDeathLocation = configNode.getLocation("last_death_location");
            this.getUndoQueue().load(this, configNode);
            ConfigurationNode spellNode = configNode.getNode("spells");
            if (spellNode != null) {
                List<String> keys = spellNode.getKeys();
                for (String key : keys) {
                    Spell spell = this.getSpell(key);
                    if (spell == null) continue;
                    spell.load(spellNode.getNode(key));
                }
            }
            if (configNode.containsKey("brush")) {
                this.brush.load(configNode.getNode("brush"));
            }
        }
        catch (Exception ex) {
            this.controller.getPlugin().getLogger().warning("Failed to load player data for " + this.playerName + ": " + ex.getMessage());
        }
    }

    protected void save(ConfigurationNode configNode) {
        try {
            configNode.setProperty("name", this.playerName);
            configNode.setProperty("last_death_location", this.lastDeathLocation);
            ConfigurationNode brushNode = configNode.createChild("brush");
            this.brush.save(brushNode);
            this.getUndoQueue().save(this, configNode);
            ConfigurationNode spellNode = configNode.createChild("spells");
            for (Spell spell : this.spells.values()) {
                spell.save(spellNode.createChild(spell.getKey()));
            }
        }
        catch (Exception ex) {
            this.controller.getPlugin().getLogger().warning("Failed to save player data for " + this.playerName + ": " + ex.getMessage());
        }
    }

    protected boolean checkLastClick(long maxInterval) {
        long now = System.currentTimeMillis();
        long previous = this.lastClick;
        this.lastClick = now;
        return previous <= 0L || previous + maxInterval < now;
    }

    protected void activateSpell(Spell spell) {
        this.activeSpells.add(spell);
    }

    protected void deactivateSpell(Spell spell) {
        this.activeSpells.remove(spell);
    }

    public void deactivateAllSpells() {
        ArrayList<Spell> active = new ArrayList<Spell>(this.activeSpells);
        for (Spell spell : active) {
            spell.deactivate();
        }
    }

    protected void tick() {
        Player player = this.getPlayer();
        if (this.activeWand != null && player != null && player.isOnline()) {
            this.activeWand.tick();
        }
        ArrayList<Spell> active = new ArrayList<Spell>(this.activeSpells);
        for (Spell spell : active) {
            spell.checkActiveDuration();
            spell.checkActiveCosts();
        }
    }

    public Location getLocation() {
        if (this.location != null) {
            return this.location;
        }
        Player player = this.getPlayer();
        if (player == null) {
            return null;
        }
        return player.getLocation();
    }

    public Location getEyeLocation() {
        Player player = this.getPlayer();
        if (player == null) {
            return null;
        }
        return player.getEyeLocation();
    }

    public Vector getDirection() {
        Player player = this.getPlayer();
        if (player == null) {
            return new Vector(0, 1, 0);
        }
        return player.getLocation().getDirection().normalize();
    }

    public String getName() {
        return this.playerName == null || this.playerName.length() == 0 ? defaultMageName : this.playerName;
    }

    public boolean addPendingBlockBatch(BlockBatch batch) {
        if (this.pendingBatches.size() >= this.controller.getPendingQueueDepth()) {
            return false;
        }
        this.pendingBatches.addLast(batch);
        this.controller.addPending(this);
        return true;
    }

    public void processPendingBatches(int maxBlockUpdates) {
        if (this.pendingBatches.size() > 0) {
            int updated = 0;
            ArrayList<BlockBatch> processBatches = new ArrayList<BlockBatch>(this.pendingBatches);
            this.pendingBatches.clear();
            for (BlockBatch batch : processBatches) {
                int batchUpdated = batch.process(maxBlockUpdates - updated);
                updated += batchUpdated;
                if (!batch.isFinished()) {
                    this.pendingBatches.add(batch);
                }
                if (updated >= maxBlockUpdates) break;
            }
        }
        if (this.pendingBatches.size() == 0) {
            this.controller.removePending(this);
        }
    }

    public List<BlockBatch> getPendingBatches() {
        return this.pendingBatches;
    }

    public List<LostWand> getLostWands() {
        Collection<LostWand> allWands = this.controller.getLostWands();
        ArrayList<LostWand> mageWands = new ArrayList<LostWand>();
        for (LostWand lostWand : allWands) {
            String owner = lostWand.getOwner();
            if (owner == null || !owner.equals(this.playerName)) continue;
            mageWands.add(lostWand);
        }
        return mageWands;
    }

    public void setLastHeldMapId(short mapId) {
        this.brush.setMapId(mapId);
    }

    protected void loadSpells(ConfigurationNode config) {
        if (config == null) {
            return;
        }
        for (Spell spell : this.spells.values()) {
            String key = spell.getKey();
            if (!config.containsKey(key)) continue;
            spell.loadTemplate(config.getNode(key));
        }
    }

    public Set<Material> getRestrictedMaterials() {
        if (this.isSuperPowered()) {
            return EMPTY_MATERIAL_SET;
        }
        return this.controller.getRestrictedMaterials();
    }

    public boolean isRestricted(Material material) {
        if (this.isSuperPowered()) {
            return false;
        }
        return this.controller.isRestricted(material);
    }
}

