/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.blocks;

import com.elmakers.mine.bukkit.blocks.BlockList;
import com.elmakers.mine.bukkit.blocks.VolumeBatch;
import com.elmakers.mine.bukkit.plugins.magic.BlockSpell;
import com.elmakers.mine.bukkit.plugins.magic.Mage;
import com.elmakers.mine.bukkit.utilities.Messages;
import com.elmakers.mine.bukkit.utilities.RandomUtils;
import com.elmakers.mine.bukkit.utilities.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.CommandBlock;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class SimulateBatch
extends VolumeBatch {
    private static BlockFace[] neighborFaces = new BlockFace[]{BlockFace.NORTH, BlockFace.NORTH_EAST, BlockFace.EAST, BlockFace.SOUTH_EAST, BlockFace.SOUTH, BlockFace.SOUTH_WEST, BlockFace.WEST, BlockFace.NORTH_WEST};
    private static BlockFace[] POWER_FACES = new BlockFace[]{BlockFace.EAST, BlockFace.WEST, BlockFace.SOUTH, BlockFace.NORTH, BlockFace.DOWN, BlockFace.UP};
    public static Material POWER_MATERIAL = Material.REDSTONE_BLOCK;
    public static boolean DEBUG = false;
    private Mage mage;
    private BlockSpell spell;
    private Block castCommandBlock;
    private Block commandTargetBlock;
    private TargetMode targetMode = TargetMode.STABILIZE;
    private TargetType targetType = TargetType.PLAYER;
    private Location targetLocation;
    private String castCommand;
    private String commandName;
    private boolean reverseTargetDistanceScore = false;
    private int commandMoveRangeSquared = 9;
    private int huntMaxRange = 128;
    private int huntMinRange = 4;
    private int birthRangeSquared = 0;
    private int liveRangeSquared = 0;
    private float huntFov = 3.0f;
    private boolean commandReload;
    private boolean commandPowered;
    private World world;
    private Material birthMaterial;
    private Material deathMaterial;
    private Material powerSimMaterialBackup;
    private Material powerSimMaterial;
    private boolean includeCommands;
    private int startX;
    private int startZ;
    private int startY;
    private int endY;
    private int endX;
    private int endZ;
    private int x;
    private int y;
    private int z;
    private int yRadius;
    private int updatingIndex;
    private ArrayList<Boolean> liveCounts = new ArrayList();
    private ArrayList<Boolean> birthCounts = new ArrayList();
    private SimulationState state;
    private Location center;
    private List<Block> deadBlocks = new ArrayList<Block>();
    private List<Block> bornBlocks = new ArrayList<Block>();
    private List<Target> potentialCommandBlocks = new LinkedList<Target>();
    private BlockList modifiedBlocks = new BlockList();

    public SimulateBatch(BlockSpell spell, Location center, int radius, int yRadius, Material birth, Material death, Set<Integer> liveCounts, Set<Integer> birthCounts) {
        super(spell.getMage().getController(), center.getWorld().getName());
        this.spell = spell;
        this.mage = spell.getMage();
        this.yRadius = yRadius;
        this.center = center.clone();
        this.targetLocation = center.clone();
        this.birthMaterial = birth;
        this.deathMaterial = death;
        this.powerSimMaterial = this.birthMaterial;
        this.powerSimMaterialBackup = this.deathMaterial;
        for (Integer liveCount : liveCounts) {
            while (this.liveCounts.size() < liveCount) {
                this.liveCounts.add(false);
            }
            this.liveCounts.add(true);
        }
        for (Integer birthCount : birthCounts) {
            while (this.birthCounts.size() < birthCount) {
                this.birthCounts.add(false);
            }
            this.birthCounts.add(true);
        }
        this.world = center.getWorld();
        this.includeCommands = false;
        this.startY = center.getBlockY() - yRadius;
        this.endY = center.getBlockY() + yRadius;
        this.startX = center.getBlockX() - radius;
        this.startZ = center.getBlockZ() - radius;
        this.endX = center.getBlockX() + radius;
        this.endZ = center.getBlockZ() + radius;
        this.x = this.startX;
        this.y = this.startY;
        this.z = this.startZ;
        this.state = SimulationState.SCANNING_COMMAND;
        this.updatingIndex = 0;
    }

    @Override
    public int size() {
        return this.modifiedBlocks.size();
    }

    @Override
    public int remaining() {
        return (this.endX - this.x) * (this.endZ - this.z) * (this.endY - this.y);
    }

    protected void checkForPotentialCommand(Block block, int distanceSquared) {
        if (this.includeCommands && distanceSquared < this.commandMoveRangeSquared) {
            this.potentialCommandBlocks.add(new Target(this.targetLocation, block, this.huntMinRange, this.huntMaxRange, (double)this.huntFov, this.reverseTargetDistanceScore));
        }
    }

    @Override
    public int process(int maxBlocks) {
        BlockFace[] checkForPower;
        int processedBlocks = 0;
        if (this.state == SimulationState.SCANNING_COMMAND) {
            if (this.includeCommands && this.castCommandBlock != null) {
                if (!this.castCommandBlock.getChunk().isLoaded()) {
                    this.finish();
                    return processedBlocks;
                }
                BlockFace[] blockFaceArray = POWER_FACES;
                int n = POWER_FACES.length;
                int n2 = 0;
                while (n2 < n) {
                    BlockFace powerFace = blockFaceArray[n2];
                    checkForPower = this.castCommandBlock.getRelative(powerFace);
                    if (checkForPower.getType() == POWER_MATERIAL) {
                        if (this.commandReload) {
                            this.controller.unregisterBlockForReloadToggle((Block)checkForPower);
                        }
                        checkForPower.setType(this.powerSimMaterial);
                        this.commandPowered = true;
                    }
                    ++n2;
                }
                this.castCommandBlock.setType(this.birthMaterial);
            }
            ++processedBlocks;
            this.state = SimulationState.SCANNING;
        }
        while (this.state == SimulationState.SCANNING && processedBlocks <= maxBlocks) {
            int distanceSquared;
            Block block = this.world.getBlockAt(this.x, this.y, this.z);
            if (!block.getChunk().isLoaded()) {
                block.getChunk().load();
                return processedBlocks;
            }
            Material blockMaterial = block.getType();
            if (blockMaterial == this.birthMaterial) {
                int n = distanceSquared = this.liveRangeSquared > 0 || this.includeCommands ? (int)Math.floor(block.getLocation().distanceSquared(this.castCommandBlock.getLocation())) : 0;
                if (this.liveRangeSquared <= 0 || distanceSquared <= this.liveRangeSquared) {
                    int neighborCount = this.getNeighborCount(block, this.birthMaterial, this.includeCommands);
                    if (neighborCount >= this.liveCounts.size() || !this.liveCounts.get(neighborCount).booleanValue()) {
                        this.deadBlocks.add(block);
                    } else {
                        this.checkForPotentialCommand(block, distanceSquared);
                    }
                } else {
                    this.deadBlocks.add(block);
                }
            } else if (blockMaterial == this.deathMaterial) {
                int neighborCount;
                int n = distanceSquared = this.birthRangeSquared > 0 || this.includeCommands ? (int)Math.floor(block.getLocation().distanceSquared(this.castCommandBlock.getLocation())) : 0;
                if ((this.birthRangeSquared <= 0 || distanceSquared <= this.birthRangeSquared) && (neighborCount = this.getNeighborCount(block, this.birthMaterial, this.includeCommands)) < this.birthCounts.size() && this.birthCounts.get(neighborCount).booleanValue()) {
                    this.bornBlocks.add(block);
                    this.checkForPotentialCommand(block, distanceSquared);
                }
            }
            ++this.z;
            if (this.z > this.endZ) {
                this.z = this.startZ;
                ++this.x;
            }
            if (this.x > this.endX) {
                this.x = this.startX;
                this.z = this.startZ;
                ++this.y;
            }
            if (this.y <= this.endY) continue;
            this.state = SimulationState.UPDATING;
        }
        while (this.state == SimulationState.UPDATING && processedBlocks <= maxBlocks) {
            int bornIndex;
            int deadIndex = this.updatingIndex;
            if (deadIndex >= 0 && deadIndex < this.deadBlocks.size()) {
                Block killBlock = this.deadBlocks.get(deadIndex);
                if (!killBlock.getChunk().isLoaded()) {
                    killBlock.getChunk().load();
                    return processedBlocks;
                }
                this.modifiedBlocks.add(killBlock);
                killBlock.setType(this.deathMaterial);
                this.controller.updateBlock(killBlock);
                ++processedBlocks;
            }
            if ((bornIndex = this.updatingIndex - this.deadBlocks.size()) >= 0 && bornIndex < this.bornBlocks.size()) {
                Block birthBlock = this.bornBlocks.get(bornIndex);
                if (!birthBlock.getChunk().isLoaded()) {
                    birthBlock.getChunk().load();
                    return processedBlocks;
                }
                this.modifiedBlocks.add(birthBlock);
                birthBlock.setType(this.birthMaterial);
                this.controller.updateBlock(birthBlock);
            }
            ++this.updatingIndex;
            if (this.updatingIndex < this.deadBlocks.size() + this.bornBlocks.size()) continue;
            this.state = SimulationState.COMMAND_SEARCH;
            return maxBlocks;
        }
        if (this.state == SimulationState.COMMAND_SEARCH) {
            if (this.includeCommands && this.potentialCommandBlocks.size() > 0) {
                switch (this.targetMode) {
                    case HUNT: {
                        Collections.sort(this.potentialCommandBlocks);
                        break;
                    }
                    case FLEE: {
                        Collections.sort(this.potentialCommandBlocks);
                        break;
                    }
                    default: {
                        Collections.shuffle(this.potentialCommandBlocks);
                    }
                }
                this.commandTargetBlock = null;
                Block backupBlock = null;
                while (this.commandTargetBlock == null && this.potentialCommandBlocks.size() > 0) {
                    Block block = this.potentialCommandBlocks.remove(0).getBlock();
                    if (block == null || block.getType() != this.birthMaterial) continue;
                    if (!this.commandPowered) {
                        this.commandTargetBlock = block;
                        continue;
                    }
                    backupBlock = block;
                    BlockFace powerFace = SimulateBatch.findPowerLocation(block, this.powerSimMaterial);
                    if (powerFace == null) continue;
                    this.commandTargetBlock = block;
                }
                if (this.commandTargetBlock == null) {
                    this.commandTargetBlock = backupBlock;
                }
            }
            if (DEBUG && this.commandTargetBlock != null) {
                this.controller.getLogger().info("MOVED: " + this.commandTargetBlock.getLocation().toVector().subtract(this.center.toVector()));
            }
            this.state = SimulationState.COMMAND_UPDATE;
            return processedBlocks;
        }
        if (this.state == SimulationState.COMMAND_UPDATE) {
            if (this.includeCommands && this.commandTargetBlock != null) {
                if (!this.commandTargetBlock.getChunk().isLoaded()) {
                    this.commandTargetBlock.getChunk().load();
                    return processedBlocks;
                }
                this.commandTargetBlock.setType(Material.COMMAND);
                BlockState commandData = this.commandTargetBlock.getState();
                if (this.castCommand != null && commandData != null && commandData instanceof CommandBlock) {
                    CommandBlock copyCommand = (CommandBlock)commandData;
                    copyCommand.setCommand(this.castCommand);
                    copyCommand.setName(this.commandName);
                    copyCommand.update();
                    Location newLocation = this.commandTargetBlock.getLocation();
                    newLocation.setPitch(this.center.getPitch());
                    newLocation.setYaw(this.center.getYaw());
                    this.mage.setLocation(newLocation);
                } else {
                    this.commandTargetBlock = null;
                }
            }
            this.state = SimulationState.COMMAND_POWER;
            return processedBlocks;
        }
        if (this.state == SimulationState.COMMAND_POWER) {
            if (this.commandPowered && this.commandTargetBlock != null && this.includeCommands) {
                BlockFace powerDirection = SimulateBatch.findPowerLocation(this.commandTargetBlock, this.powerSimMaterial);
                if (powerDirection == null) {
                    if (DEBUG) {
                        this.controller.getLogger().info("Had to fall back to backup location, pattern may diverge");
                    }
                    powerDirection = SimulateBatch.findPowerLocation(this.commandTargetBlock, this.powerSimMaterialBackup);
                }
                if (powerDirection == null) {
                    checkForPower = POWER_FACES;
                    int neighborCount = POWER_FACES.length;
                    int newLocation = 0;
                    while (newLocation < neighborCount) {
                        BlockFace face = checkForPower[newLocation];
                        if (this.spell.isDestructible(this.commandTargetBlock.getRelative(face))) {
                            if (DEBUG) {
                                this.controller.getLogger().info("Had to fall back to destructible location, pattern may diverge and may destroy blocks");
                            }
                            powerDirection = face;
                            break;
                        }
                        ++newLocation;
                    }
                }
                if (powerDirection != null) {
                    Block powerBlock = this.commandTargetBlock.getRelative(powerDirection);
                    powerBlock.setType(POWER_MATERIAL);
                    if (this.commandReload) {
                        String message = "";
                        if (this.commandName != null && this.commandName.length() > 1) {
                            String[] pieces;
                            String automataName = this.commandName;
                            if (automataName.contains("@") && (pieces = StringUtils.split((String)automataName, (char)'@')).length > 1 && pieces[1].length() > 0) {
                                automataName = pieces[1];
                            }
                            message = Messages.get("general.toggle_block").replace("$name", automataName);
                        }
                        this.controller.registerBlockForReloadToggle(powerBlock, message);
                    }
                }
            }
            this.state = SimulationState.FINISHED;
            return processedBlocks;
        }
        if (this.state == SimulationState.FINISHED) {
            this.finish();
        }
        return processedBlocks;
    }

    public void setCommandBlock(Block block) {
        this.castCommandBlock = block;
        if (this.castCommandBlock.getType() == Material.COMMAND) {
            BlockState commandData = this.castCommandBlock.getState();
            if (commandData != null && commandData instanceof CommandBlock) {
                CommandBlock commandBlock = (CommandBlock)commandData;
                this.castCommand = commandBlock.getCommand();
                this.commandName = commandBlock.getName();
            }
            this.includeCommands = this.castCommand != null && this.castCommand.length() > 0;
        }
    }

    public void setBirthRange(int range) {
        this.birthRangeSquared = range * range;
    }

    public void setLiveRange(int range) {
        this.liveRangeSquared = range * range;
    }

    public void setMaxHuntRange(int range) {
        this.huntMaxRange = range;
    }

    public void setMinHuntRange(int range) {
        this.huntMinRange = range;
    }

    public void setTargetType(TargetType targetType) {
        this.targetType = targetType;
    }

    public void target(TargetMode mode) {
        this.targetMode = mode == null ? TargetMode.STABILIZE : mode;
        switch (this.targetMode) {
            case HUNT: 
            case FLEE: 
            case DIRECTED: {
                Vector direction;
                int score;
                Target newScore;
                this.targetLocation = this.center.clone();
                this.reverseTargetDistanceScore = this.targetMode == TargetMode.FLEE;
                Target bestTarget = null;
                if (this.targetType == TargetType.ANY || this.targetType == TargetType.MOB) {
                    List entities = this.targetLocation.getWorld().getEntities();
                    for (Entity entity : entities) {
                        if (entity instanceof Player || !(entity instanceof LivingEntity)) continue;
                        newScore = new Target(this.center, entity, this.huntMinRange, this.huntMaxRange, (double)this.huntFov, false);
                        score = newScore.getScore();
                        if (bestTarget != null && score <= bestTarget.getScore()) continue;
                        bestTarget = newScore;
                    }
                }
                if (this.targetType == TargetType.MAGE || this.targetType == TargetType.AUTOMATON || this.targetType == TargetType.ANY || this.targetType == TargetType.PLAYER) {
                    Collection<Mage> mages = this.controller.getMages();
                    for (Mage mage : mages) {
                        if (mage == this.mage || this.targetType == TargetType.AUTOMATON && mage.getPlayer() != null) continue;
                        newScore = new Target(this.center, mage, this.huntMinRange, this.huntMaxRange, (double)this.huntFov, false);
                        score = newScore.getScore();
                        if (bestTarget != null && score <= bestTarget.getScore()) continue;
                        bestTarget = newScore;
                    }
                }
                if (bestTarget == null) break;
                if (DEBUG) {
                    String targetDescription = bestTarget.getEntity() == null ? "NONE" : (bestTarget instanceof Player ? ((Player)bestTarget.getEntity()).getName() : bestTarget.getEntity().getType().name());
                    this.controller.getLogger().info(" *Tracking " + targetDescription + " score: " + bestTarget.getScore() + " location: " + this.center + " -> " + bestTarget.getLocation() + " min " + this.huntMinRange);
                }
                if (this.targetMode == TargetMode.DIRECTED) {
                    direction = bestTarget.getLocation().getDirection();
                    this.center = RandomUtils.setDirection(this.center, direction);
                    this.targetLocation = this.center.clone().add(direction.normalize().multiply(this.huntMaxRange));
                    if (!DEBUG) break;
                    Bukkit.getLogger().info(" *Directed " + direction + " to " + this.targetLocation.toVector());
                    break;
                }
                this.targetLocation = bestTarget.getLocation();
                direction = this.targetMode == TargetMode.FLEE ? this.center.toVector().subtract(this.targetLocation.toVector()) : this.targetLocation.toVector().subtract(this.center.toVector());
                this.center = RandomUtils.setDirection(this.center, direction);
                break;
            }
            case GLIDE: {
                this.targetLocation = this.center.clone();
                this.reverseTargetDistanceScore = true;
                break;
            }
            default: {
                this.targetLocation = this.center.clone();
                this.reverseTargetDistanceScore = true;
            }
        }
    }

    public void setCommandMoveRange(int commandRadius, boolean reload) {
        this.commandReload = reload;
        this.commandMoveRangeSquared = commandRadius * commandRadius;
    }

    protected boolean isAlive(Block block, Material liveMaterial, boolean includeCommands) {
        Material neighborType = block.getType();
        return neighborType == liveMaterial || includeCommands && (neighborType == Material.COMMAND || neighborType == POWER_MATERIAL);
    }

    public static BlockFace findPowerLocation(Block block, Material targetMaterial) {
        BlockFace[] blockFaceArray = POWER_FACES;
        int n = POWER_FACES.length;
        int n2 = 0;
        while (n2 < n) {
            BlockFace face = blockFaceArray[n2];
            if (block.getRelative(face).getType() == targetMaterial) {
                return face;
            }
            ++n2;
        }
        return null;
    }

    protected int getNeighborCount(Block block, Material liveMaterial, boolean includeCommands) {
        int liveCount = 0;
        BlockFace[] blockFaceArray = neighborFaces;
        int n = neighborFaces.length;
        int n2 = 0;
        while (n2 < n) {
            BlockFace face = blockFaceArray[n2];
            if (this.isAlive(block.getRelative(face), liveMaterial, includeCommands)) {
                ++liveCount;
            }
            ++n2;
        }
        if (this.yRadius > 0) {
            Block upBlock = block.getRelative(BlockFace.UP);
            if (this.isAlive(upBlock, liveMaterial, includeCommands)) {
                ++liveCount;
            }
            BlockFace[] blockFaceArray2 = neighborFaces;
            int n3 = neighborFaces.length;
            n = 0;
            while (n < n3) {
                BlockFace face = blockFaceArray2[n];
                if (this.isAlive(upBlock.getRelative(face), liveMaterial, includeCommands)) {
                    ++liveCount;
                }
                ++n;
            }
            Block downBlock = block.getRelative(BlockFace.DOWN);
            if (this.isAlive(downBlock, liveMaterial, includeCommands)) {
                ++liveCount;
            }
            BlockFace[] blockFaceArray3 = neighborFaces;
            int n4 = neighborFaces.length;
            n3 = 0;
            while (n3 < n4) {
                BlockFace face = blockFaceArray3[n3];
                if (this.isAlive(downBlock.getRelative(face), liveMaterial, includeCommands)) {
                    ++liveCount;
                }
                ++n3;
            }
        }
        return liveCount;
    }

    @Override
    public void finish() {
        this.state = SimulationState.FINISHED;
        if (!this.finished) {
            super.finish();
            this.mage.registerForUndo(this.modifiedBlocks);
        }
    }

    private static enum SimulationState {
        SCANNING_COMMAND,
        SCANNING,
        UPDATING,
        COMMAND_SEARCH,
        COMMAND_UPDATE,
        COMMAND_POWER,
        FINISHED;

    }

    public static enum TargetMode {
        STABILIZE,
        WANDER,
        GLIDE,
        HUNT,
        FLEE,
        DIRECTED;

    }

    public static enum TargetType {
        PLAYER,
        MAGE,
        MOB,
        AUTOMATON,
        ANY;

    }
}

