/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.blocks;

import com.elmakers.mine.bukkit.blocks.VolumeBatch;
import com.elmakers.mine.bukkit.plugins.magic.BlockSpell;
import com.elmakers.mine.bukkit.plugins.magic.Mage;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;

public class RegenerateBatch
extends VolumeBatch {
    private final World world;
    private final Mage mage;
    private final BlockSpell spell;
    private final int absx;
    private final int absz;
    private final int dx;
    private final int dz;
    private final int x;
    private final int z;
    private int ix = 0;
    private int iz = 0;

    public RegenerateBatch(BlockSpell spell, Location p1, Location p2) {
        super(spell.getMage().getController(), p1.getWorld().getName());
        this.mage = spell.getMage();
        this.world = this.mage.getPlayer().getWorld();
        this.spell = spell;
        int deltax = p2.getBlock().getChunk().getX() - p1.getChunk().getX();
        int deltaz = p2.getChunk().getZ() - p1.getChunk().getZ();
        this.absx = Math.abs(deltax) + 1;
        this.absz = Math.abs(deltaz) + 1;
        this.dx = (int)Math.signum(deltax);
        this.dz = (int)Math.signum(deltaz);
        this.x = p1.getChunk().getX();
        this.z = p1.getChunk().getZ();
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public int remaining() {
        return (this.absx - this.x) * (this.absz - this.z) * 16 * 16;
    }

    public boolean checkDimension(int maxDimension) {
        return maxDimension <= 0 || this.absx * 16 <= maxDimension && this.absz * 16 <= maxDimension;
    }

    @Override
    public int process(int maxBlocks) {
        int maxChunks = (int)Math.ceil((float)maxBlocks / 256.0f);
        int processedChunks = 0;
        while (processedChunks <= maxChunks && this.ix < this.absx) {
            Chunk chunk = this.world.getChunkAt(this.x + this.ix * this.dx, this.z + this.iz * this.dz);
            if (!chunk.isLoaded()) {
                chunk.load();
                return processedChunks;
            }
            if (this.mage.hasBuildPermission(chunk.getBlock(0, 70, 0)) || !this.mage.hasBuildPermission(chunk.getBlock(8, 32, 8)) || !this.mage.hasBuildPermission(chunk.getBlock(15, 120, 15))) {
                this.world.regenerateChunk(chunk.getX(), chunk.getZ());
            }
            ++processedChunks;
            ++this.iz;
            if (this.iz < this.absz) continue;
            this.iz = 0;
            ++this.ix;
        }
        if (this.ix >= this.absx) {
            this.finish();
        }
        return processedChunks * 16 * 16;
    }

    @Override
    public void finish() {
        if (!this.finished) {
            super.finish();
            String message = this.spell.getMessage("cast_finish");
            message = message.replace("$count", Integer.toString(this.getXSize() * this.getZSize()));
            this.spell.castMessage(message);
        }
    }

    public int getXSize() {
        return this.absx;
    }

    public int getZSize() {
        return this.absz;
    }
}

