/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utilities;

import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class Target
implements Comparable<Target> {
    protected int maxDistance = 512;
    protected double maxAngle = 0.3;
    private Location source;
    private Location location;
    private Entity entity;
    private double distance = 100000.0;
    private double angle = 10000.0;
    private int score = 0;

    public Target(Location sourceLocation) {
        this.source = sourceLocation;
    }

    public Target(Location sourceLocation, Block block) {
        this.source = sourceLocation;
        this.location = block.getLocation();
        this.calculateScore();
    }

    public Target(Location sourceLocation, Entity entity, int range) {
        this.maxDistance = range;
        this.source = sourceLocation;
        this.entity = entity;
        this.location = entity.getLocation();
        this.calculateScore();
    }

    public Target(Location sourceLocation, Entity entity) {
        this.maxDistance = 0;
        this.source = sourceLocation;
        this.entity = entity;
        this.location = entity.getLocation();
    }

    public Target(Location sourceLocation, Entity entity, Block block) {
        this.maxDistance = 0;
        this.source = sourceLocation;
        this.entity = entity;
        if (block != null) {
            this.location = block.getLocation();
        } else if (entity != null) {
            this.location = entity.getLocation();
        }
    }

    public int getScore() {
        return this.score;
    }

    protected void calculateScore() {
        Vector playerFacing = this.source.getDirection();
        Vector playerLoc = new Vector(this.source.getBlockX(), this.source.getBlockY(), this.source.getBlockZ());
        Location targetLocation = this.getLocation();
        if (targetLocation == null) {
            return;
        }
        Vector targetLoc = new Vector(targetLocation.getBlockX(), targetLocation.getBlockY(), targetLocation.getBlockZ());
        Vector targetDirection = new Vector(targetLoc.getBlockX() - playerLoc.getBlockX(), targetLoc.getBlockY() - playerLoc.getBlockY(), targetLoc.getBlockZ() - playerLoc.getBlockZ());
        this.angle = targetDirection.angle(playerFacing);
        this.distance = targetDirection.length();
        this.score = 0;
        if (this.angle > this.maxAngle) {
            return;
        }
        if (this.distance > (double)this.maxDistance) {
            return;
        }
        this.score = (int)((double)this.maxDistance - this.distance + (3.0 - this.angle) * 4.0);
        this.score = this.entity instanceof Player ? (this.score += 3) : (this.entity instanceof LivingEntity ? (this.score += 5) : ++this.score);
    }

    @Override
    public int compareTo(Target other) {
        return other.score - this.score;
    }

    public boolean hasEntity() {
        return this.entity != null;
    }

    public boolean isValid() {
        return this.location != null;
    }

    public boolean hasTarget() {
        return this.location != null;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public Block getBlock() {
        if (this.location == null) {
            return null;
        }
        return this.location.getBlock();
    }

    public double getDistance() {
        return this.distance;
    }

    public Location getLocation() {
        return this.location;
    }

    public void add(Vector offset) {
        if (this.location != null) {
            this.location = this.location.add(offset);
        }
    }
}

