/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.blocks.BlockList;
import com.elmakers.mine.bukkit.plugins.magic.BlockSpell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Material;
import org.bukkit.block.Block;

public class TowerSpell
extends BlockSpell {
    private int blocksCreated;

    @Override
    public SpellResult onCast(ConfigurationNode parameters) {
        this.blocksCreated = 0;
        Block target = this.getTargetBlock();
        if (target == null) {
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(target)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        int MAX_HEIGHT = 255;
        int height = 16;
        int maxHeight = 255;
        int material = 20;
        int midX = target.getX();
        int midY = target.getY();
        int midZ = target.getZ();
        int i = height;
        while (i < maxHeight) {
            int y = midY + i;
            if (y > MAX_HEIGHT) {
                maxHeight = MAX_HEIGHT - midY;
                height = height > maxHeight ? maxHeight : height;
                break;
            }
            Block block = this.getBlockAt(midX, y, midZ);
            if (block.getType() != Material.AIR) {
                height = i;
                break;
            }
            ++i;
        }
        BlockList towerBlocks = new BlockList();
        int i2 = 0;
        while (i2 < height) {
            ++midY;
            int dx = -1;
            while (dx <= 1) {
                int dz = -1;
                while (dz <= 1) {
                    Block block;
                    int x = midX + dx;
                    int y = midY;
                    int z = midZ + dz;
                    if ((dx != 0 || dz != 0) && this.isDestructible(block = this.getBlockAt(x, y, z)) && this.hasBuildPermission(block)) {
                        ++this.blocksCreated;
                        towerBlocks.add(block);
                        block.setTypeId(material);
                    }
                    ++dz;
                }
                ++dx;
            }
            ++i2;
        }
        this.registerForUndo(towerBlocks);
        return SpellResult.CAST;
    }

    @Override
    public String getMessage(String messageKey, String def) {
        String message = super.getMessage(messageKey, def);
        return message.replace("$count", Integer.toString(this.blocksCreated));
    }
}

