/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.blocks.SimulateBatch;
import com.elmakers.mine.bukkit.plugins.magic.BlockSpell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.Target;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class SimulateSpell
extends BlockSpell {
    private static final int DEFAULT_RADIUS = 32;

    @Override
    public SpellResult onCast(ConfigurationNode parameters) {
        Target t = this.getTarget();
        if (t == null) {
            return SpellResult.NO_TARGET;
        }
        Block target = t.getBlock();
        if (target == null) {
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(target)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        int radius = parameters.getInt("radius", 32);
        radius = parameters.getInt("r", radius);
        radius = (int)((float)radius * this.mage.getConstructionMultiplier());
        Material birthMaterial = target.getType();
        birthMaterial = parameters.getMaterial("material", birthMaterial);
        birthMaterial = parameters.getMaterial("m", birthMaterial);
        Double dmxValue = parameters.getDouble("dmx", null);
        Double dmyValue = parameters.getDouble("dmy", null);
        Double dmzValue = parameters.getDouble("dmz", null);
        if (dmxValue != null || dmyValue != null || dmzValue != null) {
            Vector offset = new Vector(dmxValue == null ? 0.0 : dmxValue, dmyValue == null ? 0.0 : dmyValue, dmzValue == null ? 0.0 : dmzValue);
            Location targetLocation = target.getLocation().add(offset);
            if (!targetLocation.getBlock().getChunk().isLoaded()) {
                return SpellResult.FAIL;
            }
            birthMaterial = targetLocation.getBlock().getType();
        }
        Material deathMaterial = parameters.getMaterial("death_material", Material.AIR);
        final SimulateBatch batch = new SimulateBatch(this, target.getLocation(), radius, birthMaterial, deathMaterial);
        boolean includeCommands = parameters.getBoolean("commands", true);
        if (includeCommands) {
            if (this.mage.getCommandSender() instanceof BlockCommandSender) {
                BlockCommandSender commandBlock = (BlockCommandSender)this.mage.getCommandSender();
                batch.setCommandBlock(commandBlock.getBlock());
            } else if (target.getType() == Material.COMMAND) {
                batch.setCommandBlock(target);
            }
        }
        int delay = parameters.getInt("delay", 0);
        if ((delay /= 50) > 0) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.controller.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    SimulateSpell.this.mage.addPendingBlockBatch(batch);
                }
            }, (long)delay);
        } else {
            this.mage.addPendingBlockBatch(batch);
        }
        return SpellResult.CAST;
    }
}

