/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.blocks.BlockRecurse;
import com.elmakers.mine.bukkit.blocks.MaterialBrush;
import com.elmakers.mine.bukkit.blocks.ReplaceMaterialAction;
import com.elmakers.mine.bukkit.plugins.magic.BrushSpell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Material;
import org.bukkit.block.Block;

public class RecurseSpell
extends BrushSpell {
    private final BlockRecurse blockRecurse = new BlockRecurse();

    @Override
    public SpellResult onCast(ConfigurationNode parameters) {
        Block targetBlock = this.getTargetBlock();
        if (targetBlock == null) {
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(targetBlock)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        MaterialBrush buildWith = this.getMaterialBrush();
        int size = parameters.getInt("size", 8);
        size = (int)(this.mage.getRadiusMultiplier() * (float)size);
        this.blockRecurse.setMaxRecursion(size);
        Material targetMaterial = targetBlock.getType();
        ReplaceMaterialAction action = new ReplaceMaterialAction(this.mage, targetBlock, buildWith);
        if (targetMaterial == Material.STATIONARY_WATER || targetMaterial == Material.WATER) {
            byte i = 0;
            while (i < 9) {
                action.addReplaceable(Material.STATIONARY_WATER, i);
                action.addReplaceable(Material.WATER, i);
                i = (byte)(i + 1);
            }
        } else if (targetMaterial == Material.STATIONARY_LAVA || targetMaterial == Material.LAVA) {
            byte i = 0;
            while (i < 9) {
                action.addReplaceable(Material.STATIONARY_LAVA, i);
                action.addReplaceable(Material.LAVA, i);
                i = (byte)(i + 1);
            }
        } else if (targetMaterial == Material.SNOW) {
            byte i = 0;
            while (i < 8) {
                action.addReplaceable(Material.SNOW, i);
                i = (byte)(i + 1);
            }
        }
        this.blockRecurse.recurse(targetBlock, action);
        this.mage.registerForUndo(action.getBlocks());
        this.controller.updateBlock(targetBlock);
        return SpellResult.CAST;
    }
}

