/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.blocks.BlockList;
import com.elmakers.mine.bukkit.blocks.FillBatch;
import com.elmakers.mine.bukkit.blocks.MaterialBrush;
import com.elmakers.mine.bukkit.plugins.magic.BrushSpell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.plugins.magic.TargetType;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Location;
import org.bukkit.block.Block;

public class FillSpell
extends BrushSpell {
    private static final int DEFAULT_MAX_DIMENSION = 128;
    private Block targetBlock = null;

    @Override
    public SpellResult onCast(ConfigurationNode parameters) {
        boolean singleBlock;
        Block targetBlock = this.getTargetBlock();
        boolean bl = singleBlock = this.getTargetType() != TargetType.SELECT;
        if (targetBlock == null) {
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(targetBlock)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        MaterialBrush buildWith = this.getMaterialBrush();
        if (singleBlock) {
            this.deactivate();
            BlockList filledBlocks = new BlockList();
            int undoTime = parameters.getInt("undo", 0);
            undoTime = parameters.getInt("u", undoTime);
            filledBlocks.setTimeToLive(undoTime);
            filledBlocks.add(targetBlock);
            buildWith.setTarget(targetBlock.getLocation());
            buildWith.update(this.mage, targetBlock.getLocation());
            buildWith.modify(targetBlock);
            this.controller.updateBlock(targetBlock);
            this.registerForUndo(filledBlocks);
            return SpellResult.CAST;
        }
        if (this.targetLocation2 != null) {
            this.targetBlock = this.targetLocation2.getBlock();
        }
        if (this.targetBlock != null) {
            Location centerLocation = targetBlock.getLocation();
            Location secondLocation = this.targetBlock.getLocation();
            centerLocation.setX(Math.floor((centerLocation.getX() + secondLocation.getX()) / 2.0));
            centerLocation.setY(Math.floor((centerLocation.getY() + secondLocation.getY()) / 2.0));
            centerLocation.setZ(Math.floor((centerLocation.getZ() + secondLocation.getZ()) / 2.0));
            buildWith.setTarget(this.targetBlock.getLocation(), centerLocation);
            FillBatch batch = new FillBatch(this, secondLocation, targetBlock.getLocation(), buildWith);
            int maxDimension = parameters.getInteger("max_dimension", 128);
            maxDimension = parameters.getInteger("md", maxDimension);
            maxDimension = (int)(this.mage.getConstructionMultiplier() * (float)maxDimension);
            if (!batch.checkDimension(maxDimension)) {
                return SpellResult.FAIL;
            }
            batch.setTimeToLive(parameters.getInt("undo", 0));
            this.mage.addPendingBlockBatch(batch);
            this.deactivate();
            return SpellResult.CAST;
        }
        this.targetBlock = targetBlock;
        this.activate();
        return SpellResult.TARGET_SELECTED;
    }

    @Override
    public boolean onCancel() {
        if (this.targetBlock != null) {
            this.deactivate();
            return true;
        }
        return false;
    }

    @Override
    public void onDeactivate() {
        this.targetBlock = null;
    }
}

