/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.Target;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Location;
import org.bukkit.block.Block;

public class BoomSpell
extends Spell {
    protected int defaultSize = 1;

    public SpellResult createExplosionAt(Location target, float size, boolean incendiary, boolean breakBlocks) {
        if (target == null) {
            return SpellResult.NO_TARGET;
        }
        Block block = target.getBlock();
        if (!this.hasBuildPermission(block)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        Location l = block.getLocation();
        this.getWorld().createExplosion(l.getX(), l.getY(), l.getZ(), size, incendiary, breakBlocks);
        this.controller.updateBlock(block);
        return SpellResult.CAST;
    }

    @Override
    public SpellResult onCast(ConfigurationNode parameters) {
        int size = parameters.getInt("size", this.defaultSize);
        boolean useFire = parameters.getBoolean("fire", false);
        boolean breakBlocks = parameters.getBoolean("break_blocks", true);
        size = (int)(this.mage.getRadiusMultiplier() * (float)size);
        Target target = this.getTarget();
        if (!target.hasTarget()) {
            return SpellResult.NO_TARGET;
        }
        return this.createExplosionAt(target.getLocation(), size, useFire, breakBlocks);
    }
}

