/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic;

import com.elmakers.mine.bukkit.blocks.BlockAction;
import com.elmakers.mine.bukkit.blocks.MaterialAndData;
import com.elmakers.mine.bukkit.effects.EffectPlayer;
import com.elmakers.mine.bukkit.effects.EffectSingle;
import com.elmakers.mine.bukkit.effects.EffectTrail;
import com.elmakers.mine.bukkit.effects.ParticleType;
import com.elmakers.mine.bukkit.plugins.magic.CastingCost;
import com.elmakers.mine.bukkit.plugins.magic.CostReducer;
import com.elmakers.mine.bukkit.plugins.magic.Mage;
import com.elmakers.mine.bukkit.plugins.magic.MagicController;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.plugins.magic.TargetType;
import com.elmakers.mine.bukkit.utilities.CSVParser;
import com.elmakers.mine.bukkit.utilities.Messages;
import com.elmakers.mine.bukkit.utilities.RandomUtils;
import com.elmakers.mine.bukkit.utilities.Target;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public abstract class Spell
implements Comparable<Spell>,
Cloneable,
CostReducer {
    protected MagicController controller;
    protected Mage mage;
    protected static CSVParser csv = new CSVParser();
    private String key;
    private String name;
    private String description;
    private String usage;
    private String category;
    private MaterialAndData icon = new MaterialAndData(Material.AIR);
    private List<CastingCost> costs = null;
    private List<CastingCost> activeCosts = null;
    private Vector direction = null;
    protected ConfigurationNode parameters = new ConfigurationNode();
    private boolean allowMaxRange = false;
    private boolean pvpRestricted = false;
    private boolean bypassBuildRestriction = false;
    private boolean bypassPvpRestriction = false;
    private float cooldownReduction = 0.0f;
    private float costReduction = 0.0f;
    private int range = 32;
    private static int maxRange = 511;
    private double viewHeight = 1.65;
    private double step = 0.2;
    private int cooldown = 0;
    private int duration = 0;
    private long lastCast = 0L;
    private long castCount = 0L;
    private long lastMessageSent = 0L;
    private int verticalSearchDistance = 8;
    private boolean targetingComplete;
    private boolean targetSpaceRequired = false;
    private Class<? extends Entity> targetEntityType = null;
    private Location location;
    private Location targetLocation;
    private Vector targetLocationOffset;
    protected Location targetLocation2;
    private Entity targetEntity = null;
    private Location defaultTargetLocation = null;
    private double xRotation;
    private double yRotation;
    private double length;
    private double hLength;
    private double xOffset;
    private double yOffset;
    private double zOffset;
    private int lastX;
    private int lastY;
    private int lastZ;
    private int targetX;
    private int targetY;
    private int targetZ;
    private Set<Material> targetThroughMaterials = new HashSet<Material>();
    private boolean reverseTargeting = false;
    private boolean isActive = false;
    private Map<SpellResult, List<EffectPlayer>> effects = new HashMap<SpellResult, List<EffectPlayer>>();
    private Target target = null;
    private String targetName = null;
    private TargetType targetType = TargetType.OTHER;
    private boolean targetNPCs = false;
    private float fizzleChance = 0.0f;
    private float backfireChance = 0.0f;

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    protected static String getBuiltinClasspath() {
        String baseClass = Spell.class.getName();
        return baseClass.substring(0, baseClass.lastIndexOf(46));
    }

    public static Spell loadSpell(String name, ConfigurationNode node, MagicController controller) {
        Object newObject;
        String builtinClassPath = Spell.getBuiltinClasspath();
        String className = node.getString("class");
        if (className == null) {
            return null;
        }
        if (className.indexOf(46) <= 0) {
            className = String.valueOf(builtinClassPath) + ".spells." + className;
        }
        Class<?> spellClass = null;
        try {
            spellClass = Class.forName(className);
        }
        catch (Throwable ex) {
            controller.getLogger().warning("Error loading spell: " + name + ", " + ex.getMessage());
            return null;
        }
        try {
            newObject = spellClass.newInstance();
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        if (newObject == null || !(newObject instanceof Spell)) {
            return null;
        }
        Spell newSpell = (Spell)newObject;
        newSpell.initialize(controller);
        newSpell.loadTemplate(name, node);
        return newSpell;
    }

    public void checkActiveCosts() {
        if (this.activeCosts == null) {
            return;
        }
        for (CastingCost cost : this.activeCosts) {
            if (!cost.has(this)) {
                this.deactivate();
                return;
            }
            cost.use(this);
        }
    }

    public void checkActiveDuration() {
        if (this.duration > 0 && this.lastCast < System.currentTimeMillis() - (long)this.duration) {
            this.deactivate();
        }
    }

    protected void activate() {
        this.onActivate();
        this.mage.activateSpell(this);
        this.isActive = true;
    }

    protected void deactivate() {
        this.onDeactivate();
        this.mage.deactivateSpell(this);
        this.isActive = false;
    }

    protected List<CastingCost> parseCosts(ConfigurationNode node) {
        if (node == null) {
            return null;
        }
        ArrayList<CastingCost> castingCosts = new ArrayList<CastingCost>();
        List<String> costKeys = node.getKeys();
        for (String key : costKeys) {
            castingCosts.add(new CastingCost(key, node.getDouble(key, 1.0)));
        }
        return castingCosts;
    }

    public void configure(ConfigurationNode node) {
    }

    protected void loadTemplate(String key, ConfigurationNode node) {
        this.key = key;
        this.loadTemplate(node);
    }

    protected void loadTemplate(ConfigurationNode node) {
        this.name = this.key;
        this.name = node.getString("name", this.name);
        this.name = Messages.get("spells." + this.key + ".name", this.name);
        this.description = node.getString("description", "");
        this.description = Messages.get("spells." + this.key + ".description", this.description);
        this.usage = Messages.get("spells." + this.key + ".usage", this.usage);
        this.icon = node.getMaterialAndData("icon", this.icon.getMaterial());
        this.category = node.getString("category", this.category);
        this.parameters = node.getNode("parameters", this.parameters);
        this.pvpRestricted = node.getBoolean("pvp_restricted", this.pvpRestricted);
        this.costs = this.parseCosts(node.getNode("costs"));
        this.activeCosts = this.parseCosts(node.getNode("active_costs"));
        this.effects.clear();
        if (node.containsKey("effects")) {
            ConfigurationNode effectsNode = node.getNode("effects");
            SpellResult[] spellResultArray = SpellResult.values();
            int n = spellResultArray.length;
            int n2 = 0;
            while (n2 < n) {
                List<Object> effectNodes;
                SpellResult resultType = spellResultArray[n2];
                String typeName = resultType.name().toLowerCase();
                if (effectsNode.containsKey(typeName) && (effectNodes = effectsNode.getList(typeName)) != null) {
                    ArrayList<EffectPlayer> players = new ArrayList<EffectPlayer>();
                    for (Object o : effectNodes) {
                        Object oClass;
                        Map effectValues;
                        if (!(o instanceof Map) || !(effectValues = (Map)o).containsKey("class") || !((oClass = effectValues.get("class")) instanceof String)) continue;
                        String effectClass = (String)oClass;
                        try {
                            Class<?> genericClass = Class.forName("com.elmakers.mine.bukkit.effects." + effectClass);
                            if (!EffectPlayer.class.isAssignableFrom(genericClass)) {
                                throw new Exception("Must extend EffectPlayer");
                            }
                            Class<?> playerClass = genericClass;
                            EffectPlayer player = (EffectPlayer)playerClass.newInstance();
                            ConfigurationNode effectNode = new ConfigurationNode(effectValues);
                            player.load((Plugin)this.controller.getPlugin(), effectNode);
                            players.add(player);
                        }
                        catch (Exception ex) {
                            this.controller.getLogger().info("Error creating effect class: " + effectClass + " " + ex.getMessage());
                        }
                    }
                    this.effects.put(resultType, players);
                }
                ++n2;
            }
        }
        this.initializeDefaultSound(SpellResult.FAIL, Sound.NOTE_BASS_DRUM, 0.9f, 1.2f);
        this.initializeDefaultSound(SpellResult.INSUFFICIENT_RESOURCES, Sound.NOTE_BASS, 1.0f, 1.2f);
        this.initializeDefaultSound(SpellResult.INSUFFICIENT_PERMISSION, Sound.NOTE_BASS, 1.1f, 1.5f);
        this.initializeDefaultSound(SpellResult.COOLDOWN, Sound.NOTE_SNARE_DRUM, 1.1f, 0.9f);
        this.initializeDefaultSound(SpellResult.NO_TARGET, Sound.NOTE_STICKS, 1.1f, 0.9f);
        if (!this.effects.containsKey((Object)SpellResult.TARGET_SELECTED)) {
            ArrayList<EffectPlayer> effectList = new ArrayList<EffectPlayer>();
            EffectSingle targetHighlight = new EffectSingle((Plugin)this.controller.getPlugin());
            targetHighlight.setSound(Sound.ANVIL_USE);
            targetHighlight.setParticleType(ParticleType.HAPPY_VILLAGER);
            targetHighlight.setLocationType("target");
            targetHighlight.setOffset(0.5f, 0.5f, 0.5f);
            effectList.add(targetHighlight);
            EffectTrail trail = new EffectTrail((Plugin)this.controller.getPlugin());
            trail.setParticleType(ParticleType.WATER_DRIPPING);
            effectList.add(trail);
            this.effects.put(SpellResult.TARGET_SELECTED, effectList);
        }
        if (!this.effects.containsKey((Object)SpellResult.COST_FREE) && this.effects.containsKey((Object)SpellResult.CAST)) {
            this.effects.put(SpellResult.COST_FREE, this.effects.get((Object)SpellResult.CAST));
        }
    }

    protected void initializeDefaultSound(SpellResult result, Sound sound, float volume, float pitch) {
        if (this.effects.containsKey((Object)result)) {
            return;
        }
        EffectSingle defaultEffect = new EffectSingle((Plugin)this.controller.getPlugin());
        defaultEffect.setSound(sound, volume, pitch);
        ArrayList<EffectSingle> effectList = new ArrayList<EffectSingle>();
        effectList.add(defaultEffect);
        this.effects.put(result, effectList);
    }

    public void setMage(Mage mage) {
        this.mage = mage;
    }

    public final String getKey() {
        return this.key;
    }

    public final String getName() {
        return this.name;
    }

    public final MaterialAndData getIcon() {
        return this.icon;
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getUsage() {
        return this.usage;
    }

    public final String getCategory() {
        return this.category;
    }

    public boolean isMatch(String spell, String[] params) {
        if (params == null) {
            params = new String[]{};
        }
        return this.key.equalsIgnoreCase(spell) && this.parameters.equals(params);
    }

    @Override
    public int compareTo(Spell other) {
        return this.name.compareTo(other.name);
    }

    public boolean cast() {
        return this.cast(new String[0], null);
    }

    public static void addParameters(String[] extraParameters, ConfigurationNode parameters) {
        if (extraParameters != null) {
            int i = 0;
            while (i < extraParameters.length - 1) {
                parameters.setProperty(extraParameters[i], extraParameters[i + 1]);
                i += 2;
            }
        }
    }

    protected void preCast() {
    }

    public boolean cast(String[] extraParameters, Location defaultTarget) {
        this.preCast();
        this.target = null;
        this.targetName = null;
        this.defaultTargetLocation = defaultTarget;
        this.location = this.mage.getLocation();
        ConfigurationNode parameters = new ConfigurationNode(this.parameters);
        Spell.addParameters(extraParameters, parameters);
        this.processParameters(parameters);
        this.initializeTargeting();
        this.cooldown = parameters.getInt("cooldown", this.cooldown);
        this.cooldown = parameters.getInt("cd", this.cooldown);
        long currentTime = System.currentTimeMillis();
        double cooldownReduction = this.mage.getCooldownReduction() + this.cooldownReduction;
        if (cooldownReduction < 1.0 && !this.isActive && this.cooldown > 0) {
            int reducedCooldown = (int)Math.ceil((1.0 - cooldownReduction) * (double)this.cooldown);
            if (this.lastCast != 0L && this.lastCast > currentTime - (long)reducedCooldown) {
                long seconds = (this.lastCast - (currentTime - (long)reducedCooldown)) / 1000L;
                if (seconds > 3600L) {
                    long hours = seconds / 3600L;
                    this.sendMessage(Messages.get("cooldown.wait_hours").replace("$hours", Long.valueOf(hours).toString()));
                } else if (seconds > 60L) {
                    long minutes = seconds / 60L;
                    this.sendMessage(Messages.get("cooldown.wait_minutes").replace("$minutes", Long.valueOf(minutes).toString()));
                } else if (seconds > 1L) {
                    this.sendMessage(Messages.get("cooldown.wait_seconds").replace("$seconds", Long.valueOf(seconds).toString()));
                } else {
                    this.sendMessage(Messages.get("cooldown.wait_moment"));
                }
                this.processResult(SpellResult.COOLDOWN);
                return false;
            }
        }
        if (this.costs != null && !this.isActive) {
            for (CastingCost cost : this.costs) {
                if (cost.has(this)) continue;
                String baseMessage = Messages.get("costs.insufficient_resources");
                String costDescription = cost.getDescription(this.mage);
                this.sendMessage(baseMessage.replace("$cost", costDescription));
                this.processResult(SpellResult.INSUFFICIENT_RESOURCES);
                return false;
            }
        }
        if (this.pvpRestricted && !this.bypassPvpRestriction && !this.controller.isPVPAllowed(this.mage.getLocation())) {
            this.processResult(SpellResult.INSUFFICIENT_PERMISSION);
            return false;
        }
        return this.finalizeCast(parameters);
    }

    protected boolean finalizeCast(ConfigurationNode parameters) {
        SpellResult result = null;
        if (!this.mage.isSuperPowered()) {
            if (this.backfireChance > 0.0f && Math.random() < (double)this.backfireChance) {
                this.targetType = TargetType.SELF;
                this.onCast(parameters);
                result = SpellResult.BACKFIRE;
            } else if (this.fizzleChance > 0.0f && Math.random() < (double)this.fizzleChance) {
                result = SpellResult.FIZZLE;
            }
        }
        if (result == null) {
            result = this.onCast(parameters);
        }
        this.processResult(result);
        if (result.isSuccess()) {
            this.lastCast = System.currentTimeMillis();
            if (this.costs != null) {
                for (CastingCost cost : this.costs) {
                    cost.use(this);
                }
            }
            ++this.castCount;
        }
        return result.isSuccess();
    }

    protected void initializeTargeting() {
        this.length = 0.0;
        this.targetSpaceRequired = false;
        this.xRotation = (this.location.getYaw() + 90.0f) % 360.0f;
        this.yRotation = this.location.getPitch() * -1.0f;
        this.reverseTargeting = false;
        this.targetX = (int)Math.floor(this.location.getX());
        this.targetY = (int)Math.floor(this.location.getY() + this.viewHeight);
        this.targetZ = (int)Math.floor(this.location.getZ());
        this.lastX = this.targetX;
        this.lastY = this.targetY;
        this.lastZ = this.targetZ;
        this.targetingComplete = false;
    }

    public String getMessage(String messageKey) {
        return this.getMessage(messageKey, "");
    }

    public String getMessage(String messageKey, String def) {
        Player player;
        String message = Messages.get("spells.default." + messageKey, def);
        message = Messages.get("spells." + this.key + "." + messageKey, message);
        if (message == null) {
            message = "";
        }
        String playerName = (player = this.getPlayer()) == null ? "Unknown" : player.getName();
        message = message.replace("$player", playerName);
        String useTargetName = this.targetName;
        if (useTargetName == null) {
            useTargetName = this.target != null && this.target.hasEntity() && this.target.getEntity() instanceof Player ? ((Player)this.target.getEntity()).getName() : "Unknown";
        }
        message = message.replace("$target", useTargetName);
        return message;
    }

    protected void setTargetName(String name) {
        this.targetName = name;
    }

    protected void processResult(SpellResult result) {
        if (result.isSuccess()) {
            this.controller.onCast(this.mage, this, result);
        }
        if (result == SpellResult.CAST) {
            Entity targetEntity;
            String message = this.getMessage(result.name().toLowerCase());
            Player player = this.mage.getPlayer();
            Entity entity = targetEntity = this.target != null ? this.target.getEntity() : null;
            if (targetEntity == player) {
                message = this.getMessage("cast_self", message);
            } else if (targetEntity instanceof Player) {
                message = this.getMessage("cast_player", message);
            } else if (targetEntity instanceof LivingEntity) {
                message = this.getMessage("cast_livingentity", message);
            } else if (targetEntity instanceof Entity) {
                message = this.getMessage("cast_entity", message);
            }
            this.castMessage(message);
        } else {
            this.sendMessage(this.getMessage(result.name().toLowerCase()));
        }
        Location mageLocation = this.getEyeLocation();
        if (this.effects.containsKey((Object)result) && mageLocation != null) {
            Location targetLocation = null;
            if (this.target != null) {
                targetLocation = this.target.getLocation();
            }
            List<EffectPlayer> resultEffects = this.effects.get((Object)result);
            for (EffectPlayer player : resultEffects) {
                player.setMaterial(this.mage.getBrush());
                player.setColor(this.mage.getEffectColor());
                player.start(mageLocation, targetLocation);
            }
        }
    }

    protected void processParameters(ConfigurationNode parameters) {
        String worldName;
        this.duration = parameters.getInt("duration", this.duration);
        this.range = parameters.getInteger("range", this.range);
        this.allowMaxRange = parameters.getBoolean("allow_max_range", this.allowMaxRange);
        if (parameters.containsKey("target_through")) {
            this.targetThroughMaterials = parameters.getMaterials("target_through");
        } else if (parameters.containsKey("transparent")) {
            this.targetThroughMaterials.clear();
            this.targetThroughMaterials.addAll(this.controller.getMaterialSet(parameters.getString("transparent")));
        } else {
            this.targetThroughMaterials.clear();
            this.targetThroughMaterials.addAll(this.controller.getMaterialSet("transparent"));
        }
        this.fizzleChance = parameters.getFloat("fizzle_chance", this.fizzleChance);
        this.backfireChance = parameters.getFloat("backfire_chance", this.backfireChance);
        if (parameters.containsKey("target")) {
            String targetTypeName = parameters.getString("target");
            try {
                this.targetType = TargetType.valueOf(targetTypeName.toUpperCase());
            }
            catch (Exception ex) {
                this.controller.getLogger().warning("Invalid target_type: " + targetTypeName);
                this.targetType = TargetType.OTHER;
            }
        } else {
            this.targetType = TargetType.OTHER;
        }
        this.targetNPCs = parameters.getBoolean("target_npc", false);
        if (parameters.containsKey("target_type")) {
            String entityTypeName = parameters.getString("target_type");
            try {
                Class<?> typeClass = Class.forName("org.bukkit.entity." + entityTypeName);
                if (Entity.class.isAssignableFrom(typeClass)) {
                    this.targetEntityType = typeClass;
                } else {
                    this.controller.getLogger().warning("Entity type: " + entityTypeName + " not assignable to Entity");
                }
            }
            catch (Throwable ex) {
                this.controller.getLogger().warning("Unknown entity type: " + entityTypeName);
                this.targetEntityType = null;
            }
        }
        if ((worldName = parameters.getString("world")) != null && worldName.length() > 0) {
            this.location = new Location(Bukkit.getWorld((String)worldName), 0.0, 0.0, 0.0);
        }
        Double yValue = parameters.getDouble("py", null);
        Double xValue = parameters.getDouble("px", null);
        Double zValue = parameters.getDouble("pz", null);
        this.location = xValue != null && zValue != null && yValue != null ? new Location(this.location.getWorld(), xValue.doubleValue(), yValue.doubleValue(), zValue.doubleValue(), this.location.getYaw(), this.location.getPitch()) : this.mage.getLocation();
        Double dpyValue = parameters.getDouble("dpy", null);
        Double dpxValue = parameters.getDouble("dpx", null);
        Double dpzValue = parameters.getDouble("dpz", null);
        if (dpxValue != null || dpzValue != null || dpyValue != null) {
            this.location = new Location(this.location.getWorld(), this.location.getX() + (dpxValue == null ? 0.0 : dpxValue), this.location.getY() + (dpyValue == null ? 0.0 : dpyValue), this.location.getZ() + (dpzValue == null ? 0.0 : dpzValue), this.location.getYaw(), this.location.getPitch());
        }
        Double tyValue = parameters.getDouble("ty", null);
        Double txValue = parameters.getDouble("tx", null);
        Double tzValue = parameters.getDouble("tz", null);
        this.targetLocation = txValue != null && tzValue != null && tyValue != null ? new Location(this.location.getWorld(), txValue.doubleValue(), tyValue.doubleValue(), tzValue.doubleValue(), this.location.getYaw(), this.location.getPitch()) : null;
        Double dtyValue = parameters.getDouble("dty", null);
        Double dtxValue = parameters.getDouble("dtx", null);
        Double dtzValue = parameters.getDouble("dtz", null);
        if (dtxValue != null || dtzValue != null || dtyValue != null) {
            if (this.targetLocation == null) {
                if (this.defaultTargetLocation == null) {
                    this.defaultTargetLocation = this.getLocation();
                }
                this.targetLocation = this.defaultTargetLocation.clone();
            }
            this.targetLocation = new Location(this.targetLocation.getWorld(), this.targetLocation.getX() + (dtxValue == null ? 0.0 : dtxValue), this.targetLocation.getY() + (dtyValue == null ? 0.0 : dtyValue), this.targetLocation.getZ() + (dtzValue == null ? 0.0 : dtzValue), this.targetLocation.getYaw(), this.targetLocation.getPitch());
        }
        this.targetLocationOffset = null;
        Double otyValue = parameters.getDouble("oty", null);
        Double otxValue = parameters.getDouble("otx", null);
        Double otzValue = parameters.getDouble("otz", null);
        if (otxValue != null || otzValue != null || otyValue != null) {
            this.targetLocationOffset = new Vector(otxValue == null ? 0.0 : otxValue, otyValue == null ? 0.0 : otyValue, otzValue == null ? 0.0 : otzValue);
        }
        Double dyValue = parameters.getDouble("dy", null);
        Double dxValue = parameters.getDouble("dx", null);
        Double dzValue = parameters.getDouble("dz", null);
        this.direction = dxValue != null || dzValue != null || dyValue != null ? new Vector(dxValue == null ? 0.0 : dxValue, dyValue == null ? 0.0 : dyValue, dzValue == null ? 0.0 : dzValue) : null;
        Double ddxValue = parameters.getDouble("ddx", null);
        Double ddyValue = parameters.getDouble("ddy", null);
        Double ddzValue = parameters.getDouble("ddz", null);
        if (dtxValue != null || dtzValue != null || dtyValue != null) {
            if (this.direction == null) {
                this.direction = this.getDirection();
            }
            this.direction.setX(this.direction.getX() + (ddxValue == null ? 0.0 : ddxValue));
            this.direction.setY(this.direction.getY() + (ddyValue == null ? 0.0 : ddyValue));
            this.direction.setZ(this.direction.getZ() + (ddzValue == null ? 0.0 : ddzValue));
        }
        this.targetLocation2 = null;
        Double tx2Value = parameters.getDouble("tx2", null);
        Double ty2Value = parameters.getDouble("ty2", null);
        Double tz2Value = parameters.getDouble("tz2", null);
        if (this.location != null && tx2Value != null && ty2Value != null && tz2Value != null) {
            this.targetLocation2 = new Location(this.location.getWorld(), tx2Value.doubleValue(), ty2Value.doubleValue(), tz2Value.doubleValue(), this.location.getYaw(), this.location.getPitch());
        }
        Double dty2Value = parameters.getDouble("dty2", null);
        Double dtx2Value = parameters.getDouble("dtx2", null);
        Double dtz2Value = parameters.getDouble("dtz2", null);
        if (dtx2Value != null || dtz2Value != null || dty2Value != null) {
            if (this.targetLocation2 == null) {
                this.targetLocation2 = this.targetLocation.clone();
            }
            this.targetLocation2 = new Location(this.targetLocation2.getWorld(), this.targetLocation2.getX() + (dtx2Value == null ? 0.0 : dtx2Value), this.targetLocation2.getY() + (dty2Value == null ? 0.0 : dty2Value), this.targetLocation2.getZ() + (dtz2Value == null ? 0.0 : dtz2Value), this.targetLocation2.getYaw(), this.targetLocation2.getPitch());
        }
        if (this.direction != null && this.location != null) {
            this.direction = this.direction.normalize();
            this.location = RandomUtils.setDirection(this.location, this.direction);
        }
        if (parameters.containsKey("player")) {
            Player player = this.controller.getPlugin().getServer().getPlayer(parameters.getString("player"));
            if (player != null) {
                this.targetLocation = player.getLocation();
                this.targetEntity = player;
            }
        } else {
            this.targetEntity = null;
        }
        this.bypassBuildRestriction = parameters.getBoolean("bypass_build", false);
        this.bypassBuildRestriction = parameters.getBoolean("bb", this.bypassBuildRestriction);
        this.bypassPvpRestriction = parameters.getBoolean("bypass_pvp", false);
        this.bypassPvpRestriction = parameters.getBoolean("bp", this.bypassPvpRestriction);
        this.costReduction = parameters.getFloat("cost_reduction", 0.0f);
        this.cooldownReduction = parameters.getFloat("cooldown_reduction", 0.0f);
        if (this.isUnderwater()) {
            this.targetThroughMaterials.add(Material.WATER);
            this.targetThroughMaterials.add(Material.STATIONARY_WATER);
        }
    }

    public String getPermissionNode() {
        return "Magic.cast." + this.key;
    }

    public boolean hasSpellPermission(Player player) {
        if (player == null) {
            return true;
        }
        return this.controller.hasPermission(player, this.getPermissionNode(), true);
    }

    public abstract SpellResult onCast(ConfigurationNode var1);

    public boolean onCancel() {
        return false;
    }

    public void onPlayerQuit(PlayerQuitEvent event) {
    }

    public void onPlayerDeath(EntityDeathEvent event) {
    }

    public void onPlayerDamage(EntityDamageEvent event) {
    }

    public static byte getItemData(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        return (byte)stack.getDurability();
    }

    public Player getPlayer() {
        return this.mage.getPlayer();
    }

    public CommandSender getCommandSender() {
        return this.mage.getCommandSender();
    }

    public boolean hasBuildPermission(Block block) {
        if (this.bypassBuildRestriction) {
            return true;
        }
        return this.mage.hasBuildPermission(block);
    }

    public void targetThrough(Material mat) {
        this.targetThroughMaterials.add(mat);
    }

    public void targetThrough(Set<Material> mat) {
        this.targetThroughMaterials.clear();
        this.targetThroughMaterials.addAll(mat);
    }

    public void noTargetThrough(Material mat) {
        this.targetThroughMaterials.remove(mat);
    }

    public boolean isTargetable(Material mat) {
        boolean targetThrough = this.targetThroughMaterials.contains(mat);
        if (this.reverseTargeting) {
            return targetThrough;
        }
        return !targetThrough;
    }

    public void setReverseTargeting(boolean reverse) {
        this.reverseTargeting = reverse;
    }

    public boolean isReverseTargeting() {
        return this.reverseTargeting;
    }

    public void setTargetSpaceRequired() {
        this.targetSpaceRequired = true;
    }

    public void setTarget(Location location) {
        this.target = new Target(this.getLocation(), location.getBlock());
    }

    public boolean isOkToStandIn(Material mat) {
        return mat == Material.AIR || mat == Material.WATER || mat == Material.STATIONARY_WATER || mat == Material.SNOW || mat == Material.TORCH || mat == Material.SIGN_POST || mat == Material.REDSTONE_TORCH_ON || mat == Material.REDSTONE_TORCH_OFF || mat == Material.YELLOW_FLOWER || mat == Material.RED_ROSE || mat == Material.RED_MUSHROOM || mat == Material.BROWN_MUSHROOM || mat == Material.LONG_GRASS;
    }

    public boolean isWater(Material mat) {
        return mat == Material.WATER || mat == Material.STATIONARY_WATER;
    }

    public boolean isOkToStandOn(Material mat) {
        return mat != Material.AIR && mat != Material.LAVA && mat != Material.STATIONARY_LAVA;
    }

    public boolean isSafeLocation(Block block) {
        if (!block.getChunk().isLoaded()) {
            block.getChunk().load(true);
            return false;
        }
        if (block.getY() > 255) {
            return false;
        }
        Block blockOneUp = block.getRelative(BlockFace.UP);
        Block blockOneDown = block.getRelative(BlockFace.DOWN);
        return this.isOkToStandOn(blockOneDown.getType()) && this.isOkToStandIn(blockOneUp.getType()) && this.isOkToStandIn(block.getType());
    }

    public boolean isSafeLocation(Location loc) {
        return this.isSafeLocation(loc.getBlock());
    }

    public Location tryFindPlaceToStand(Location targetLoc) {
        return this.tryFindPlaceToStand(targetLoc, 4, 253);
    }

    public Location tryFindPlaceToStand(Location targetLoc, int minY, int maxY) {
        Location location = this.findPlaceToStand(targetLoc, minY, maxY);
        return location == null ? targetLoc : location;
    }

    public Location findPlaceToStand(Location targetLoc, int minY, int maxY) {
        if (!targetLoc.getBlock().getChunk().isLoaded()) {
            return null;
        }
        int targetY = targetLoc.getBlockY();
        if (targetY >= minY && targetY <= maxY && this.isSafeLocation(targetLoc)) {
            return targetLoc;
        }
        Location location = null;
        if (targetY < minY) {
            location = targetLoc.clone();
            location.setY((double)minY);
            location = this.findPlaceToStand(location, true, minY, maxY);
        } else if (targetY > maxY) {
            location = targetLoc.clone();
            location.setY((double)maxY);
            location = this.findPlaceToStand(location, false, minY, maxY);
        } else {
            int y = targetLoc.getBlockY();
            int testMinY = Math.max(minY, y - 4);
            location = this.findPlaceToStand(targetLoc, false, testMinY, maxY);
            if (location == null) {
                location = this.findPlaceToStand(targetLoc, true, minY, maxY);
            }
            if (location == null) {
                location = this.findPlaceToStand(targetLoc, false, minY, maxY);
            }
        }
        return location;
    }

    public Location findPlaceToStand(Location target, boolean goUp) {
        return this.findPlaceToStand(target, goUp, 4, 253);
    }

    public Location findPlaceToStand(Location target, boolean goUp, int minY, int maxY) {
        int direction = goUp ? 1 : -1;
        Location targetLocation = target.clone();
        while ((double)minY <= targetLocation.getY() && targetLocation.getY() <= (double)maxY) {
            Block block = targetLocation.getBlock();
            if (!(!this.isSafeLocation(block) || goUp && this.isUnderwater() && this.isWater(block.getType()))) {
                return targetLocation;
            }
            targetLocation.setY(targetLocation.getY() + (double)direction);
        }
        return null;
    }

    public Block getPlayerBlock() {
        Block playerBlock = null;
        Location playerLoc = this.getLocation();
        if (playerLoc == null) {
            return null;
        }
        int x = (int)Math.round(playerLoc.getX() - 0.5);
        int y = (int)Math.round(playerLoc.getY() - 0.5);
        int z = (int)Math.round(playerLoc.getZ() - 0.5);
        int dy = 0;
        while (dy > -3 && (playerBlock == null || this.isOkToStandIn(playerBlock.getType()))) {
            playerBlock = this.getWorld().getBlockAt(x, y + dy, z);
            --dy;
        }
        return playerBlock;
    }

    public BlockFace getPlayerFacing() {
        float playerRot = this.getPlayerRotation();
        BlockFace direction = BlockFace.NORTH;
        if (playerRot <= 45.0f || playerRot > 315.0f) {
            direction = BlockFace.SOUTH;
        } else if (playerRot > 45.0f && playerRot <= 135.0f) {
            direction = BlockFace.WEST;
        } else if (playerRot > 135.0f && playerRot <= 225.0f) {
            direction = BlockFace.NORTH;
        } else if (playerRot > 225.0f && playerRot <= 315.0f) {
            direction = BlockFace.EAST;
        }
        return direction;
    }

    public static BlockFace goLeft(BlockFace direction) {
        switch (direction) {
            case EAST: {
                return BlockFace.NORTH;
            }
            case NORTH: {
                return BlockFace.WEST;
            }
            case WEST: {
                return BlockFace.SOUTH;
            }
            case SOUTH: {
                return BlockFace.EAST;
            }
        }
        return direction;
    }

    public static BlockFace goRight(BlockFace direction) {
        switch (direction) {
            case EAST: {
                return BlockFace.SOUTH;
            }
            case SOUTH: {
                return BlockFace.WEST;
            }
            case WEST: {
                return BlockFace.NORTH;
            }
            case NORTH: {
                return BlockFace.EAST;
            }
        }
        return direction;
    }

    protected Location getLocation() {
        if (this.location == null && this.mage != null) {
            this.location = this.mage.getLocation();
            if (this.direction != null) {
                this.location = RandomUtils.setDirection(this.location, this.direction);
            }
        }
        if (this.location == null) {
            return null;
        }
        return this.location.clone();
    }

    protected Location getEyeLocation() {
        Location location = this.getLocation();
        if (location == null) {
            return null;
        }
        location.setY(location.getY() + 1.5);
        return location;
    }

    protected Vector getDirection() {
        Location location;
        if (this.direction == null && (location = this.getLocation()) != null) {
            this.direction = location.getDirection();
        }
        if (this.direction == null) {
            return null;
        }
        return this.direction.clone();
    }

    public double getYRotation() {
        return this.yRotation;
    }

    public double getXRotation() {
        return this.xRotation;
    }

    public float getPlayerRotation() {
        float playerRot = this.getLocation().getYaw();
        while (playerRot < 0.0f) {
            playerRot += 360.0f;
        }
        while (playerRot > 360.0f) {
            playerRot -= 360.0f;
        }
        return playerRot;
    }

    public TargetType getTargetType() {
        return this.targetType;
    }

    protected Target getTarget() {
        this.target = this.findTarget();
        if (this.targetLocationOffset != null) {
            this.target.add(this.targetLocationOffset);
        }
        return this.target;
    }

    public Target findTarget() {
        boolean noPvp;
        if (this.targetType != TargetType.NONE && this.targetType != TargetType.BLOCK && this.targetEntity != null) {
            return new Target(this.getLocation(), this.targetEntity);
        }
        Player player = this.getPlayer();
        if (this.targetType == TargetType.SELF && player != null) {
            return new Target(this.getLocation(), (Entity)player);
        }
        CommandSender sender = this.mage.getCommandSender();
        if (this.targetType == TargetType.SELF && player == null && sender != null && sender instanceof BlockCommandSender) {
            BlockCommandSender commandBlock = (BlockCommandSender)this.mage.getCommandSender();
            return new Target(commandBlock.getBlock().getLocation(), commandBlock.getBlock());
        }
        if (this.targetType != TargetType.NONE && this.targetLocation != null) {
            return new Target(this.getLocation(), this.targetLocation.getBlock());
        }
        if (this.targetType == TargetType.NONE) {
            return new Target(this.getLocation());
        }
        this.findTargetBlock();
        Block block = this.getCurBlock();
        if (this.targetType == TargetType.BLOCK) {
            return new Target(this.getLocation(), block);
        }
        Target targetBlock = block == null ? null : new Target(this.getLocation(), block);
        Target targetEntity = this.getTargetEntity();
        boolean bl = noPvp = targetEntity != null && targetEntity instanceof Player && this.pvpRestricted && !this.bypassPvpRestriction && !this.controller.isPVPAllowed(targetEntity.getLocation());
        if (noPvp) {
            targetEntity = null;
            targetBlock = null;
        }
        if (targetEntity == null && this.targetType == TargetType.ANY && player != null) {
            return new Target(this.getLocation(), (Entity)player, targetBlock == null ? null : targetBlock.getBlock());
        }
        if (targetBlock != null && targetEntity != null) {
            if (targetBlock.getDistance() < targetEntity.getDistance()) {
                targetEntity = null;
            } else {
                targetBlock = null;
            }
        }
        if (targetEntity != null) {
            return targetEntity;
        }
        if (targetBlock != null) {
            return targetBlock;
        }
        return new Target(this.getLocation());
    }

    public Target getCurrentTarget() {
        return this.target;
    }

    public Block getTargetBlock() {
        return this.getTarget().getBlock();
    }

    protected Target getTargetEntity() {
        if (this.targetEntityType == null) {
            return null;
        }
        List<Target> scored = this.getAllTargetEntities();
        if (scored.size() <= 0) {
            return null;
        }
        return scored.get(0);
    }

    protected List<Target> getAllTargetEntities() {
        List entities = this.getWorld().getEntities();
        ArrayList<Target> scored = new ArrayList<Target>();
        for (Entity entity : entities) {
            Target newScore;
            if (entity == this.getPlayer() || !this.targetNPCs && entity.hasMetadata("NPC") || this.targetEntityType != null && !this.targetEntityType.isAssignableFrom(entity.getClass()) || (newScore = new Target(this.getLocation(), entity, this.getMaxRange())).getScore() <= 0) continue;
            scored.add(newScore);
        }
        Collections.sort(scored);
        return scored;
    }

    public Block getFaceBlock() {
        this.findTargetBlock();
        if (this.getCurBlock() != null) {
            return this.getLastBlock();
        }
        return null;
    }

    protected void offsetTarget(int dx, int dy, int dz) {
        this.targetX += dx;
        this.targetY += dy;
        this.targetZ += dz;
    }

    public Block getNextBlock() {
        this.lastX = this.targetX;
        this.lastY = this.targetY;
        this.lastZ = this.targetZ;
        int scaledRange = this.getMaxRange();
        do {
            this.length += this.step;
            this.hLength = this.length * Math.cos(Math.toRadians(this.yRotation));
            this.yOffset = this.length * Math.sin(Math.toRadians(this.yRotation));
            this.xOffset = this.hLength * Math.cos(Math.toRadians(this.xRotation));
            this.zOffset = this.hLength * Math.sin(Math.toRadians(this.xRotation));
            this.targetX = (int)Math.floor(this.xOffset + this.location.getX());
            this.targetY = (int)Math.floor(this.yOffset + this.location.getY() + this.viewHeight);
            this.targetZ = (int)Math.floor(this.zOffset + this.location.getZ());
        } while (this.length <= (double)scaledRange && this.targetY >= 1 && this.targetY <= 256 && this.targetX == this.lastX && this.targetY == this.lastY && this.targetZ == this.lastZ);
        if (this.length > (double)scaledRange || this.targetY >= 256 || this.targetY <= 1) {
            return null;
        }
        return this.getBlockAt(this.targetX, this.targetY, this.targetZ);
    }

    public Block getCurBlock() {
        int scaledRange = this.getMaxRange();
        if (this.length > (double)scaledRange && !this.allowMaxRange) {
            return null;
        }
        return this.getBlockAt(this.targetX, this.targetY, this.targetZ);
    }

    public Block getLastBlock() {
        return this.getBlockAt(this.lastX, this.lastY, this.lastZ);
    }

    public Block getBlockAt(int x, int y, int z) {
        World world = this.getWorld();
        if (world == null) {
            return null;
        }
        return world.getBlockAt(x, y, z);
    }

    public void castMessage(String message) {
        if (this.canSendMessage() && message != null && message.length() > 0) {
            this.mage.castMessage(message);
            this.lastMessageSent = System.currentTimeMillis();
        }
    }

    public void sendMessage(String message) {
        if (this.canSendMessage() && message != null && message.length() > 0) {
            this.mage.sendMessage(message);
            this.lastMessageSent = System.currentTimeMillis();
        }
    }

    private boolean canSendMessage() {
        if (this.lastMessageSent == 0L) {
            return true;
        }
        int throttle = this.controller.getMessageThrottle();
        long now = System.currentTimeMillis();
        return this.lastMessageSent < now - (long)throttle;
    }

    public boolean setTime(long time) {
        World world = this.getWorld();
        if (world != null) {
            world.setTime(time);
            return true;
        }
        return false;
    }

    public long getTime() {
        World world = this.getWorld();
        return world == null ? 0L : world.getTime();
    }

    public World getWorld() {
        Location location = this.getLocation();
        if (location != null) {
            return location.getWorld();
        }
        return null;
    }

    public boolean isUnderwater() {
        Block playerBlock = this.getPlayerBlock();
        if (playerBlock == null) {
            return false;
        }
        return (playerBlock = playerBlock.getRelative(BlockFace.UP)).getType() == Material.WATER || playerBlock.getType() == Material.STATIONARY_WATER;
    }

    public void initialize(MagicController instance) {
        this.controller = instance;
        this.targetThroughMaterials.clear();
    }

    public boolean cancel() {
        boolean cancelled = this.onCancel();
        if (cancelled) {
            this.sendMessage(this.getMessage("cancel"));
        }
        return cancelled;
    }

    protected void findTargetBlock() {
        if (this.targetingComplete) {
            return;
        }
        int scaledRange = this.getMaxRange();
        while (this.length <= (double)scaledRange) {
            Block block = this.getNextBlock();
            if (block == null || (!this.targetSpaceRequired ? this.isTargetable(block.getType()) : this.isOkToStandIn(block.getType()) && this.isOkToStandIn(block.getRelative(BlockFace.UP).getType()))) break;
        }
        this.targetingComplete = true;
    }

    public long getCastCount() {
        return this.castCount;
    }

    protected int getMaxRange() {
        if (this.allowMaxRange) {
            return Math.min(maxRange, this.range);
        }
        return Math.min(maxRange, (int)(this.mage.getRangeMultiplier() * (float)this.range));
    }

    protected int getMaxRangeSquared() {
        int maxRange = this.getMaxRange();
        return maxRange * maxRange;
    }

    protected void setMaxRange(int range, boolean allow) {
        this.range = range;
        this.allowMaxRange = allow;
    }

    protected void setMaxRange(int range) {
        this.range = range;
    }

    protected Material getMaterial(String matName, List<Material> materials) {
        Material material = Material.AIR;
        StringBuffer simplify = new StringBuffer("_");
        matName = matName.replace(simplify, new StringBuffer(""));
        for (Material checkMat : materials) {
            String checkName = checkMat.name().replace(simplify, new StringBuffer(""));
            if (!checkName.equalsIgnoreCase(matName)) continue;
            material = checkMat;
            break;
        }
        return material;
    }

    protected boolean giveMaterial(Material materialType, int amount, short damage, byte data) {
        ItemStack itemStack = new ItemStack(materialType, amount, damage, Byte.valueOf(data));
        boolean active = false;
        int i = 8;
        while (i >= 0) {
            ItemStack current = this.getPlayer().getInventory().getItem(i);
            if (current == null || current.getType() == Material.AIR) {
                this.getPlayer().getInventory().setItem(i, itemStack);
                active = true;
                break;
            }
            --i;
        }
        if (!active) {
            this.getPlayer().getInventory().addItem(new ItemStack[]{itemStack});
        }
        return true;
    }

    public List<CastingCost> getCosts() {
        return this.costs;
    }

    public List<CastingCost> getActiveCosts() {
        return this.activeCosts;
    }

    public boolean isInCircle(int x, int z, int R) {
        return x * x + z * z - R * R <= 0;
    }

    /*
     * Unable to fully structure code
     */
    public void coverSurface(Location center, int radius, BlockAction action) {
        y = center.getBlockY();
        dx = -radius;
        while (dx < radius) {
            dz = -radius;
            while (dz < radius) {
                block5: {
                    block6: {
                        if (!this.isInCircle(dx, dz, radius)) break block5;
                        x = center.getBlockX() + dx;
                        z = center.getBlockZ() + dz;
                        block = this.getWorld().getBlockAt(x, y, z);
                        depth = 0;
                        if (!this.targetThroughMaterials.contains(block.getType())) ** GOTO lbl19
                        while (depth < this.verticalSearchDistance && this.targetThroughMaterials.contains(block.getType())) {
                            ++depth;
                            block = block.getRelative(BlockFace.DOWN);
                        }
                        break block6;
lbl-1000:
                        // 1 sources

                        {
                            ++depth;
                            block = block.getRelative(BlockFace.UP);
lbl19:
                            // 2 sources

                            ** while (depth < this.verticalSearchDistance && !this.targetThroughMaterials.contains((Object)block.getType()))
                        }
lbl20:
                        // 1 sources

                        block = block.getRelative(BlockFace.DOWN);
                    }
                    coveringBlock = block.getRelative(BlockFace.UP);
                    if (!this.targetThroughMaterials.contains(block.getType()) && this.targetThroughMaterials.contains(coveringBlock.getType())) {
                        action.perform(block);
                    }
                }
                ++dz;
            }
            ++dx;
        }
    }

    protected boolean isTransparent(Material material) {
        return this.targetThroughMaterials.contains(material);
    }

    public void onActivate() {
    }

    public void onDeactivate() {
    }

    public Mage getMage() {
        return this.mage;
    }

    public void load(ConfigurationNode node) {
        try {
            this.castCount = node.getLong("cast_count", 0L);
            this.lastCast = node.getLong("last_cast", 0L);
            this.onLoad(node);
        }
        catch (Exception ex) {
            this.controller.getPlugin().getLogger().warning("Failed to load data for spell " + this.name + ": " + ex.getMessage());
        }
    }

    public void save(ConfigurationNode node) {
        try {
            node.setProperty("cast_count", this.castCount);
            node.setProperty("last_cast", this.lastCast);
            this.onSave(node);
        }
        catch (Exception ex) {
            this.controller.getPlugin().getLogger().warning("Failed to save data for spell " + this.name + ": " + ex.getMessage());
        }
    }

    public void onLoad(ConfigurationNode node) {
    }

    public void onSave(ConfigurationNode node) {
    }

    protected static Collection<PotionEffect> getPotionEffects(ConfigurationNode parameters) {
        PotionEffectType[] effectTypes;
        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
        PotionEffectType[] potionEffectTypeArray = effectTypes = PotionEffectType.values();
        int n = effectTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String parameterName;
            PotionEffectType effectType = potionEffectTypeArray[n2];
            if (effectType != null && parameters.containsKey(parameterName = "effect_" + effectType.getName().toLowerCase())) {
                String value = parameters.getString(parameterName);
                String[] pieces = value.split(",");
                try {
                    Integer ticks = Integer.parseInt(pieces[0]);
                    Integer power = 1;
                    if (pieces.length > 0) {
                        power = Integer.parseInt(pieces[1]);
                    }
                    PotionEffect effect = new PotionEffect(effectType, ticks.intValue(), power.intValue(), true);
                    effects.add(effect);
                }
                catch (Exception ex) {
                    Bukkit.getLogger().warning("Error parsing potion effect for " + effectType + ": " + value + ": " + parameters.getKeys());
                }
            }
            ++n2;
        }
        return effects;
    }

    protected void applyPotionEffects(Location location, int radius, Collection<PotionEffect> potionEffects) {
        if (potionEffects == null || radius <= 0 || potionEffects.size() == 0) {
            return;
        }
        int radiusSquared = radius * 2;
        List entities = location.getWorld().getEntities();
        for (Entity entity : entities) {
            Mage targetMage;
            Player targetPlayer;
            boolean isSourcePlayer;
            if (!(entity instanceof LivingEntity) || entity instanceof Player && ((isSourcePlayer = (targetPlayer = (Player)entity).getName().equals(this.mage.getName())) && this.getTargetType() != TargetType.ANY && this.getTargetType() != TargetType.SELF || (targetMage = this.controller.getMage(targetPlayer)).isSuperProtected() && !isSourcePlayer) || this.targetEntityType != null && !this.targetEntityType.isAssignableFrom(entity.getClass()) || !(entity.getLocation().distanceSquared(location) < (double)radiusSquared)) continue;
            LivingEntity living = (LivingEntity)entity;
            living.addPotionEffects(potionEffects);
        }
    }

    protected String getBlockSkin(Material blockType) {
        String skinName = null;
        switch (blockType) {
            case CACTUS: {
                skinName = "MHF_Cactus";
                break;
            }
            case CHEST: {
                skinName = "MHF_Chest";
                break;
            }
            case MELON_BLOCK: {
                skinName = "MHF_Melon";
                break;
            }
            case TNT: {
                if (Math.random() > 0.5) {
                    skinName = "MHF_TNT";
                    break;
                }
                skinName = "MHF_TNT2";
                break;
            }
            case LOG: {
                skinName = "MHF_OakLog";
                break;
            }
            case PUMPKIN: {
                skinName = "MHF_Pumpkin";
            }
        }
        return skinName;
    }

    protected String getMobSkin(EntityType mobType) {
        String mobSkin = null;
        switch (mobType) {
            case BLAZE: {
                mobSkin = "MHF_Blaze";
                break;
            }
            case CAVE_SPIDER: {
                mobSkin = "MHF_CaveSpider";
                break;
            }
            case CHICKEN: {
                mobSkin = "MHF_Chicken";
                break;
            }
            case COW: {
                mobSkin = "MHF_Cow";
                break;
            }
            case ENDERMAN: {
                mobSkin = "MHF_Enderman";
                break;
            }
            case GHAST: {
                mobSkin = "MHF_Ghast";
                break;
            }
            case IRON_GOLEM: {
                mobSkin = "MHF_Golem";
                break;
            }
            case MAGMA_CUBE: {
                mobSkin = "MHF_LavaSlime";
                break;
            }
            case MUSHROOM_COW: {
                mobSkin = "MHF_MushroomCow";
                break;
            }
            case OCELOT: {
                mobSkin = "MHF_Ocelot";
                break;
            }
            case PIG: {
                mobSkin = "MHF_Pig";
                break;
            }
            case PIG_ZOMBIE: {
                mobSkin = "MHF_PigZombie";
                break;
            }
            case SHEEP: {
                mobSkin = "MHF_Sheep";
                break;
            }
            case SLIME: {
                mobSkin = "MHF_Slime";
                break;
            }
            case SPIDER: {
                mobSkin = "MHF_Spider";
                break;
            }
            case SQUID: {
                mobSkin = "MHF_Squid";
                break;
            }
            case VILLAGER: {
                mobSkin = "MHF_Villager";
            }
        }
        return mobSkin;
    }

    @Override
    public float getCostReduction() {
        return this.costReduction + this.mage.getCostReduction();
    }

    @Override
    public boolean usesMana() {
        return this.mage.usesMana();
    }
}

