/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic;

import com.elmakers.mine.bukkit.blocks.BlockBatch;
import com.elmakers.mine.bukkit.blocks.BlockData;
import com.elmakers.mine.bukkit.blocks.MaterialBrush;
import com.elmakers.mine.bukkit.plugins.magic.Mage;
import com.elmakers.mine.bukkit.plugins.magic.MagicController;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellGroup;
import com.elmakers.mine.bukkit.plugins.magic.populator.MagicRunnable;
import com.elmakers.mine.bukkit.plugins.magic.populator.WandChestRunnable;
import com.elmakers.mine.bukkit.plugins.magic.populator.WandCleanupRunnable;
import com.elmakers.mine.bukkit.plugins.magic.wand.LostWand;
import com.elmakers.mine.bukkit.plugins.magic.wand.Wand;
import com.elmakers.mine.bukkit.utilities.Messages;
import com.elmakers.mine.bukkit.utilities.URLMap;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;

public class MagicPlugin
extends JavaPlugin {
    private MagicController controller = null;
    private MagicRunnable runningTask = null;

    public MagicController getController() {
        return this.controller;
    }

    public void onEnable() {
        if (this.controller == null) {
            this.controller = new MagicController(this);
        }
        this.initialize();
        BlockData.setServer(this.getServer());
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)this.controller, (Plugin)this);
    }

    protected void initialize() {
        this.controller.initialize();
    }

    protected void checkRunningTask() {
        if (this.runningTask != null && this.runningTask.isFinished()) {
            this.runningTask = null;
        }
    }

    protected void handleWandCommandTab(List<String> options, Mage player, CommandSender sender, Command cmd, String alias, String[] args) {
        String subCommand;
        if (args.length == 0) {
            return;
        }
        if (args.length == 1) {
            this.addIfPermissible(sender, options, "Magic.commands." + cmd + ".", "add");
            this.addIfPermissible(sender, options, "Magic.commands." + cmd + ".", "remove");
            this.addIfPermissible(sender, options, "Magic.commands." + cmd + ".", "name");
            this.addIfPermissible(sender, options, "Magic.commands." + cmd + ".", "fill");
            this.addIfPermissible(sender, options, "Magic.commands." + cmd + ".", "configure");
            this.addIfPermissible(sender, options, "Magic.commands." + cmd + ".", "organize");
            this.addIfPermissible(sender, options, "Magic.commands." + cmd + ".", "combine");
            this.addIfPermissible(sender, options, "Magic.commands." + cmd + ".", "upgrade");
            this.addIfPermissible(sender, options, "Magic.commands." + cmd + ".", "describe");
            Collection<String> allWands = Wand.getWandKeys();
            for (String wandKey : allWands) {
                this.addIfPermissible(sender, options, "Magic.commands." + cmd.getName() + ".wand.", wandKey, true);
            }
            return;
        }
        if (args.length == 2) {
            subCommand = args[0];
            String subCommandPNode = "Magic.commands." + cmd.getName() + "." + subCommand;
            if (!this.controller.hasPermission(sender, subCommandPNode)) {
                return;
            }
            subCommandPNode = String.valueOf(subCommandPNode) + ".";
            if (subCommand.equalsIgnoreCase("add")) {
                List<Spell> spellList = this.controller.getAllSpells();
                for (Spell spell : spellList) {
                    this.addIfPermissible(sender, options, subCommandPNode, spell.getKey(), true);
                }
                this.addIfPermissible(sender, options, subCommandPNode, "material", true);
            }
            if (subCommand.equalsIgnoreCase("configure")) {
                String[] stringArray = Wand.PROPERTY_KEYS;
                int n = Wand.PROPERTY_KEYS.length;
                int spell = 0;
                while (spell < n) {
                    String key = stringArray[spell];
                    options.add(key);
                    ++spell;
                }
            }
            if (subCommand.equalsIgnoreCase("remove")) {
                Wand activeWand;
                Wand wand = activeWand = player == null ? null : player.getActiveWand();
                if (activeWand != null) {
                    Set<String> spellNames = activeWand.getSpells();
                    for (String string : spellNames) {
                        options.add(string);
                    }
                    options.add("material");
                }
            }
            if (subCommand.equalsIgnoreCase("combine")) {
                Collection<String> allWands = Wand.getWandKeys();
                for (String wandKey : allWands) {
                    this.addIfPermissible(sender, options, "Magic.commands." + cmd.getName() + ".combine.", wandKey, true);
                }
            }
        }
        if (args.length == 3) {
            subCommand = args[0];
            String subCommand2 = args[1];
            String subCommandPNode = "Magic.commands." + cmd.getName() + "." + subCommand + "." + subCommand2;
            if (!this.controller.hasPermission(sender, subCommandPNode, true)) {
                return;
            }
            if (subCommand.equalsIgnoreCase("remove") && subCommand2.equalsIgnoreCase("material")) {
                Wand activeWand;
                Wand wand = activeWand = player == null ? null : player.getActiveWand();
                if (activeWand != null) {
                    Set<String> set = activeWand.getMaterialKeys();
                    for (String materialName : set) {
                        options.add(materialName);
                    }
                }
            }
            if (subCommand.equalsIgnoreCase("add") && subCommand2.equalsIgnoreCase("material")) {
                Material[] materials;
                Material[] materialArray = materials = Material.values();
                int n = materials.length;
                int n2 = 0;
                while (n2 < n) {
                    Material material = materialArray[n2];
                    if (material.getId() < 256) {
                        options.add(material.name().toLowerCase());
                    }
                    ++n2;
                }
            }
        }
    }

    protected void handleCastCommandTab(List<String> options, CommandSender sender, Command cmd, String alias, String[] args) {
        if (args.length == 1) {
            List<Spell> spellList = this.controller.getAllSpells();
            for (Spell spell : spellList) {
                this.addIfPermissible(sender, options, "Magic." + cmd.getName() + ".", spell.getKey(), true);
            }
            return;
        }
    }

    protected void addIfPermissible(CommandSender sender, List<String> options, String permissionPrefix, String option, boolean defaultValue) {
        if (this.controller.hasPermission(sender, String.valueOf(permissionPrefix) + option, defaultValue)) {
            options.add(option);
        }
    }

    protected void addIfPermissible(CommandSender sender, List<String> options, String permissionPrefix, String option) {
        this.addIfPermissible(sender, options, permissionPrefix, option, false);
    }

    @EventHandler
    public List<String> onTabComplete(CommandSender sender, Command cmd, String alias, String[] args) {
        String[] args2;
        Mage mage = null;
        if (sender instanceof Player) {
            mage = this.controller.getMage((Player)sender);
        }
        String completeCommand = args.length > 0 ? args[args.length - 1] : "";
        ArrayList<String> options = new ArrayList<String>();
        if (cmd.getName().equalsIgnoreCase("magic")) {
            if (args.length == 1) {
                this.addIfPermissible(sender, options, "Magic.commands.", "populate");
                this.addIfPermissible(sender, options, "Magic.commands.", "generate");
                this.addIfPermissible(sender, options, "Magic.commands.", "search");
                this.addIfPermissible(sender, options, "Magic.commands.", "clean");
                this.addIfPermissible(sender, options, "Magic.commands.", "clearcache");
                this.addIfPermissible(sender, options, "Magic.commands.", "cancel");
                this.addIfPermissible(sender, options, "Magic.commands.", "load");
                this.addIfPermissible(sender, options, "Magic.commands.", "save");
                this.addIfPermissible(sender, options, "Magic.commands.", "commit");
                this.addIfPermissible(sender, options, "Magic.commands.", "give");
                this.addIfPermissible(sender, options, "Magic.commands.", "list");
            } else if (args.length == 2 && args[1].equalsIgnoreCase("list")) {
                this.addIfPermissible(sender, options, "Magic.commands.list", "maps");
                this.addIfPermissible(sender, options, "Magic.commands.list", "wands");
            }
        } else if (cmd.getName().equalsIgnoreCase("wand")) {
            this.handleWandCommandTab(options, mage, sender, cmd, alias, args);
        } else if (cmd.getName().equalsIgnoreCase("wandp")) {
            if (args.length == 1) {
                options.addAll(MagicController.getPlayerNames());
            } else if (args.length > 1) {
                args2 = Arrays.copyOfRange(args, 1, args.length);
                this.handleWandCommandTab(options, mage, sender, cmd, alias, args2);
            }
        } else if (cmd.getName().equalsIgnoreCase("cast")) {
            this.handleCastCommandTab(options, sender, cmd, alias, args);
        } else if (cmd.getName().equalsIgnoreCase("castp")) {
            if (args.length == 1) {
                options.addAll(MagicController.getPlayerNames());
            } else if (args.length > 1) {
                args2 = Arrays.copyOfRange(args, 1, args.length);
                this.handleCastCommandTab(options, sender, cmd, alias, args2);
            }
        }
        if (completeCommand.length() > 0) {
            completeCommand = completeCommand.toLowerCase();
            ArrayList<String> allOptions = options;
            options = new ArrayList();
            for (String option : allOptions) {
                String lowercase = option.toLowerCase();
                if (!lowercase.startsWith(completeCommand)) continue;
                options.add(option);
            }
        }
        Collections.sort(options);
        return options;
    }

    protected void onGiveSpell(CommandSender sender, Player player, String spellKey) {
        ItemStack itemStack = Wand.createSpellItem(spellKey, this.controller, null, true);
        if (itemStack == null) {
            sender.sendMessage("Failed to create spell item for " + spellKey);
            return;
        }
        this.giveItemToPlayer(player, itemStack);
    }

    protected void onGiveBrush(CommandSender sender, Player player, String materialKey) {
        ItemStack itemStack = Wand.createMaterialItem(materialKey, this.controller, null, true);
        if (itemStack == null) {
            sender.sendMessage("Failed to material spell item for " + materialKey);
            return;
        }
        this.giveItemToPlayer(player, itemStack);
    }

    protected boolean onMagicGive(CommandSender sender, Player player, String[] args) {
        String playerCommand = sender instanceof Player ? "" : "<player> ";
        String usageString = "Usage: /magic give " + playerCommand + "<spellname|'material'|'upgrade'|'wand'> [materialname|wandname]";
        if (args.length == 0) {
            sender.sendMessage(usageString);
            return true;
        }
        String key = "";
        boolean isMaterial = false;
        boolean isWand = false;
        boolean isUpgrade = false;
        if (!(args.length <= 1 || args[0].equals("material") || args[0].equals("wand") || args[0].equals("upgrade"))) {
            sender.sendMessage(usageString);
            return true;
        }
        if (args[0].equals("wand")) {
            isWand = true;
            key = args.length > 1 ? args[1] : "";
        } else if (args[0].equals("upgrade")) {
            isUpgrade = true;
            key = args.length > 1 ? args[1] : "";
        } else if (args[0].equals("material")) {
            if (args.length < 2) {
                sender.sendMessage(usageString);
                return true;
            }
            isMaterial = true;
            key = args[1];
        } else {
            key = args[0];
        }
        if (isWand) {
            this.onGiveWand(sender, player, key);
        } else if (isMaterial) {
            this.onGiveBrush(sender, player, key);
        } else if (isUpgrade) {
            this.onGiveUpgrade(sender, player, key);
        } else {
            this.onGiveSpell(sender, player, key);
        }
        return true;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        Player player;
        if (commandLabel.equalsIgnoreCase("magic") && args.length > 0) {
            String subCommand = args[0];
            if (sender instanceof Player && !this.controller.hasPermission((Player)sender, "Magic.commands.magic." + subCommand)) {
                return false;
            }
            if (subCommand.equalsIgnoreCase("save")) {
                this.controller.save();
                URLMap.save();
                sender.sendMessage("Data saved.");
                return true;
            }
            if (subCommand.equalsIgnoreCase("load")) {
                this.controller.loadConfiguration();
                URLMap.loadConfiguration();
                sender.sendMessage("Configuration reloaded.");
                return true;
            }
            if (subCommand.equalsIgnoreCase("clearcache")) {
                this.controller.clearCache();
                URLMap.clearCache();
                sender.sendMessage("Image map and schematic caches cleared.");
                return true;
            }
            if (subCommand.equalsIgnoreCase("commit")) {
                if (this.controller.commitAll()) {
                    sender.sendMessage("All changes committed");
                } else {
                    sender.sendMessage("Nothing to commit");
                }
                return true;
            }
            if (subCommand.equalsIgnoreCase("give")) {
                Player player2 = null;
                int argStart = 1;
                if (sender instanceof Player) {
                    player2 = (Player)sender;
                } else {
                    argStart = 2;
                    player2 = Bukkit.getPlayer((String)args[0]);
                    if (player2 == null) {
                        sender.sendMessage("Can't find player " + args[0]);
                        return true;
                    }
                    if (!player2.isOnline()) {
                        sender.sendMessage("Player " + args[0] + " is not online");
                        return true;
                    }
                }
                String[] args2 = Arrays.copyOfRange(args, argStart, args.length);
                return this.onMagicGive(sender, player2, args2);
            }
            if (subCommand.equalsIgnoreCase("list")) {
                String usage = "Usage: magic list <wands [player]|maps [keyword]>";
                String listCommand = "";
                if (args.length > 1) {
                    listCommand = args[1];
                    if (!this.controller.hasPermission(sender, "Magic.commands.magic." + subCommand + "." + listCommand)) {
                        return false;
                    }
                } else {
                    if (!this.controller.hasPermission(sender, "Magic.commands.magic." + listCommand)) {
                        return false;
                    }
                    sender.sendMessage(ChatColor.GRAY + "For more specific information, add 'wands' or 'maps' parameter.");
                    Collection<Mage> mages = this.controller.getMages();
                    List tasks = Bukkit.getScheduler().getPendingTasks();
                    int magicTasks = 0;
                    for (BukkitTask task : tasks) {
                        if (task.getOwner() != this) continue;
                        ++magicTasks;
                    }
                    sender.sendMessage(ChatColor.LIGHT_PURPLE + "Active tasks: " + magicTasks + "/" + tasks.size());
                    sender.sendMessage(ChatColor.LIGHT_PURPLE + "Active players: " + mages.size());
                    sender.sendMessage(ChatColor.AQUA + "Pending construction batches (" + this.controller.getPending().size() + "): ");
                    for (Mage mage : mages) {
                        List<BlockBatch> pending = mage.getPendingBatches();
                        if (pending.size() <= 0) continue;
                        int totalSize = 0;
                        int totalRemaining = 0;
                        for (BlockBatch batch : pending) {
                            totalSize += batch.size();
                            totalRemaining = batch.remaining();
                        }
                        sender.sendMessage(ChatColor.AQUA + mage.getName() + " " + ChatColor.GRAY + " has " + ChatColor.WHITE + pending.size() + ChatColor.GRAY + " pending (" + ChatColor.WHITE + totalRemaining + "/" + totalSize + ChatColor.GRAY + ")");
                    }
                    return true;
                }
                if (listCommand.equalsIgnoreCase("wands")) {
                    String owner = "";
                    if (args.length > 2) {
                        owner = args[2];
                    }
                    Collection<LostWand> lostWands = this.controller.getLostWands();
                    int shown = 0;
                    for (LostWand lostWand : lostWands) {
                        Location location = lostWand.getLocation();
                        if (owner.length() > 0 && !owner.equalsIgnoreCase(lostWand.getOwner())) continue;
                        ++shown;
                        sender.sendMessage(ChatColor.AQUA + lostWand.getName() + ChatColor.WHITE + " (" + lostWand.getOwner() + ") @ " + ChatColor.BLUE + location.getWorld().getName() + " " + location.getBlockX() + " " + location.getBlockY() + " " + location.getBlockZ());
                    }
                    sender.sendMessage(String.valueOf(shown) + " lost wands found" + (owner.length() > 0 ? " for " + owner : ""));
                    return true;
                }
                if (listCommand.equalsIgnoreCase("maps")) {
                    String keyword = "";
                    if (args.length > 2) {
                        keyword = args[2];
                    }
                    int shown = 0;
                    Set<Map.Entry<Short, URLMap>> allMaps = URLMap.getAll();
                    for (Map.Entry<Short, URLMap> mapRecord : allMaps) {
                        Short mapId = mapRecord.getKey();
                        URLMap map = mapRecord.getValue();
                        if (map == null || mapId == null || !map.matches(keyword)) continue;
                        ++shown;
                        String name = map.getName();
                        name = name == null ? "(None)" : name;
                        sender.sendMessage(ChatColor.AQUA + mapId + ChatColor.WHITE + ": " + name + " => " + ChatColor.GRAY + map.getURL());
                    }
                    if (shown == 0) {
                        sender.sendMessage("No maps found" + (keyword.length() > 0 ? " matching " + keyword : "") + ", use /castp <player> camera [url|player] [...]");
                    } else {
                        sender.sendMessage(String.valueOf(shown) + " maps found matching " + keyword);
                    }
                    return true;
                }
                sender.sendMessage(usage);
                return true;
            }
            if (subCommand.equalsIgnoreCase("populate") || subCommand.equalsIgnoreCase("search") || subCommand.equalsIgnoreCase("generate")) {
                this.checkRunningTask();
                if (this.runningTask != null) {
                    sender.sendMessage("Cancel current job first");
                    return true;
                }
                World world = null;
                int ymax = 50;
                if (sender instanceof Player) {
                    world = ((Player)sender).getWorld();
                    if (args.length > 1) {
                        ymax = Integer.parseInt(args[1]);
                    }
                } else {
                    if (args.length > 1) {
                        String worldName = args[1];
                        world = Bukkit.getWorld((String)worldName);
                    }
                    if (args.length > 2) {
                        ymax = Integer.parseInt(args[2]);
                    }
                }
                if (world == null) {
                    sender.sendMessage("Usage: magic " + subCommand + " <world> <ymax>");
                    return true;
                }
                WandChestRunnable chestRunnable = new WandChestRunnable(this.controller, world, ymax);
                this.runningTask = chestRunnable;
                if (subCommand.equalsIgnoreCase("search")) {
                    ymax = 0;
                    sender.sendMessage("Searching for wands in " + world.getName());
                } else if (subCommand.equalsIgnoreCase("generate")) {
                    sender.sendMessage("Generating chunks, and adding wands in " + world.getName() + " below y=" + ymax);
                    chestRunnable.setGenerate(true);
                } else {
                    sender.sendMessage("Populating chests with wands in " + world.getName() + " below y=" + ymax);
                }
                this.runningTask.runTaskTimer((Plugin)this, 5L, 5L);
                return true;
            }
            if (subCommand.equalsIgnoreCase("cancel")) {
                this.checkRunningTask();
                if (this.runningTask != null) {
                    this.runningTask.cancel();
                    this.runningTask = null;
                    sender.sendMessage("Job cancelled");
                } else {
                    sender.sendMessage("There is no job running");
                }
                return true;
            }
            if (subCommand.equalsIgnoreCase("clean")) {
                String ownerName;
                this.checkRunningTask();
                if (this.runningTask != null) {
                    sender.sendMessage("Cancel current job first");
                    return true;
                }
                World world = null;
                String owner = null;
                if (args.length > 1) {
                    owner = args[1];
                }
                if (sender instanceof Player) {
                    world = ((Player)sender).getWorld();
                } else if (args.length > 2) {
                    String worldName = args[2];
                    world = Bukkit.getWorld((String)worldName);
                }
                String string = ownerName = owner == null ? "(Unowned)" : owner;
                if (world == null) {
                    sender.sendMessage("Cleaning up lost wands in all worlds for owner: " + ownerName);
                } else {
                    sender.sendMessage("Cleaning up lost wands in world " + world.getName() + " for owner " + ownerName);
                }
                this.runningTask = new WandCleanupRunnable(this.controller, world, owner);
                this.runningTask.runTaskTimer((Plugin)this, 5L, 5L);
                return true;
            }
        }
        if (commandLabel.equalsIgnoreCase("wandp")) {
            if (args.length == 0) {
                sender.sendMessage("Usage: /wandp [player] [wand name/command]");
                return true;
            }
            player = Bukkit.getPlayer((String)args[0]);
            if (player == null) {
                sender.sendMessage("Can't find player " + args[0]);
                return true;
            }
            if (!player.isOnline()) {
                sender.sendMessage("Player " + args[0] + " is not online");
                return true;
            }
            String[] args2 = Arrays.copyOfRange(args, 1, args.length);
            return this.processWandCommand("wandp", sender, player, args2);
        }
        if (commandLabel.equalsIgnoreCase("castp")) {
            if (args.length == 0) {
                sender.sendMessage("Usage: /castp [player] [spell] <parameters>");
                return true;
            }
            player = Bukkit.getPlayer((String)args[0]);
            if (player == null) {
                sender.sendMessage("Can't find player " + args[0]);
                return true;
            }
            if (!player.isOnline()) {
                sender.sendMessage("Player " + args[0] + " is not online");
                return true;
            }
            String[] args2 = Arrays.copyOfRange(args, 1, args.length);
            return this.processCastCommand(sender, player, args2);
        }
        if (commandLabel.equalsIgnoreCase("cast")) {
            player = null;
            if (sender instanceof Player) {
                player = (Player)sender;
            }
            if (!this.controller.hasPermission(player, "Magic.commands.cast")) {
                return false;
            }
            return this.processCastCommand(sender, player, args);
        }
        if (!(sender instanceof Player)) {
            if (commandLabel.equalsIgnoreCase("spells")) {
                this.listSpells(sender, -1, args.length > 0 ? args[0] : null);
                return true;
            }
            if (commandLabel.equalsIgnoreCase("wand") && args.length > 0 && args[0].equalsIgnoreCase("list")) {
                this.onWandList(sender);
                return true;
            }
            return false;
        }
        player = (Player)sender;
        if (commandLabel.equalsIgnoreCase("wand")) {
            return this.processWandCommand("wand", sender, player, args);
        }
        if (commandLabel.equalsIgnoreCase("spells")) {
            if (!this.controller.hasPermission(player, "Magic.commands.spells")) {
                return false;
            }
            return this.onSpells(player, args);
        }
        return false;
    }

    protected boolean processWandCommand(String command, CommandSender sender, Player player, String[] args) {
        String subCommand = "";
        String[] args2 = args;
        if (args.length > 0) {
            subCommand = args[0];
            args2 = new String[args.length - 1];
            int i = 1;
            while (i < args.length) {
                args2[i - 1] = args[i];
                ++i;
            }
        }
        if (subCommand.equalsIgnoreCase("list")) {
            if (!this.controller.hasPermission(sender, "Magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandList(sender);
            return true;
        }
        if (subCommand.equalsIgnoreCase("add")) {
            if (!this.controller.hasPermission(sender, "Magic.commands." + command + "." + subCommand)) {
                return true;
            }
            if (args2.length > 0 && args2[0].equals("material") && !this.controller.hasPermission(sender, "Magic.commands.wand.add." + args2[0], true)) {
                return true;
            }
            if (args2.length > 0 && !this.controller.hasPermission(sender, "Magic.commands.wand.add.spell." + args2[0], true)) {
                return true;
            }
            this.onWandAdd(sender, player, args2);
            return true;
        }
        if (subCommand.equalsIgnoreCase("configure")) {
            if (!this.controller.hasPermission(sender, "Magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandConfigure(sender, player, args2, false);
            return true;
        }
        if (subCommand.equalsIgnoreCase("enchant")) {
            if (!this.controller.hasPermission(sender, "Magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandEnchant(sender, player);
            return true;
        }
        if (subCommand.equalsIgnoreCase("unenchant")) {
            if (!this.controller.hasPermission(sender, "Magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandUnenchant(sender, player);
            return true;
        }
        if (subCommand.equalsIgnoreCase("organize")) {
            if (!this.controller.hasPermission(sender, "Magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandOrganize(sender, player);
            return true;
        }
        if (subCommand.equalsIgnoreCase("combine")) {
            if (!this.controller.hasPermission(sender, "Magic.commands." + command + "." + subCommand)) {
                return true;
            }
            if (args.length > 0 && !this.controller.hasPermission(sender, "Magic.commands." + command + ".combine." + args[0], true)) {
                return true;
            }
            this.onWandCombine(sender, player, args2);
            return true;
        }
        if (subCommand.equalsIgnoreCase("describe")) {
            if (!this.controller.hasPermission(sender, "Magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandDescribe(sender, player);
            return true;
        }
        if (subCommand.equalsIgnoreCase("upgrade")) {
            if (!this.controller.hasPermission(sender, "Magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandConfigure(sender, player, args2, true);
            return true;
        }
        if (subCommand.equalsIgnoreCase("organize")) {
            if (!this.controller.hasPermission(sender, "Magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandOrganize(sender, player);
            return true;
        }
        if (subCommand.equalsIgnoreCase("fill")) {
            if (!this.controller.hasPermission(sender, "Magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandFill(sender, player);
            return true;
        }
        if (subCommand.equalsIgnoreCase("remove")) {
            if (!this.controller.hasPermission(sender, "Magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandRemove(sender, player, args2);
            return true;
        }
        if (subCommand.equalsIgnoreCase("name")) {
            if (!this.controller.hasPermission(sender, "Magic.commands." + command + "." + subCommand)) {
                return true;
            }
            this.onWandName(sender, player, args2);
            return true;
        }
        if (subCommand.length() == 0) {
            if (!this.controller.hasPermission(sender, "Magic.commands." + command)) {
                return true;
            }
            if (!this.controller.hasPermission(sender, "Magic.commands." + command + ".wand.default", true)) {
                return true;
            }
        } else if (!this.controller.hasPermission(sender, "Magic.commands." + command + ".wand." + subCommand, true)) {
            return true;
        }
        return this.onWand(sender, player, args);
    }

    public boolean onWandList(CommandSender sender) {
        Collection<ConfigurationNode> templates = Wand.getWandTemplates();
        TreeMap<String, ConfigurationNode> nameMap = new TreeMap<String, ConfigurationNode>();
        for (ConfigurationNode templateConfig : templates) {
            nameMap.put(templateConfig.getString("key"), templateConfig);
        }
        for (ConfigurationNode templateConfig : nameMap.values()) {
            if (templateConfig.getBoolean("hidden", false)) continue;
            String key = templateConfig.getString("key");
            String name = Messages.get("wands." + key + ".name", Messages.get("wand.default_name"));
            String description = Messages.get("wands." + key + ".description", "");
            description = ChatColor.YELLOW + description;
            if (!name.equals(key)) {
                description = ChatColor.BLUE + name + ChatColor.WHITE + " : " + description;
            }
            sender.sendMessage(ChatColor.AQUA + key + ChatColor.WHITE + " : " + description);
        }
        return true;
    }

    public boolean onWandDescribe(CommandSender sender, Player player) {
        if (!this.checkWand(sender, player, true, true)) {
            return true;
        }
        Mage mage = this.controller.getMage(player);
        Wand wand = mage.getActiveWand();
        wand.describe(sender);
        return true;
    }

    public boolean onWandOrganize(CommandSender sender, Player player) {
        if (!this.checkWand(sender, player, true)) {
            return true;
        }
        Mage mage = this.controller.getMage(player);
        Wand wand = mage.getActiveWand();
        wand.deactivate();
        wand.organizeInventory(mage);
        wand.activate(mage);
        mage.sendMessage(Messages.get("wand.reorganized"));
        if (sender != player) {
            sender.sendMessage(Messages.getParameterized("wand.player_reorganized", "$name", player.getName()));
        }
        return true;
    }

    public boolean onWandEnchant(CommandSender sender, Player player) {
        Mage mage = this.controller.getMage(player);
        ItemStack heldItem = player.getItemInHand();
        if (heldItem == null || heldItem.getType() == Material.AIR) {
            mage.sendMessage(Messages.get("wand.no_item"));
            if (sender != player) {
                sender.sendMessage(Messages.getParameterized("wand.player_no_item", "$name", player.getName()));
            }
            return false;
        }
        Wand wand = new Wand(this.controller, heldItem.getType(), heldItem.getDurability());
        player.setItemInHand(wand.getItem());
        wand.activate(mage);
        mage.sendMessage(Messages.getParameterized("wand.enchanted", "$item", MaterialBrush.getMaterialName(heldItem.getType(), (byte)heldItem.getDurability())));
        if (sender != player) {
            sender.sendMessage(Messages.getParameterized("wand.player_enchanted", "$item", MaterialBrush.getMaterialName(heldItem.getType(), (byte)heldItem.getDurability()), "$name", player.getName()));
        }
        return true;
    }

    public boolean onWandUnenchant(CommandSender sender, Player player) {
        if (!this.checkWand(sender, player)) {
            return true;
        }
        Mage mage = this.controller.getMage(player);
        Wand wand = mage.getActiveWand();
        if (wand == null || !Wand.isWand(player.getItemInHand())) {
            mage.sendMessage(Messages.get("wand.no_wand"));
            if (sender != player) {
                sender.sendMessage(Messages.getParameterized("wand.player_no_wand", "$name", player.getName()));
            }
            return false;
        }
        wand.unenchant();
        player.setItemInHand(wand.getItem());
        mage.setActiveWand(null);
        mage.sendMessage(Messages.get("wand.unenchanted"));
        if (sender != player) {
            sender.sendMessage(Messages.getParameterized("wand.player_unenchanted", "$name", player.getName()));
        }
        return true;
    }

    public boolean onWandConfigure(CommandSender sender, Player player, String[] parameters, boolean safe) {
        if (parameters.length < 1) {
            sender.sendMessage("Use: /wand configure <property> <value>");
            sender.sendMessage("Properties: " + StringUtils.join((Object[])Wand.PROPERTY_KEYS, (String)", "));
            return false;
        }
        if (!this.checkWand(sender, player)) {
            return true;
        }
        Mage mage = this.controller.getMage(player);
        Wand wand = mage.getActiveWand();
        ConfigurationNode node = new ConfigurationNode();
        String value = "";
        int i = 1;
        while (i < parameters.length) {
            if (i != 1) {
                value = String.valueOf(value) + " ";
            }
            value = String.valueOf(value) + parameters[i];
            ++i;
        }
        node.setProperty(parameters[0], value);
        wand.deactivate();
        wand.loadProperties(node, safe);
        wand.activate(mage);
        mage.sendMessage(Messages.get("wand.reconfigured"));
        if (sender != player) {
            sender.sendMessage(Messages.getParameterized("wand.player_reconfigured", "$name", player.getName()));
        }
        return true;
    }

    protected boolean checkWand(CommandSender sender, Player player) {
        return this.checkWand(sender, player, false, false);
    }

    protected boolean checkWand(CommandSender sender, Player player, boolean skipModifiable) {
        return this.checkWand(sender, player, skipModifiable, false);
    }

    protected boolean checkWand(CommandSender sender, Player player, boolean skipModifiable, boolean skipBound) {
        Mage mage = this.controller.getMage(player);
        Wand wand = mage.getActiveWand();
        if (wand == null) {
            mage.sendMessage(Messages.get("wand.no_wand"));
            if (sender != player) {
                sender.sendMessage(Messages.getParameterized("wand.player_no_wand", "$name", player.getName()));
            }
            return false;
        }
        if (!skipModifiable && !wand.isModifiable()) {
            mage.sendMessage(Messages.get("wand.unmodifiable"));
            if (sender != player) {
                sender.sendMessage(Messages.getParameterized("wand.player_unmodifiable", "$name", player.getName()));
            }
            return false;
        }
        if (!skipBound && !wand.canUse(mage.getPlayer())) {
            mage.sendMessage(Messages.get("wand.bound_to_other"));
            if (sender != player) {
                sender.sendMessage(Messages.getParameterized("wand.player_unmodifiable", "$name", player.getName()));
            }
            return false;
        }
        return true;
    }

    public boolean onWandCombine(CommandSender sender, Player player, String[] parameters) {
        if (parameters.length < 1) {
            sender.sendMessage("Use: /wand combine <wandname>");
            return false;
        }
        if (!this.checkWand(sender, player)) {
            return true;
        }
        Mage mage = this.controller.getMage(player);
        Wand wand = mage.getActiveWand();
        String wandName = parameters[0];
        Wand newWand = Wand.createWand(this.controller, wandName);
        if (newWand == null) {
            sender.sendMessage(Messages.getParameterized("wand.unknown_template", "$name", wandName));
            return false;
        }
        wand.deactivate();
        wand.add(newWand);
        wand.activate(mage);
        mage.sendMessage(Messages.get("wand.upgraded"));
        if (sender != player) {
            sender.sendMessage(Messages.getParameterized("wand.player_upgraded", "$name", player.getName()));
        }
        return true;
    }

    public boolean onWandFill(CommandSender sender, Player player) {
        if (!this.checkWand(sender, player)) {
            return true;
        }
        Mage mage = this.controller.getMage(player);
        Wand wand = mage.getActiveWand();
        wand.fill(player);
        mage.sendMessage(Messages.get("wand.filled"));
        if (sender != player) {
            sender.sendMessage(Messages.getParameterized("wand.player_filled", "$name", player.getName()));
        }
        return true;
    }

    public boolean onWandAdd(CommandSender sender, Player player, String[] parameters) {
        if (parameters.length < 1) {
            sender.sendMessage("Use: /wand add <spell|material> [material:data]");
            return true;
        }
        if (!this.checkWand(sender, player)) {
            return true;
        }
        Mage mage = this.controller.getMage(player);
        Wand wand = mage.getActiveWand();
        String spellName = parameters[0];
        if (spellName.equals("material")) {
            if (parameters.length < 2) {
                sender.sendMessage("Use: /wand add material <material:data>");
                return true;
            }
            String materialKey = parameters[1];
            if (!MaterialBrush.isValidMaterial(materialKey, false)) {
                sender.sendMessage(String.valueOf(materialKey) + " is not a valid material");
                return true;
            }
            if (wand.addMaterial(materialKey, true, false)) {
                mage.sendMessage("Material '" + materialKey + "' has been added to your wand");
                if (sender != player) {
                    sender.sendMessage("Added material '" + materialKey + "' to " + player.getName() + "'s wand");
                }
            } else {
                mage.sendMessage("Material activated: " + materialKey);
                if (sender != player) {
                    sender.sendMessage(String.valueOf(player.getName()) + "'s wand already has material " + materialKey);
                }
            }
            return true;
        }
        Spell spell = mage.getSpell(spellName);
        if (spell == null) {
            sender.sendMessage("Spell '" + spellName + "' unknown, Use /spells for spell list");
            return true;
        }
        if (wand.addSpell(spellName, true)) {
            mage.sendMessage("Spell '" + spell.getName() + "' has been added to your wand");
            if (sender != player) {
                sender.sendMessage("Added '" + spell.getName() + "' to " + player.getName() + "'s wand");
            }
        } else {
            mage.sendMessage(String.valueOf(spell.getName()) + " activated");
            if (sender != player) {
                sender.sendMessage(String.valueOf(player.getName()) + "'s wand already has " + spell.getName());
            }
        }
        return true;
    }

    public boolean onWandRemove(CommandSender sender, Player player, String[] parameters) {
        if (parameters.length < 1) {
            sender.sendMessage("Use: /wand remove <spell|material> [material:data]");
            return true;
        }
        if (!this.checkWand(sender, player)) {
            return true;
        }
        Mage mage = this.controller.getMage(player);
        Wand wand = mage.getActiveWand();
        String spellName = parameters[0];
        if (spellName.equals("material")) {
            if (parameters.length < 2) {
                sender.sendMessage("Use: /wand remove material <material:data>");
                return true;
            }
            String materialKey = parameters[1];
            if (wand.removeMaterial(materialKey)) {
                mage.sendMessage("Material '" + materialKey + "' has been removed from your wand");
                if (sender != player) {
                    sender.sendMessage("Removed material '" + materialKey + "' from " + player.getName() + "'s wand");
                }
            } else if (sender != player) {
                sender.sendMessage(String.valueOf(player.getName()) + "'s wand does not have material " + materialKey);
            }
            return true;
        }
        if (wand.removeSpell(spellName)) {
            mage.sendMessage("Spell '" + spellName + "' has been removed from your wand");
            if (sender != player) {
                sender.sendMessage("Removed '" + spellName + "' from " + player.getName() + "'s wand");
            }
        } else if (sender != player) {
            sender.sendMessage(String.valueOf(player.getName()) + "'s wand does not have " + spellName);
        }
        return true;
    }

    public boolean onWandName(CommandSender sender, Player player, String[] parameters) {
        if (parameters.length < 1) {
            sender.sendMessage("Use: /wand name <name>");
            return true;
        }
        if (!this.checkWand(sender, player)) {
            return true;
        }
        Mage mage = this.controller.getMage(player);
        Wand wand = mage.getActiveWand();
        wand.setName(StringUtils.join((Object[])parameters, (String)" "));
        mage.sendMessage(Messages.get("wand.renamed"));
        if (sender != player) {
            sender.sendMessage(Messages.getParameterized("wand.player_renamed", "$name", player.getName()));
        }
        return true;
    }

    public boolean onGiveWand(CommandSender sender, Player player, String wandKey) {
        Wand wand;
        Mage mage = this.controller.getMage(player);
        Wand currentWand = mage.getActiveWand();
        if (currentWand != null) {
            currentWand.closeInventory();
        }
        if (this.giveItemToPlayer(player, (wand = Wand.createWand(this.controller, wandKey)).getItem())) {
            wand.activate(mage);
        }
        if (sender != player) {
            sender.sendMessage("Gave wand " + wand.getName() + " to " + player.getName());
        }
        return true;
    }

    public boolean onWand(CommandSender sender, Player player, String[] parameters) {
        String wandName = null;
        if (parameters.length > 0) {
            wandName = parameters[0];
        }
        return this.onGiveWand(sender, player, wandName);
    }

    protected boolean onGiveUpgrade(CommandSender sender, Player player, String wandKey) {
        Mage mage = this.controller.getMage(player);
        Wand currentWand = mage.getActiveWand();
        if (currentWand != null) {
            currentWand.closeInventory();
        }
        Wand wand = new Wand(this.controller, wandKey);
        wand.makeUpgrade();
        if (this.giveItemToPlayer(player, wand.getItem())) {
            wand.activate(mage);
        }
        if (sender != player) {
            sender.sendMessage("Gave upgrade " + wand.getName() + " to " + player.getName());
        }
        return true;
    }

    protected boolean giveItemToPlayer(Player player, ItemStack itemStack) {
        PlayerInventory inventory = player.getInventory();
        ItemStack inHand = inventory.getItemInHand();
        if (inHand == null || inHand.getType() == Material.AIR) {
            inventory.setItem(inventory.getHeldItemSlot(), itemStack);
            return true;
        }
        HashMap returned = player.getInventory().addItem(new ItemStack[]{itemStack});
        if (returned.size() > 0) {
            player.getWorld().dropItem(player.getLocation(), itemStack);
        }
        return false;
    }

    public boolean processCastCommand(CommandSender sender, Player player, String[] castParameters) {
        Mage mage;
        Spell spell;
        if (castParameters.length < 1) {
            return false;
        }
        String spellName = castParameters[0];
        String[] parameters = new String[castParameters.length - 1];
        int i = 1;
        while (i < castParameters.length) {
            parameters[i - 1] = castParameters[i];
            ++i;
        }
        Player usePermissions = sender == player ? player : (sender instanceof Player ? (Player)sender : null);
        CommandSender mageController = player == null ? sender : player;
        Location targetLocation = null;
        if (sender instanceof BlockCommandSender) {
            targetLocation = ((BlockCommandSender)sender).getBlock().getLocation();
        }
        if (sender instanceof Player) {
            targetLocation = player.getLocation();
        }
        if ((spell = (mage = this.controller.getMage(mageController)).getSpell(spellName, usePermissions)) == null) {
            sender.sendMessage("Spell " + spellName + " unknown");
            return false;
        }
        this.controller.toggleCastCommandOverrides(mage, true);
        spell.cast(parameters, targetLocation);
        this.controller.toggleCastCommandOverrides(mage, false);
        if (sender != player) {
            String castMessage = "Cast " + spellName;
            if (player != null) {
                castMessage = String.valueOf(castMessage) + " on " + player.getName();
            }
            sender.sendMessage(castMessage);
        }
        return true;
    }

    public boolean onSpells(Player player, String[] parameters) {
        int pageNumber = 1;
        String category = null;
        if (parameters.length > 0) {
            try {
                pageNumber = Integer.parseInt(parameters[0]);
            }
            catch (NumberFormatException ex) {
                pageNumber = 1;
                category = parameters[0];
            }
        }
        this.listSpells((CommandSender)player, pageNumber, category);
        return true;
    }

    public void listSpellsByCategory(CommandSender sender, String category) {
        ArrayList<Spell> categorySpells = new ArrayList<Spell>();
        List<Spell> spellVariants = this.controller.getAllSpells();
        Player player = sender instanceof Player ? (Player)sender : null;
        for (Spell spell : spellVariants) {
            String spellCategory = spell.getCategory();
            if (spellCategory == null || !spellCategory.equalsIgnoreCase(category) || player != null && !spell.hasSpellPermission(player)) continue;
            categorySpells.add(spell);
        }
        if (categorySpells.size() == 0) {
            String message = Messages.get("general.no_spells_in_category");
            message = message.replace("$category", category);
            sender.sendMessage(message);
            return;
        }
        sender.sendMessage(String.valueOf(category) + ":");
        Collections.sort(categorySpells);
        for (Spell spell : categorySpells) {
            String name = spell.getName();
            String description = spell.getDescription();
            if (!name.equals(spell.getKey())) {
                description = String.valueOf(name) + " : " + description;
            }
            sender.sendMessage(ChatColor.AQUA + spell.getKey() + ChatColor.BLUE + " [" + spell.getIcon().getMaterial().name().toLowerCase() + "] : " + ChatColor.YELLOW + description);
        }
    }

    public void listCategories(Player player) {
        HashMap<String, Integer> spellCounts = new HashMap<String, Integer>();
        ArrayList<String> spellGroups = new ArrayList<String>();
        List<Spell> spellVariants = this.controller.getAllSpells();
        for (Spell spell : spellVariants) {
            if (player != null && !spell.hasSpellPermission(player) || spell.getCategory() == null) continue;
            Integer spellCount = (Integer)spellCounts.get(spell.getCategory());
            if (spellCount == null || spellCount == 0) {
                spellCounts.put(spell.getCategory(), 1);
                spellGroups.add(spell.getCategory());
                continue;
            }
            spellCounts.put(spell.getCategory(), spellCount + 1);
        }
        if (spellGroups.size() == 0) {
            player.sendMessage(Messages.get("general.no_spells"));
            return;
        }
        Collections.sort(spellGroups);
        for (String group : spellGroups) {
            player.sendMessage(String.valueOf(group) + " [" + spellCounts.get(group) + "]");
        }
    }

    public void listSpells(CommandSender sender, int pageNumber, String category) {
        if (category != null) {
            this.listSpellsByCategory(sender, category);
            return;
        }
        Player player = sender instanceof Player ? (Player)sender : null;
        HashMap<String, SpellGroup> spellGroups = new HashMap<String, SpellGroup>();
        List<Spell> spellVariants = this.controller.getAllSpells();
        int spellCount = 0;
        for (Spell spell : spellVariants) {
            if (player != null && !spell.hasSpellPermission(player) || spell.getCategory() == null) continue;
            ++spellCount;
            SpellGroup group = (SpellGroup)spellGroups.get(spell.getCategory());
            if (group == null) {
                group = new SpellGroup();
                group.groupName = spell.getCategory();
                spellGroups.put(group.groupName, group);
            }
            group.spells.add(spell);
        }
        ArrayList sortedGroups = new ArrayList();
        sortedGroups.addAll(spellGroups.values());
        Collections.sort(sortedGroups);
        int maxLines = -1;
        if (pageNumber >= 0) {
            maxLines = 5;
            int maxPages = spellCount / maxLines + 1;
            if (pageNumber > maxPages) {
                pageNumber = maxPages;
            }
            String message = Messages.get("general.spell_list_page");
            message = message.replace("$count", Integer.toString(spellCount));
            message = message.replace("$pages", Integer.toString(maxPages));
            message = message.replace("$page", Integer.toString(pageNumber));
            sender.sendMessage(message);
        } else {
            String message = Messages.get("general.spell_list");
            message = message.replace("$count", Integer.toString(spellCount));
            sender.sendMessage(message);
        }
        int currentPage = 1;
        int lineCount = 0;
        int printedCount = 0;
        block1: for (SpellGroup group : sortedGroups) {
            if (printedCount > maxLines && maxLines > 0) break;
            boolean isFirst = true;
            Collections.sort(group.spells);
            for (Spell spell : group.spells) {
                if (printedCount > maxLines && maxLines > 0) continue block1;
                if (currentPage == pageNumber || maxLines < 0) {
                    if (isFirst) {
                        sender.sendMessage(String.valueOf(group.groupName) + ":");
                        isFirst = false;
                    }
                    String name = spell.getName();
                    String description = spell.getDescription();
                    if (!name.equals(spell.getKey())) {
                        description = String.valueOf(name) + " : " + description;
                    }
                    sender.sendMessage(ChatColor.AQUA + spell.getKey() + ChatColor.BLUE + " [" + spell.getIcon().getMaterial().name().toLowerCase() + "] : " + ChatColor.YELLOW + description);
                    ++printedCount;
                }
                if (++lineCount != maxLines) continue;
                lineCount = 0;
                ++currentPage;
            }
        }
    }

    public void onDisable() {
        this.controller.save();
        this.controller.clear();
    }
}

