/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.blocks;

import com.elmakers.mine.bukkit.blocks.BlockData;
import com.elmakers.mine.bukkit.blocks.BlockList;
import com.elmakers.mine.bukkit.blocks.VolumeBatch;
import com.elmakers.mine.bukkit.plugins.magic.MagicController;
import java.util.ArrayList;

public class UndoBatch
extends VolumeBatch {
    private final BlockList blockList;
    private int blockIndex = 0;

    public UndoBatch(MagicController spells, BlockList blockList) {
        super(spells, blockList.getWorldName());
        this.blockList = blockList;
    }

    @Override
    public int size() {
        return this.blockList.size();
    }

    @Override
    public int remaining() {
        return this.blockList.size() - this.blockIndex;
    }

    @Override
    public int process(int maxBlocks) {
        int processedBlocks = 0;
        ArrayList<BlockData> undoList = this.blockList.getBlockList();
        while (undoList != null && this.blockIndex < undoList.size()) {
            BlockData blockData = undoList.get(this.blockIndex);
            if (!this.blockList.undo(blockData)) break;
            this.updateBlock(blockData);
            ++this.blockIndex;
            ++processedBlocks;
        }
        if (undoList == null || this.blockIndex >= undoList.size()) {
            this.finish();
        }
        return processedBlocks;
    }
}

