/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.blocks;

import com.elmakers.mine.bukkit.blocks.EntityData;
import com.elmakers.mine.bukkit.blocks.MaterialAndData;
import com.elmakers.mine.bukkit.blocks.MaterialBrushData;
import com.elmakers.mine.bukkit.blocks.Schematic;
import com.elmakers.mine.bukkit.plugins.magic.Mage;
import com.elmakers.mine.bukkit.plugins.magic.MagicController;
import com.elmakers.mine.bukkit.utilities.MaterialMapCanvas;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.TreeSpecies;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Painting;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;
import org.bukkit.util.Vector;

public class MaterialBrush
extends MaterialBrushData {
    public static final String ERASE_MATERIAL_KEY = "erase";
    public static final String COPY_MATERIAL_KEY = "copy";
    public static final String CLONE_MATERIAL_KEY = "clone";
    public static final String REPLICATE_MATERIAL_KEY = "replicate";
    public static final String MAP_MATERIAL_KEY = "map";
    public static final String SCHEMATIC_MATERIAL_KEY = "schematic";
    public static Material EraseMaterial = Material.SULPHUR;
    public static Material CopyMaterial = Material.SUGAR;
    public static Material CloneMaterial = Material.NETHER_STALK;
    public static Material ReplicateMaterial = Material.PUMPKIN_SEEDS;
    public static Material MapMaterial = Material.MAP;
    public static Material SchematicMaterial = Material.PAPER;
    public static boolean SchematicsEnabled = false;
    public static final Material DEFAULT_MATERIAL = Material.DIRT;
    private BrushMode mode = BrushMode.MATERIAL;
    private Location cloneLocation = null;
    private Location cloneTarget = null;
    private Location materialTarget = null;
    private Vector targetOffset = null;
    private final MagicController controller;
    private short mapId = (short)-1;
    private MaterialMapCanvas mapCanvas = null;
    private Material mapMaterialBase = Material.STAINED_CLAY;
    private Schematic schematic;
    private boolean fillWithAir = true;
    private Vector orientVector = null;

    public MaterialBrush(MagicController controller, Material material, byte data) {
        super(material, data);
        this.controller = controller;
    }

    public MaterialBrush(MagicController controller, Location location, String materialKey) {
        super(DEFAULT_MATERIAL, (byte)0);
        this.controller = controller;
        this.update(materialKey);
        this.activate(location, materialKey);
    }

    public static String getMaterialKey(Material material) {
        return MaterialBrush.getMaterialKey(material, true);
    }

    public static String getMaterialKey(Material material, boolean allowItems) {
        String materialKey = null;
        if (material == null) {
            return null;
        }
        if (material == EraseMaterial) {
            materialKey = ERASE_MATERIAL_KEY;
        } else if (material == CopyMaterial) {
            materialKey = COPY_MATERIAL_KEY;
        } else if (material == CloneMaterial) {
            materialKey = CLONE_MATERIAL_KEY;
        } else if (material == MapMaterial) {
            materialKey = MAP_MATERIAL_KEY;
        } else if (material == ReplicateMaterial) {
            materialKey = REPLICATE_MATERIAL_KEY;
        } else if (SchematicsEnabled && material == SchematicMaterial) {
            materialKey = SCHEMATIC_MATERIAL_KEY;
        } else if (allowItems || material.isBlock()) {
            materialKey = material.name().toLowerCase();
        }
        return materialKey;
    }

    public static String getMaterialKey(Material material, byte data) {
        return MaterialBrush.getMaterialKey(material, data, true);
    }

    public static String getMaterialKey(Material material, byte data, boolean allowItems) {
        String materialKey = MaterialBrush.getMaterialKey(material, allowItems);
        if (materialKey == null) {
            return null;
        }
        if (data != 0) {
            materialKey = materialKey + ":" + data;
        }
        return materialKey;
    }

    public static String getMaterialKey(MaterialAndData materialData) {
        return MaterialBrush.getMaterialKey(materialData.getMaterial(), materialData.getData(), true);
    }

    public static String getMaterialKey(MaterialAndData materialData, boolean allowItems) {
        return MaterialBrush.getMaterialKey(materialData.getMaterial(), materialData.getData(), allowItems);
    }

    public static boolean isSpecialMaterialKey(String materialKey) {
        if (materialKey == null || materialKey.length() == 0) {
            return false;
        }
        return COPY_MATERIAL_KEY.equals(materialKey = MaterialBrush.splitMaterialKey(materialKey)[0]) || ERASE_MATERIAL_KEY.equals(materialKey) || REPLICATE_MATERIAL_KEY.equals(materialKey) || CLONE_MATERIAL_KEY.equals(materialKey) || MAP_MATERIAL_KEY.equals(materialKey) || SchematicsEnabled && SCHEMATIC_MATERIAL_KEY.equals(materialKey);
    }

    public static String[] splitMaterialKey(String materialKey) {
        if (materialKey.contains("|")) {
            return StringUtils.split((String)materialKey, (String)"|");
        }
        if (materialKey.contains(":")) {
            return StringUtils.split((String)materialKey, (String)":");
        }
        return new String[]{materialKey};
    }

    public static String getMaterialName(MaterialAndData material) {
        return MaterialBrush.getMaterialName(MaterialBrush.getMaterialKey(material));
    }

    public static String getMaterialName(Material material, byte data) {
        return MaterialBrush.getMaterialName(MaterialBrush.getMaterialKey(material, data));
    }

    public static String getMaterialName(String materialKey) {
        if (materialKey == null) {
            return null;
        }
        String materialName = materialKey;
        String[] namePieces = MaterialBrush.splitMaterialKey(materialName);
        if (namePieces.length == 0) {
            return null;
        }
        materialName = namePieces[0];
        if (!MaterialBrush.isSpecialMaterialKey(materialKey)) {
            MaterialBrushData brushData = MaterialBrush.parseMaterialKey(materialKey);
            if (brushData == null) {
                return null;
            }
            Material material = brushData.getMaterial();
            byte data = brushData.getData();
            if (material == Material.CARPET || material.getId() == 95 || material.getId() == 159 || material.getId() == 160 || material == Material.WOOL) {
                DyeColor color = DyeColor.getByWoolData((byte)data);
                if (color != null) {
                    materialName = color.name().toLowerCase().replace('_', ' ') + " " + materialName;
                }
            } else if (material == Material.WOOD || material == Material.LOG || material == Material.SAPLING || material == Material.LEAVES) {
                TreeSpecies treeSpecies = TreeSpecies.getByData((byte)data);
                if (treeSpecies != null) {
                    materialName = treeSpecies.name().toLowerCase().replace('_', ' ') + " " + materialName;
                }
            } else {
                materialName = material.name();
            }
        } else if (materialName.startsWith(SCHEMATIC_MATERIAL_KEY) && namePieces.length > 1) {
            materialName = namePieces[1];
        }
        materialName = materialName.toLowerCase().replace('_', ' ');
        return materialName;
    }

    public String getName() {
        String brushKey = this.getKey();
        switch (this.mode) {
            case CLONE: {
                brushKey = CLONE_MATERIAL_KEY;
                break;
            }
            case REPLICATE: {
                brushKey = REPLICATE_MATERIAL_KEY;
                break;
            }
            case COPY: {
                brushKey = COPY_MATERIAL_KEY;
                break;
            }
            case MAP: {
                brushKey = MAP_MATERIAL_KEY;
                break;
            }
            case SCHEMATIC: {
                brushKey = "schematic:" + this.schematicName;
                break;
            }
        }
        return MaterialBrush.getMaterialName(brushKey);
    }

    public static MaterialBrushData parseMaterialKey(String materialKey) {
        return MaterialBrush.parseMaterialKey(materialKey, true);
    }

    public static MaterialBrushData parseMaterialKey(String materialKey, boolean allowItems) {
        if (materialKey == null || materialKey.length() == 0) {
            return null;
        }
        Material material = Material.DIRT;
        byte data = 0;
        String schematicName = "";
        String[] pieces = MaterialBrush.splitMaterialKey(materialKey);
        if (materialKey.equals(ERASE_MATERIAL_KEY)) {
            material = EraseMaterial;
        } else if (materialKey.equals(COPY_MATERIAL_KEY)) {
            material = CopyMaterial;
        } else if (materialKey.equals(CLONE_MATERIAL_KEY)) {
            material = CloneMaterial;
        } else if (materialKey.equals(REPLICATE_MATERIAL_KEY)) {
            material = ReplicateMaterial;
        } else if (materialKey.equals(MAP_MATERIAL_KEY)) {
            material = MapMaterial;
        } else if (SchematicsEnabled && pieces[0].equals(SCHEMATIC_MATERIAL_KEY) && pieces.length > 1) {
            material = SchematicMaterial;
            schematicName = pieces[1];
        } else {
            try {
                if (pieces.length > 0) {
                    try {
                        Integer id = Integer.parseInt(pieces[0]);
                        material = Material.getMaterial((int)id);
                    }
                    catch (Exception ex) {
                        material = Material.getMaterial((String)pieces[0].toUpperCase());
                    }
                }
                if (!allowItems && material != null && !material.isBlock()) {
                    material = null;
                }
            }
            catch (Exception ex) {
                material = null;
            }
            try {
                if (pieces.length > 1) {
                    data = Byte.parseByte(pieces[1]);
                }
            }
            catch (Exception ex) {
                data = 0;
            }
        }
        if (material == null) {
            return null;
        }
        return new MaterialBrushData(material, data, schematicName);
    }

    public static boolean isValidMaterial(String materialKey) {
        return MaterialBrush.parseMaterialKey(materialKey) != null;
    }

    public static boolean isValidMaterial(String materialKey, boolean allowItems) {
        return MaterialBrush.parseMaterialKey(materialKey, allowItems) != null;
    }

    public void update(String activeMaterial) {
        String[] pieces = MaterialBrush.splitMaterialKey(activeMaterial);
        if (activeMaterial.equals(COPY_MATERIAL_KEY)) {
            this.enableCopying();
        } else if (activeMaterial.equals(CLONE_MATERIAL_KEY)) {
            this.enableCloning();
        } else if (activeMaterial.equals(REPLICATE_MATERIAL_KEY)) {
            this.enableReplication();
        } else if (activeMaterial.equals(MAP_MATERIAL_KEY)) {
            this.enableMap();
        } else if (activeMaterial.equals(ERASE_MATERIAL_KEY)) {
            this.enableErase();
        } else if (pieces.length > 1 && pieces[0].equals(SCHEMATIC_MATERIAL_KEY)) {
            this.enableSchematic(pieces[1]);
        } else {
            MaterialBrushData material = MaterialBrush.parseMaterialKey(activeMaterial);
            if (material != null) {
                this.setMaterial(material.getMaterial(), material.getData());
            }
        }
    }

    public void activate(Location location, String material) {
        String materialKey = MaterialBrush.splitMaterialKey(material)[0];
        if (materialKey.equals(CLONE_MATERIAL_KEY) || materialKey.equals(REPLICATE_MATERIAL_KEY)) {
            Location cloneFrom = location.clone();
            cloneFrom.setY(cloneFrom.getY() - 1.0);
            this.setCloneLocation(cloneFrom);
        } else if (materialKey.equals(MAP_MATERIAL_KEY) || materialKey.equals(SCHEMATIC_MATERIAL_KEY)) {
            this.clearCloneTarget();
        }
    }

    @Override
    public void setMaterial(Material material, byte data) {
        if (!this.controller.isRestricted(material) && material.isBlock()) {
            super.setMaterial(material, data);
            this.mode = BrushMode.MATERIAL;
            this.isValid = true;
        } else {
            this.isValid = false;
        }
        this.fillWithAir = true;
    }

    public void enableCloning() {
        if (this.mode != BrushMode.CLONE) {
            this.fillWithAir = this.mode == BrushMode.ERASE;
            this.mode = BrushMode.CLONE;
        }
    }

    public void enableErase() {
        if (this.mode != BrushMode.ERASE) {
            this.setMaterial(Material.AIR);
            this.mode = BrushMode.ERASE;
            this.fillWithAir = true;
        }
    }

    public void enableMap() {
        this.fillWithAir = false;
        this.mode = BrushMode.MAP;
        if (this.material == Material.WOOL || this.material == Material.STAINED_CLAY || this.material.getId() == 95 || this.material.getId() == 160 || this.material == Material.CARPET) {
            this.mapMaterialBase = this.material;
        }
    }

    public void enableSchematic(String name) {
        if (this.mode != BrushMode.SCHEMATIC) {
            this.fillWithAir = this.mode == BrushMode.ERASE;
            this.mode = BrushMode.SCHEMATIC;
        }
        this.schematicName = name;
        this.schematic = null;
    }

    public void clearSchematic() {
        this.schematic = null;
    }

    public void enableReplication() {
        if (this.mode != BrushMode.REPLICATE) {
            this.fillWithAir = this.mode == BrushMode.ERASE;
            this.mode = BrushMode.REPLICATE;
        }
    }

    public void setData(byte data) {
        this.data = data;
    }

    public void setMapId(short mapId) {
        this.mapCanvas = null;
        this.mapId = mapId;
    }

    public void setCloneLocation(Location cloneFrom) {
        this.cloneLocation = cloneFrom;
        this.materialTarget = cloneFrom;
        this.cloneTarget = null;
    }

    public void clearCloneTarget() {
        this.cloneTarget = null;
        this.targetOffset = null;
    }

    public void setTargetOffset(Vector offset) {
        this.targetOffset = offset.clone();
    }

    public boolean hasCloneTarget() {
        return this.cloneLocation != null && this.cloneTarget != null;
    }

    public void enableCopying() {
        this.mode = BrushMode.COPY;
    }

    public boolean isReady() {
        if ((this.mode == BrushMode.CLONE || this.mode == BrushMode.REPLICATE) && this.materialTarget != null) {
            Block block = this.materialTarget.getBlock();
            return block.getChunk().isLoaded();
        }
        return true;
    }

    public void setTarget(Location target) {
        this.setTarget(target, target);
    }

    public void setTarget(Location target, Location center) {
        this.orientVector = target.toVector().subtract(center.toVector());
        this.orientVector.setX(Math.abs(this.orientVector.getX()));
        this.orientVector.setY(Math.abs(this.orientVector.getY()));
        this.orientVector.setZ(Math.abs(this.orientVector.getZ()));
        if (this.mode == BrushMode.REPLICATE || this.mode == BrushMode.CLONE || this.mode == BrushMode.MAP || this.mode == BrushMode.SCHEMATIC) {
            Vector diff;
            if (this.cloneTarget == null || this.mode == BrushMode.CLONE || !center.getWorld().getName().equals(this.cloneTarget.getWorld().getName())) {
                this.cloneTarget = center;
                if (this.targetOffset != null) {
                    this.cloneTarget = this.cloneTarget.add(this.targetOffset);
                }
            } else if (this.mode == BrushMode.SCHEMATIC && this.schematic != null && !this.schematic.contains(diff = target.toVector().subtract(this.cloneTarget.toVector()))) {
                this.cloneTarget = center;
                if (this.targetOffset != null) {
                    this.cloneTarget = this.cloneTarget.add(this.targetOffset);
                }
            }
        }
        if (this.mode == BrushMode.COPY) {
            Block block = target.getBlock();
            if (this.targetOffset != null) {
                Location targetLocation = block.getLocation();
                targetLocation = targetLocation.add(this.targetOffset);
                block = targetLocation.getBlock();
            }
            this.updateFrom(block, this.controller.getRestrictedMaterials());
        }
    }

    public Location toTargetLocation(Location target) {
        if (this.cloneLocation == null || this.cloneTarget == null) {
            return null;
        }
        Location translated = this.cloneLocation.clone();
        translated.subtract(this.cloneTarget.toVector());
        translated.add(target.toVector());
        return translated;
    }

    public Location fromTargetLocation(World targetWorld, Location target) {
        if (this.cloneLocation == null || this.cloneTarget == null) {
            return null;
        }
        Location translated = target.clone();
        translated.setX((double)translated.getBlockX());
        translated.setY((double)translated.getBlockY());
        translated.setZ((double)translated.getBlockZ());
        Vector cloneVector = new Vector(this.cloneLocation.getBlockX(), this.cloneLocation.getBlockY(), this.cloneLocation.getBlockZ());
        translated.subtract(cloneVector);
        Vector cloneTargetVector = new Vector(this.cloneTarget.getBlockX(), this.cloneTarget.getBlockY(), this.cloneTarget.getBlockZ());
        translated.add(cloneTargetVector);
        translated.setWorld(targetWorld);
        return translated;
    }

    public boolean update(Mage fromMage, Location target) {
        Vector diff;
        if (this.mode == BrushMode.CLONE || this.mode == BrushMode.REPLICATE) {
            if (this.cloneLocation == null) {
                this.isValid = false;
                return true;
            }
            if (this.cloneTarget == null) {
                this.cloneTarget = target;
            }
            this.materialTarget = this.toTargetLocation(target);
            if (this.materialTarget.getY() <= 0.0 || this.materialTarget.getY() >= 255.0) {
                this.isValid = false;
            } else {
                Block block = this.materialTarget.getBlock();
                if (!block.getChunk().isLoaded()) {
                    return false;
                }
                this.updateFrom(block, this.controller.getRestrictedMaterials());
                boolean bl = this.isValid = this.fillWithAir || this.material != Material.AIR;
            }
        }
        if (this.mode == BrushMode.SCHEMATIC) {
            if (this.schematic == null) {
                if (this.schematicName.length() == 0) {
                    this.isValid = false;
                    return true;
                }
                this.schematic = this.controller.loadSchematic(this.schematicName);
                if (this.schematic == null) {
                    this.schematicName = "";
                    this.isValid = false;
                    return true;
                }
            }
            if (this.cloneTarget == null) {
                this.isValid = false;
                return true;
            }
            diff = target.toVector().subtract(this.cloneTarget.toVector());
            MaterialAndData newMaterial = this.schematic.getBlock(diff);
            if (newMaterial == null) {
                this.isValid = false;
            } else {
                this.updateFrom(newMaterial);
                boolean bl = this.isValid = this.fillWithAir || newMaterial.getMaterial() != Material.AIR;
            }
        }
        if (this.mode == BrushMode.MAP && this.mapId >= 0) {
            if (this.mapCanvas == null && fromMage != null) {
                try {
                    List renderers;
                    MapView mapView = Bukkit.getMap((short)this.mapId);
                    if (mapView != null && (renderers = mapView.getRenderers()).size() > 0) {
                        this.mapCanvas = new MaterialMapCanvas();
                        MapRenderer renderer = (MapRenderer)renderers.get(0);
                        renderer.initialize(mapView);
                        renderer.render(mapView, (MapCanvas)this.mapCanvas, fromMage.getPlayer());
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            this.isValid = false;
            if (this.mapCanvas != null && this.cloneTarget != null) {
                diff = target.toVector().subtract(this.cloneTarget.toVector());
                DyeColor mapColor = DyeColor.WHITE;
                mapColor = this.orientVector.getBlockY() > this.orientVector.getBlockZ() || this.orientVector.getBlockY() > this.orientVector.getBlockX() ? (this.orientVector.getBlockX() > this.orientVector.getBlockZ() ? this.mapCanvas.getDyeColor(Math.abs(diff.getBlockX() * 8 + MaterialMapCanvas.CANVAS_WIDTH / 2) % MaterialMapCanvas.CANVAS_WIDTH, Math.abs(-diff.getBlockY() * 8 + MaterialMapCanvas.CANVAS_HEIGHT / 2) % MaterialMapCanvas.CANVAS_HEIGHT) : this.mapCanvas.getDyeColor(Math.abs(diff.getBlockZ() * 8 + MaterialMapCanvas.CANVAS_WIDTH / 2) % MaterialMapCanvas.CANVAS_WIDTH, Math.abs(-diff.getBlockY() * 8 + MaterialMapCanvas.CANVAS_HEIGHT / 2) % MaterialMapCanvas.CANVAS_HEIGHT)) : this.mapCanvas.getDyeColor(Math.abs(diff.getBlockX() * 8 + MaterialMapCanvas.CANVAS_WIDTH / 2) % MaterialMapCanvas.CANVAS_WIDTH, Math.abs(diff.getBlockZ() * 8 + MaterialMapCanvas.CANVAS_HEIGHT / 2) % MaterialMapCanvas.CANVAS_HEIGHT);
                if (mapColor != null) {
                    super.setMaterial(this.mapMaterialBase, mapColor.getData());
                    this.isValid = true;
                }
            }
        }
        return true;
    }

    public void prepare() {
        Block block;
        if (this.cloneLocation != null && !(block = this.cloneTarget.getBlock()).getChunk().isLoaded()) {
            block.getChunk().load(true);
        }
    }

    public void load(ConfigurationNode node) {
        try {
            this.cloneLocation = node.getLocation("clone_location");
            this.cloneTarget = node.getLocation("clone_target");
            this.materialTarget = node.getLocation("material_target");
            this.mapId = (short)node.getInt("map_id", this.mapId);
            this.material = node.getMaterial("material", this.material);
            this.data = (byte)node.getInt("data", this.data);
            this.schematicName = node.getString(SCHEMATIC_MATERIAL_KEY, this.schematicName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.controller.getPlugin().getLogger().warning("Failed to load brush data: " + ex.getMessage());
        }
    }

    public void save(ConfigurationNode node) {
        try {
            if (this.cloneLocation != null) {
                node.setProperty("clone_location", this.cloneLocation);
            }
            if (this.cloneTarget != null) {
                node.setProperty("clone_target", this.cloneTarget);
            }
            if (this.materialTarget != null) {
                node.setProperty("material_target", this.materialTarget);
            }
            node.setProperty("map_id", this.mapId);
            node.setProperty("material", this.material);
            node.setProperty("data", this.data);
            node.setProperty(SCHEMATIC_MATERIAL_KEY, this.schematicName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.controller.getLogger().warning("Failed to save brush data: " + ex.getMessage());
        }
    }

    public boolean hasEntities() {
        return this.mode == BrushMode.CLONE || this.mode == BrushMode.REPLICATE;
    }

    public List<EntityData> getEntities(Location center, int radius) {
        ArrayList<EntityData> copyEntities = new ArrayList<EntityData>();
        int radiusSquared = radius * radius;
        if (this.mode == BrushMode.CLONE || this.mode == BrushMode.REPLICATE) {
            World targetWorld = center.getWorld();
            List targetEntities = targetWorld.getEntities();
            for (Entity entity : targetEntities) {
                if (!(entity instanceof Painting) && !(entity instanceof ItemFrame) || !(entity.getLocation().distanceSquared(center) <= (double)radiusSquared)) continue;
                entity.remove();
            }
            Location cloneLocation = this.toTargetLocation(center);
            World sourceWorld = cloneLocation.getWorld();
            List entities = sourceWorld.getEntities();
            for (Entity entity : entities) {
                if (!(entity instanceof Painting) && !(entity instanceof ItemFrame)) continue;
                Location entityLocation = entity.getLocation();
                if (entity.getLocation().distanceSquared(cloneLocation) > (double)radiusSquared) continue;
                EntityData entityData = new EntityData(this.fromTargetLocation(center.getWorld(), entityLocation), entity);
                copyEntities.add(entityData);
            }
        } else if (this.mode == BrushMode.SCHEMATIC && this.schematic != null) {
            return this.schematic.getEntities(center, radius);
        }
        return copyEntities;
    }

    private static enum BrushMode {
        MATERIAL,
        ERASE,
        COPY,
        CLONE,
        REPLICATE,
        MAP,
        SCHEMATIC;

    }
}

