/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.blocks;

import com.elmakers.mine.bukkit.utilities.InventoryUtils;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CommandBlock;
import org.bukkit.block.Sign;
import org.bukkit.block.Skull;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class MaterialAndData {
    protected Material material;
    protected byte data;
    protected String[] signLines = null;
    protected String commandLine = null;
    protected String skullName = null;
    protected ItemStack[] inventoryContents = null;
    protected boolean isValid = true;

    public MaterialAndData() {
        this.material = Material.AIR;
        this.data = 0;
    }

    public MaterialAndData(Block block) {
        this.material = block.getType();
        this.data = block.getData();
    }

    public MaterialAndData(MaterialAndData other) {
        this.updateFrom(other);
    }

    public int hashCode() {
        return this.material.getId() << 8 | this.data;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MaterialAndData)) {
            return false;
        }
        MaterialAndData other = (MaterialAndData)obj;
        return other.data == this.data && other.material == this.material;
    }

    public void updateFrom(MaterialAndData other) {
        this.material = other.material;
        this.data = other.data;
        this.commandLine = other.commandLine;
        this.inventoryContents = other.inventoryContents;
        this.signLines = other.signLines;
        this.skullName = other.skullName;
        this.isValid = other.isValid;
    }

    public MaterialAndData(Material material) {
        this.material = material;
        this.data = 0;
    }

    public MaterialAndData(Material material, byte data) {
        this.material = material;
        this.data = data;
    }

    public void setMaterial(Material material, byte data) {
        this.material = material;
        this.data = data;
        this.signLines = null;
        this.commandLine = null;
        this.inventoryContents = null;
        this.skullName = null;
        this.isValid = true;
    }

    public void setMaterial(Material material) {
        this.setMaterial(material, (byte)0);
    }

    public void updateFrom(Block block) {
        this.updateFrom(block, null);
    }

    public void updateFrom(Block block, Set<Material> restrictedMaterials) {
        if (!block.getChunk().isLoaded()) {
            block.getChunk().load(true);
            return;
        }
        Material blockMaterial = block.getType();
        if (restrictedMaterials != null && restrictedMaterials.contains(blockMaterial)) {
            this.isValid = false;
            return;
        }
        this.signLines = null;
        this.commandLine = null;
        this.inventoryContents = null;
        this.skullName = null;
        BlockState blockState = block.getState();
        if (blockState instanceof Sign) {
            Sign sign = (Sign)blockState;
            this.signLines = sign.getLines();
        } else if (blockState instanceof CommandBlock) {
            CommandBlock command = (CommandBlock)blockState;
            this.commandLine = command.getCommand();
        } else if (blockState instanceof InventoryHolder) {
            InventoryHolder holder = (InventoryHolder)blockState;
            Inventory holderInventory = holder.getInventory();
            this.inventoryContents = holderInventory.getContents();
        } else if (blockState instanceof Skull) {
            Skull skull = (Skull)blockState;
            this.skullName = skull.getOwner();
        }
        this.material = blockMaterial;
        this.data = block.getData();
        this.isValid = true;
    }

    public void modify(Block block) {
        if (!this.isValid) {
            return;
        }
        try {
            BlockState oldState = block.getState();
            if (oldState instanceof InventoryHolder) {
                InventoryHolder holder = (InventoryHolder)oldState;
                Inventory inventory = holder.getInventory();
                inventory.clear();
            }
            block.setType(this.material);
            block.setData(this.data);
            BlockState blockState = block.getState();
            if (blockState instanceof Sign && this.signLines != null) {
                Sign sign = (Sign)blockState;
                int i = 0;
                while (i < this.signLines.length) {
                    sign.setLine(i, this.signLines[i]);
                    ++i;
                }
                sign.update();
            } else if (blockState instanceof CommandBlock && this.commandLine != null) {
                CommandBlock command = (CommandBlock)blockState;
                command.setCommand(this.commandLine);
                command.update();
            } else if (blockState instanceof InventoryHolder && this.inventoryContents != null) {
                InventoryHolder holder = (InventoryHolder)blockState;
                Inventory newInventory = holder.getInventory();
                int maxSize = Math.min(newInventory.getSize(), this.inventoryContents.length);
                int i = 0;
                while (i < maxSize) {
                    ItemStack item = this.inventoryContents[i];
                    if ((item = InventoryUtils.getCopy(item)) != null) {
                        newInventory.setItem(i, item);
                    }
                    ++i;
                }
            } else if (blockState instanceof Skull && this.skullName != null) {
                Skull skull = (Skull)blockState;
                skull.setOwner(this.skullName);
                skull.update();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public byte getData() {
        return this.data;
    }

    public Material getMaterial() {
        return this.material;
    }

    public String getKey() {
        String materialKey = this.material.name().toLowerCase();
        if (this.data != 0) {
            materialKey = String.valueOf(materialKey) + ":" + this.data;
        }
        return materialKey;
    }

    public boolean isDifferent(Block block) {
        CommandBlock command;
        Material blockMaterial = block.getType();
        byte blockData = block.getData();
        if (blockMaterial != this.material || blockData != this.data) {
            return true;
        }
        BlockState blockState = block.getState();
        if (blockState instanceof Sign && this.signLines != null) {
            Sign sign = (Sign)blockState;
            String[] currentLines = sign.getLines();
            int i = 0;
            while (i < this.signLines.length) {
                if (!currentLines[i].equals(this.signLines[i])) {
                    return true;
                }
                ++i;
            }
        } else if (blockState instanceof CommandBlock && this.commandLine != null ? !(command = (CommandBlock)blockState).getCommand().equals(this.commandLine) : blockState instanceof InventoryHolder && this.inventoryContents != null) {
            return true;
        }
        return false;
    }

    public void setSignLines(String[] lines) {
        this.signLines = (String[])lines.clone();
    }

    public void setInventoryContents(ItemStack[] contents) {
        this.inventoryContents = contents;
    }

    public void setCommandLine(String command) {
        this.commandLine = command;
    }

    public ItemStack getItemStack(int amount) {
        return new ItemStack(this.material, amount, 0, Byte.valueOf(this.data));
    }
}

