/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.blocks;

import org.bukkit.Art;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Painting;
import org.bukkit.inventory.ItemStack;

public class EntityData {
    protected Location location;
    protected EntityType type;
    protected Art art;
    protected BlockFace facing;
    protected ItemStack item;

    public EntityData(Location location, EntityType type) {
        this.type = type;
        this.location = location;
    }

    public EntityData(Location location, Entity entity) {
        this.type = entity.getType();
        this.location = location;
        if (entity instanceof Hanging) {
            Hanging hanging = (Hanging)entity;
            this.facing = hanging.getFacing();
            this.location = location.getBlock().getRelative(this.facing.getOppositeFace()).getLocation();
        }
        if (entity instanceof Painting) {
            Painting painting = (Painting)entity;
            this.art = painting.getArt();
        }
        if (entity instanceof ItemFrame) {
            ItemFrame itemFrame = (ItemFrame)entity;
            this.item = itemFrame.getItem();
        }
    }

    public Location getLocation() {
        return this.location;
    }

    public EntityType getType() {
        return this.type;
    }

    public Art getArt() {
        return this.art;
    }

    public BlockFace getFacing() {
        return this.facing;
    }

    public ItemStack getItem() {
        return this.item;
    }
}

