/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utilities;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.imageio.ImageIO;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;

public class URLMap
extends MapRenderer {
    private static File configurationFile = null;
    private static File cacheFolder = null;
    private static Plugin plugin;
    private static HashMap<String, URLMap> keyMap;
    private static HashMap<Short, URLMap> idMap;
    private Short id;
    private BufferedImage image;
    protected String url;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected Integer xOverlay;
    protected Integer yOverlay;
    protected String name;
    protected boolean enabled = true;
    protected boolean rendered = false;
    protected volatile boolean loading = false;
    protected Set<String> sentToPlayers = new HashSet<String>();
    protected Integer priority;

    static {
        keyMap = new HashMap();
        idMap = new HashMap();
    }

    public static void loadConfiguration() {
        if (configurationFile == null) {
            return;
        }
        YamlConfiguration configuration = new YamlConfiguration();
        if (configurationFile.exists()) {
            try {
                URLMap.info("Loading image map data from " + configurationFile.getName());
                configuration.load(configurationFile);
                Set maps = configuration.getKeys(false);
                boolean needsUpdate = false;
                for (String mapIdString : maps) {
                    ConfigurationSection mapConfig = configuration.getConfigurationSection(mapIdString);
                    try {
                        Short mapId = null;
                        URLMap map = null;
                        Integer priority = null;
                        if (mapConfig.contains("priority")) {
                            priority = mapConfig.getInt("priority");
                        }
                        Integer xOverlay = null;
                        if (mapConfig.contains("x_overlay")) {
                            xOverlay = mapConfig.getInt("x_overlay");
                        }
                        Integer yOverlay = null;
                        if (mapConfig.contains("y_overlay")) {
                            yOverlay = mapConfig.getInt("y_overlay");
                        }
                        try {
                            mapId = Short.parseShort(mapIdString);
                        }
                        catch (Exception ex) {
                            map = URLMap.get(mapConfig.getString("url"), mapConfig.getString("name"), mapConfig.getInt("x"), mapConfig.getInt("y"), xOverlay, yOverlay, mapConfig.getInt("width"), mapConfig.getInt("height"), priority);
                            URLMap.info("Created new map id " + map.id + " for config id " + mapIdString);
                            needsUpdate = true;
                        }
                        if (map == null && mapId != null) {
                            map = URLMap.get(mapId, mapConfig.getString("url"), mapConfig.getString("name"), mapConfig.getInt("x"), mapConfig.getInt("y"), xOverlay, yOverlay, mapConfig.getInt("width"), mapConfig.getInt("height"), priority);
                        }
                        if (map == null) {
                            throw new Exception("Failed to load map id " + mapIdString);
                        }
                        if (!mapConfig.getBoolean("enabled")) {
                            super.disable();
                            continue;
                        }
                        map.getMapView();
                    }
                    catch (Exception ex) {
                        URLMap.warning("Failed to load " + configurationFile.getAbsolutePath() + ": " + ex.getMessage());
                    }
                }
                if (needsUpdate) {
                    URLMap.save();
                }
            }
            catch (Exception ex) {
                URLMap.warning("Failed to load " + configurationFile.getAbsolutePath() + ": " + ex.getMessage());
            }
        }
    }

    public static void load(Plugin callingPlugin, File configFile, File cache) {
        cacheFolder = cache;
        plugin = callingPlugin;
        configurationFile = configFile;
        URLMap.loadConfiguration();
    }

    public static void save() {
        if (configurationFile == null) {
            return;
        }
        YamlConfiguration configuration = new YamlConfiguration();
        for (URLMap map : idMap.values()) {
            ConfigurationSection mapConfig = configuration.createSection(Short.toString(map.id));
            mapConfig.set("url", (Object)map.url);
            mapConfig.set("x", (Object)map.x);
            mapConfig.set("y", (Object)map.y);
            mapConfig.set("width", (Object)map.width);
            mapConfig.set("height", (Object)map.height);
            mapConfig.set("enabled", (Object)map.isEnabled());
            mapConfig.set("name", (Object)map.name);
            if (map.priority != null) {
                mapConfig.set("priority", (Object)map.priority);
            }
            if (map.xOverlay != null) {
                mapConfig.set("x_overlay", (Object)map.xOverlay);
            }
            if (map.yOverlay == null) continue;
            mapConfig.set("y_overlay", (Object)map.yOverlay);
        }
        try {
            configuration.save(configurationFile);
        }
        catch (Exception ex) {
            URLMap.warning("Failed to save file " + configurationFile.getAbsolutePath());
        }
    }

    private static void info(String message) {
        if (plugin != null) {
            plugin.getLogger().info(message);
        }
    }

    private static void warning(String message) {
        if (plugin != null) {
            plugin.getLogger().warning(message);
        }
    }

    public static void resetAll() {
        for (URLMap map : keyMap.values()) {
            map.reset();
        }
    }

    public static void clearCache() {
        String[] cacheFiles;
        String[] stringArray = cacheFiles = cacheFolder.list();
        int n = cacheFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String cacheFilename = stringArray[n2];
            if (cacheFilename.endsWith(".png") || cacheFilename.endsWith(".jpeg") || cacheFilename.endsWith(".jpg") || cacheFilename.endsWith(".gif")) {
                File cacheFile = new File(cacheFolder, cacheFilename);
                cacheFile.delete();
                if (plugin != null) {
                    plugin.getLogger().info("Deleted file " + cacheFile.getAbsolutePath());
                }
            }
            ++n2;
        }
        URLMap.loadConfiguration();
    }

    public static ItemStack getMapItem(String name, short mapId) {
        ItemStack newMapItem = new ItemStack(Material.MAP, 1, mapId);
        if (name != null) {
            ItemMeta meta = newMapItem.getItemMeta();
            meta.setDisplayName(name);
            newMapItem.setItemMeta(meta);
        }
        return newMapItem;
    }

    public static ItemStack getPlayerPortrait(String playerName, Integer priority, String photoName) {
        photoName = photoName == null ? playerName : photoName;
        String photoLabel = "Photo of " + photoName;
        MapView mapView = URLMap.getURL("http://s3.amazonaws.com/MinecraftSkins/" + playerName + ".png", photoLabel, 8, 8, 40, 8, 8, 8, priority);
        return URLMap.getMapItem(photoLabel, mapView);
    }

    public static ItemStack getPlayerPortrait(String playerName, Integer priority) {
        return URLMap.getPlayerPortrait(playerName, priority, playerName);
    }

    public static ItemStack getPlayerPortrait(String playerName) {
        return URLMap.getPlayerPortrait(playerName, null);
    }

    protected static ItemStack getMapItem(String name, MapView mapView) {
        short id = 0;
        if (mapView != null) {
            id = mapView.getId();
        }
        return URLMap.getMapItem(name, id);
    }

    public static void forceReloadPlayerPortrait(String playerName) {
        URLMap map = URLMap.get("http://s3.amazonaws.com/MinecraftSkins/" + playerName + ".png", 8, 8, 8, 8);
        map.reload();
    }

    public static void forceReload(String url, int x, int y, int width, int height) {
        URLMap.get(url, x, y, width, height).reload();
    }

    public static MapView getURL(String url) {
        return URLMap.getURL(url, 0, 0, 0, 0);
    }

    public static ItemStack getURLItem(String url, int x, int y, int width, int height, String name, Integer priority) {
        MapView mapView = URLMap.getURL(url, x, y, width, height, priority);
        return URLMap.getMapItem(name, mapView);
    }

    public static ItemStack getURLItem(String url, int x, int y, int width, int height, String name) {
        return URLMap.getURLItem(url, x, y, width, height, name, null);
    }

    public static MapView getURL(String url, int x, int y, int width, int height, Integer priority) {
        URLMap map = URLMap.get(url, x, y, width, height, priority);
        return map.getMapView();
    }

    public static MapView getURL(String url, String name, int x, int y, Integer xOverlay, Integer yOverlay, int width, int height, Integer priority) {
        URLMap map = URLMap.get(url, name, x, y, xOverlay, yOverlay, width, height, priority);
        return map.getMapView();
    }

    public static MapView getURL(String url, int x, int y, int width, int height) {
        return URLMap.getURL(url, x, y, width, height, null);
    }

    public static void resend(String playerName) {
        for (URLMap map : keyMap.values()) {
            map.resendTo(playerName);
        }
    }

    public void render(MapView mapView, MapCanvas canvas, Player player) {
        if (this.rendered) {
            if (this.priority != null) {
                this.sendToPlayer(player, mapView);
            }
            return;
        }
        BufferedImage image = this.getImage();
        if (image != null) {
            canvas.drawImage(0, 0, (Image)image);
            this.rendered = true;
        }
    }

    public void initialize(MapView mapView) {
        this.rendered = false;
    }

    private static URLMap get(short mapId, String url, String name, int x, int y, Integer xOverlay, Integer yOverlay, int width, int height, Integer priority) {
        String key = URLMap.getKey(url, x, y, width, height);
        URLMap map = idMap.get(mapId);
        if (map != null) {
            if (!map.getKey().equals(key)) {
                URLMap.warning("Two maps with the same id but different keys: " + mapId + ": " + key + ", " + map.getKey());
            }
            return map;
        }
        map = keyMap.get(key);
        if (map != null) {
            if (map.id != mapId) {
                URLMap.warning("Two maps with the same key but different ids: " + key + ": " + mapId + ", " + map.id);
            }
            return map;
        }
        map = new URLMap(mapId, url, name, x, y, xOverlay, yOverlay, width, height, priority);
        keyMap.put(key, map);
        idMap.put(mapId, map);
        return map;
    }

    private static URLMap get(String url, int x, int y, int width, int height) {
        return URLMap.get(url, x, y, width, height, null);
    }

    private static URLMap get(String url, String name, int x, int y, Integer xOverlay, Integer yOverlay, int width, int height, Integer priority) {
        String key = URLMap.getKey(url, x, y, width, height);
        if (keyMap.containsKey(key)) {
            URLMap map = keyMap.get(key);
            map.priority = priority;
            map.name = name;
            map.xOverlay = xOverlay;
            map.yOverlay = yOverlay;
            return map;
        }
        World world = (World)Bukkit.getWorlds().get(0);
        MapView mapView = Bukkit.createMap((World)world);
        if (mapView == null) {
            URLMap.warning("Unable to create new map for url key " + key);
            return null;
        }
        URLMap newMap = URLMap.get(mapView.getId(), url, name, x, y, xOverlay, yOverlay, width, height, priority);
        URLMap.save();
        return newMap;
    }

    private static URLMap get(String url, int x, int y, int width, int height, Integer priority) {
        return URLMap.get(url, null, x, y, null, null, width, height, priority);
    }

    private MapView getMapView() {
        return this.getMapView(true);
    }

    private MapView getMapView(boolean recreateIfNecessary) {
        if (!this.enabled) {
            return null;
        }
        MapView mapView = Bukkit.getMap((short)this.id);
        if (mapView == null) {
            keyMap.remove(this.getKey());
            this.enabled = false;
            URLMap.warning("Failed to get map id " + this.id + " for key " + this.getKey() + ", disabled, re-enable in config and fix id");
            URLMap.save();
            return mapView;
        }
        List renderers = mapView.getRenderers();
        boolean needsRenderer = false;
        for (MapRenderer renderer : renderers) {
            if (renderer instanceof URLMap) continue;
            mapView.removeRenderer(renderer);
            needsRenderer = true;
        }
        if (needsRenderer) {
            mapView.addRenderer((MapRenderer)this);
        }
        return mapView;
    }

    private void disable() {
        this.enabled = false;
    }

    private boolean isEnabled() {
        return this.enabled;
    }

    private URLMap(short mapId, String url, String name, int x, int y, Integer xOverlay, Integer yOverlay, int width, int height, Integer priority) {
        this.url = url;
        this.name = name;
        this.x = x;
        this.y = y;
        this.xOverlay = xOverlay;
        this.yOverlay = yOverlay;
        this.width = width;
        this.height = height;
        this.id = mapId;
        this.priority = priority;
    }

    private static String getKey(String url, int x, int y, int width, int height) {
        return x + "," + y + "|" + width + "," + height + "|" + url;
    }

    private String getKey() {
        return URLMap.getKey(this.url, this.x, this.y, this.width, this.height);
    }

    private void resendTo(String playerName) {
        this.sentToPlayers.remove(playerName);
    }

    private void reload() {
        this.sentToPlayers.clear();
        this.rendered = false;
        this.loading = false;
        this.image = null;
    }

    private BufferedImage getImage() {
        if (this.loading || !this.enabled) {
            return null;
        }
        if (this.image == null) {
            this.loading = true;
            this.image = new BufferedImage(128, 128, 1);
            if (plugin == null) {
                return null;
            }
            Bukkit.getScheduler().runTaskAsynchronously(plugin, new Runnable(){

                @Override
                public void run() {
                    try {
                        URL imageUrl;
                        File cacheFile;
                        BufferedImage rawImage = null;
                        String cacheFileName = URLEncoder.encode(URLMap.this.url);
                        File file = cacheFile = cacheFolder != null ? new File(cacheFolder, cacheFileName) : null;
                        if (cacheFile != null) {
                            if (cacheFile.exists()) {
                                URLMap.info("Loading from cache: " + cacheFile.getName());
                                rawImage = ImageIO.read(cacheFile);
                            } else {
                                int len;
                                URLMap.info("Loading " + URLMap.this.url);
                                imageUrl = new URL(URLMap.this.url);
                                HttpURLConnection conn = (HttpURLConnection)imageUrl.openConnection();
                                conn.setConnectTimeout(30000);
                                conn.setReadTimeout(30000);
                                conn.setInstanceFollowRedirects(true);
                                InputStream in = conn.getInputStream();
                                FileOutputStream out = new FileOutputStream(cacheFile);
                                byte[] buffer = new byte[10240];
                                while ((len = in.read(buffer)) != -1) {
                                    ((OutputStream)out).write(buffer, 0, len);
                                }
                                ((OutputStream)out).close();
                                in.close();
                                rawImage = ImageIO.read(cacheFile);
                            }
                        } else {
                            URLMap.info("Loading " + URLMap.this.url);
                            imageUrl = new URL(URLMap.this.url);
                            rawImage = ImageIO.read(imageUrl);
                        }
                        URLMap.this.width = URLMap.this.width <= 0 ? rawImage.getWidth() + URLMap.this.width : URLMap.this.width;
                        URLMap.this.height = URLMap.this.height <= 0 ? rawImage.getHeight() + URLMap.this.height : URLMap.this.height;
                        BufferedImage croppedImage = rawImage.getSubimage(URLMap.this.x, URLMap.this.y, URLMap.this.width, URLMap.this.height);
                        Graphics2D graphics = URLMap.this.image.createGraphics();
                        AffineTransform transform = AffineTransform.getScaleInstance(128.0f / (float)URLMap.this.width, 128.0f / (float)URLMap.this.height);
                        graphics.drawRenderedImage(croppedImage, transform);
                        if (URLMap.this.xOverlay != null && URLMap.this.yOverlay != null) {
                            BufferedImage croppedOverlay = rawImage.getSubimage(URLMap.this.xOverlay, URLMap.this.yOverlay, URLMap.this.width, URLMap.this.height);
                            graphics.drawRenderedImage(croppedOverlay, transform);
                        }
                        URLMap.this.loading = false;
                    }
                    catch (Exception ex) {
                        URLMap.warning("Failed to load url " + URLMap.this.url + ": " + ex.getMessage());
                    }
                }
            });
            return null;
        }
        return this.image;
    }

    private void reset() {
        this.image = null;
        this.rendered = false;
        this.loading = false;
        this.sentToPlayers.clear();
    }

    private void sendToPlayer(Player player, MapView mapView) {
        if (this.priority == null || !this.enabled) {
            return;
        }
        String playerName = player.getName();
        if (!this.sentToPlayers.contains(playerName) && Math.random() * (double)this.priority.intValue() <= 1.0) {
            this.sentToPlayers.add(playerName);
            player.sendMap(mapView);
        }
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }
}

