/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utilities;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class NMSUtils {
    protected static String versionPrefix = "";
    protected static Class<?> class_ItemStack;
    protected static Class<?> class_NBTBase;
    protected static Class<?> class_NBTTagCompound;
    protected static Class<?> class_NBTTagList;
    protected static Class<?> class_CraftInventoryCustom;
    protected static Class<?> class_CraftItemStack;
    protected static Class<?> class_CraftLivingEntity;
    protected static Class<?> class_Entity;
    protected static Class<?> class_DataWatcher;
    protected static Class<?> class_World;
    protected static Class<?> class_Packet;
    protected static Class<Enum> class_EnumSkyBlock;
    protected static Class<?> class_PacketPlayOutMapChunkBulk;
    protected static Class<?> class_Packet56MapChunkBulk;
    protected static Class<?> class_Packet63WorldParticles;
    protected static Class<?> class_PacketPlayOutWorldParticles;

    static {
        String className = Bukkit.getServer().getClass().getName();
        String[] packages = className.split("\\.");
        if (packages.length == 5) {
            versionPrefix = String.valueOf(packages[3]) + ".";
        }
        try {
            class_Entity = NMSUtils.fixBukkitClass("net.minecraft.server.Entity");
            class_ItemStack = NMSUtils.fixBukkitClass("net.minecraft.server.ItemStack");
            class_DataWatcher = NMSUtils.fixBukkitClass("net.minecraft.server.DataWatcher");
            class_NBTBase = NMSUtils.fixBukkitClass("net.minecraft.server.NBTBase");
            class_NBTTagCompound = NMSUtils.fixBukkitClass("net.minecraft.server.NBTTagCompound");
            class_NBTTagList = NMSUtils.fixBukkitClass("net.minecraft.server.NBTTagList");
            class_CraftInventoryCustom = NMSUtils.fixBukkitClass("org.bukkit.craftbukkit.inventory.CraftInventoryCustom");
            class_CraftItemStack = NMSUtils.fixBukkitClass("org.bukkit.craftbukkit.inventory.CraftItemStack");
            class_CraftLivingEntity = NMSUtils.fixBukkitClass("org.bukkit.craftbukkit.entity.CraftLivingEntity");
            class_Packet = NMSUtils.fixBukkitClass("net.minecraft.server.Packet");
            class_World = NMSUtils.fixBukkitClass("net.minecraft.server.World");
            class_EnumSkyBlock = NMSUtils.fixBukkitClass("net.minecraft.server.EnumSkyBlock");
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        class_PacketPlayOutMapChunkBulk = NMSUtils.getBukkitClass("net.minecraft.server.PacketPlayOutMapChunkBulk");
        class_Packet56MapChunkBulk = NMSUtils.getBukkitClass("net.minecraft.server.Packet56MapChunkBulk");
        if (class_PacketPlayOutMapChunkBulk == null && class_Packet56MapChunkBulk == null) {
            System.err.println("Could not bind to either PlayOutMapChunk packet version");
        }
        class_PacketPlayOutWorldParticles = NMSUtils.getBukkitClass("net.minecraft.server.PacketPlayOutWorldParticles");
        class_Packet63WorldParticles = NMSUtils.getBukkitClass("net.minecraft.server.Packet63WorldParticles");
        if (class_PacketPlayOutWorldParticles == null && class_Packet63WorldParticles == null) {
            System.err.println("Could not bind to either PlayOutWorldParticles packet version");
        }
    }

    public static Class getBukkitClass(String className) {
        Class<?> ret = null;
        try {
            ret = NMSUtils.fixBukkitClass(className);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret;
    }

    protected static Class<?> fixBukkitClass(String className) {
        className = className.replace("org.bukkit.craftbukkit.", "org.bukkit.craftbukkit." + versionPrefix);
        className = className.replace("net.minecraft.server.", "net.minecraft.server." + versionPrefix);
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    protected static Object getHandle(ItemStack stack) {
        Object handle = null;
        try {
            Field handleField = stack.getClass().getDeclaredField("handle");
            handleField.setAccessible(true);
            handle = handleField.get(stack);
        }
        catch (Throwable ex) {
            handle = null;
        }
        return handle;
    }

    protected static Object getHandle(World world) {
        Object handle = null;
        try {
            Method handleMethod = world.getClass().getMethod("getHandle", new Class[0]);
            handle = handleMethod.invoke((Object)world, new Object[0]);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return handle;
    }

    public static Object getHandle(Entity entity) {
        Object handle = null;
        try {
            Method handleMethod = entity.getClass().getMethod("getHandle", new Class[0]);
            handle = handleMethod.invoke((Object)entity, new Object[0]);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return handle;
    }

    public static boolean isDone(Chunk chunk) {
        Object chunkHandle = NMSUtils.getHandle(chunk);
        boolean done = false;
        try {
            Field doneField = chunkHandle.getClass().getDeclaredField("done");
            doneField.setAccessible(true);
            done = (Boolean)doneField.get(chunkHandle);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return done;
    }

    protected static Object getHandle(Chunk chunk) {
        Object handle = null;
        try {
            Method handleMethod = chunk.getClass().getMethod("getHandle", new Class[0]);
            handle = handleMethod.invoke((Object)chunk, new Object[0]);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return handle;
    }

    protected static Object getHandle(Player player) {
        Object handle = null;
        try {
            Method handleMethod = player.getClass().getMethod("getHandle", new Class[0]);
            handle = handleMethod.invoke((Object)player, new Object[0]);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return handle;
    }

    protected static Object getHandle(Object object) {
        Object handle = null;
        try {
            Method handleMethod = object.getClass().getMethod("getHandle", new Class[0]);
            handle = handleMethod.invoke(object, new Object[0]);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return handle;
    }

    protected static void sendPacket(Location source, Collection<Player> players, Object packet) throws Exception {
        players = players != null && players.size() > 0 ? players : source.getWorld().getPlayers();
        for (Player player : players) {
            if (!(player.getLocation().distanceSquared(source) <= (double)(Bukkit.getServer().getViewDistance() * Bukkit.getServer().getViewDistance()))) continue;
            NMSUtils.sendPacket(player, packet);
        }
    }

    protected static void sendPacket(Player player, Object packet) throws Exception {
        Object playerHandle = NMSUtils.getHandle(player);
        Field connectionField = playerHandle.getClass().getField("playerConnection");
        Object connection = connectionField.get(playerHandle);
        Method sendPacketMethod = connection.getClass().getMethod("sendPacket", class_Packet);
        sendPacketMethod.invoke(connection, packet);
    }
}

