/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.traders;

import com.elmakers.mine.bukkit.plugins.magic.wand.Wand;
import com.elmakers.mine.bukkit.traders.TradersController;
import net.dandielo.citizens.traders_v3.core.exceptions.attributes.AttributeInvalidValueException;
import net.dandielo.citizens.traders_v3.core.exceptions.attributes.AttributeValueNotFoundException;
import net.dandielo.citizens.traders_v3.utils.items.Attribute;
import net.dandielo.citizens.traders_v3.utils.items.ItemAttr;
import org.bukkit.inventory.ItemStack;

@Attribute(name="Wand", key="wand", priority=5)
public class WandItem
extends ItemAttr {
    private String wandKey;

    public WandItem(String key) {
        super(key);
    }

    public void onFactorize(ItemStack itemStack) throws AttributeValueNotFoundException {
        if (Wand.isWand(itemStack)) {
            Wand wand = new Wand(TradersController.getController(), itemStack);
            this.wandKey = wand.getTemplate();
        }
    }

    public void onLoad(String itemKey) throws AttributeInvalidValueException {
        this.wandKey = itemKey;
    }

    public String onSave() {
        return this.wandKey;
    }

    public ItemStack onReturnAssign(ItemStack itemStack, boolean endItem) {
        if (this.wandKey != null && this.wandKey.length() > 0) {
            Wand wand = Wand.createWand(TradersController.getController(), this.wandKey);
            itemStack = wand.getItem();
        }
        return itemStack;
    }
}

