/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.Mage;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.InventoryUtils;
import com.elmakers.mine.bukkit.utilities.Target;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class ForceSpell
extends Spell {
    LivingEntity targetEntity = null;
    private Color effectColor = null;
    private static final int DEFAULT_MAGNITUDE = 3;

    @Override
    public SpellResult onCast(ConfigurationNode parameters) {
        if (this.targetEntity != null && this.targetEntity instanceof LivingEntity) {
            Mage targetMage;
            Location location = this.getLocation();
            World targetWorld = this.targetEntity.getWorld();
            if (!this.targetEntity.isValid() || this.targetEntity.isDead()) {
                this.releaseTarget();
            } else if (targetWorld == null || location == null || !targetWorld.getName().equals(location.getWorld().getName())) {
                this.releaseTarget();
            } else if (location.distanceSquared(this.targetEntity.getLocation()) > (double)this.getMaxRangeSquared()) {
                this.releaseTarget();
            }
            if (this.targetEntity != null && this.targetEntity instanceof Player && (targetMage = this.controller.getMage((Player)this.targetEntity)).isSuperProtected()) {
                this.releaseTarget();
            }
        }
        if (this.targetEntity == null) {
            Mage targetMage;
            Target target = this.getTarget();
            if (!(target != null && target.hasTarget() && target.isEntity() && target.getEntity() instanceof LivingEntity)) {
                this.targetEntity = null;
                return SpellResult.NO_TARGET;
            }
            this.targetEntity = (LivingEntity)target.getEntity();
            if (this.targetEntity instanceof Player && (targetMage = this.controller.getMage((Player)this.targetEntity)).isSuperProtected()) {
                return SpellResult.NO_TARGET;
            }
            this.effectColor = this.mage.getEffectColor();
            if (this.effectColor == null) {
                this.effectColor = Color.fromRGB((int)Integer.parseInt(parameters.getString("effect_color", "FF0000"), 16));
            }
            if (this.effectColor != null) {
                InventoryUtils.addPotionEffect(this.targetEntity, this.effectColor);
            }
            this.castMessage("You capture your target");
            return SpellResult.TARGET_SELECTED;
        }
        double multiplier = parameters.getDouble("size", 1.0);
        int magnitude = parameters.getInt("entity_force", 3);
        this.forceEntity((Entity)this.targetEntity, multiplier, magnitude);
        return SpellResult.CAST;
    }

    protected void forceEntity(Entity target, double multiplier, int magnitude) {
        magnitude = (int)((double)magnitude * multiplier);
        Vector forceVector = this.mage.getLocation().getDirection();
        forceVector.normalize();
        forceVector.multiply(magnitude);
        target.setVelocity(forceVector);
    }

    protected void releaseTarget() {
        if (this.targetEntity != null && this.effectColor != null) {
            InventoryUtils.clearPotionEffect(this.targetEntity);
        }
        this.targetEntity = null;
    }

    @Override
    public boolean onCancel() {
        if (this.targetEntity != null) {
            this.castMessage("Released target");
            this.releaseTarget();
            return true;
        }
        return false;
    }
}

