/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.Target;
import com.elmakers.mine.bukkit.utilities.URLMap;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class CameraSpell
extends Spell {
    @Override
    public SpellResult onCast(ConfigurationNode parameters) {
        String url;
        ItemStack newMapItem = null;
        Integer priority = parameters.getInteger("priority", null);
        if (parameters.containsKey("id")) {
            newMapItem = new ItemStack(Material.MAP, 1, (short)parameters.getInt("id", 0));
            String mapName = parameters.getString("name", "Image");
            ItemMeta meta = newMapItem.getItemMeta();
            meta.setDisplayName(mapName);
            newMapItem.setItemMeta(meta);
        }
        if (newMapItem == null && (url = parameters.getString("url")) != null) {
            int x = parameters.getInt("x", 0);
            int y = parameters.getInt("y", 0);
            int width = parameters.getInt("width", 0);
            int height = parameters.getInt("height", 0);
            String mapName = parameters.getString("name", "Photo");
            newMapItem = URLMap.getURLItem(url, x, y, width, height, mapName, priority);
        }
        if (newMapItem == null) {
            Target target = this.getTarget();
            String playerName = parameters.getString("name");
            String metaName = null;
            if (playerName == null) {
                if (target != null) {
                    if (target.isEntity()) {
                        Entity targetEntity = target.getEntity();
                        if (targetEntity instanceof Player) {
                            playerName = ((Player)targetEntity).getName();
                        } else {
                            playerName = this.getMobSkin(targetEntity.getType());
                            if (playerName != null) {
                                metaName = targetEntity.getType().getName();
                            }
                        }
                    } else {
                        Block targetBlock = target.getBlock();
                        if (targetBlock == null) {
                            return SpellResult.NO_TARGET;
                        }
                        playerName = this.getBlockSkin(targetBlock.getType());
                        if (playerName != null) {
                            metaName = target.getBlock().getType().name();
                        }
                    }
                }
                if (playerName == null) {
                    Player player = this.getPlayer();
                    if (player == null) {
                        return SpellResult.NO_TARGET;
                    }
                    this.castMessage("Selfie!");
                    playerName = player.getName();
                } else {
                    this.castMessage("CLICK!");
                }
            }
            if (parameters.containsKey("reload")) {
                URLMap.forceReloadPlayerPortrait(playerName);
            }
            newMapItem = URLMap.getPlayerPortrait(playerName, priority, metaName);
        }
        if (newMapItem == null) {
            this.sendMessage("Failed to load photo");
            return SpellResult.FAIL;
        }
        this.getWorld().dropItemNaturally(this.getLocation(), newMapItem);
        return SpellResult.CAST;
    }
}

