/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic;

import com.elmakers.mine.bukkit.blocks.BlockList;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;

public abstract class BlockSpell
extends Spell {
    private Set<Material> indestructible;
    private Set<Material> destructible;
    private boolean checkDestructible = true;
    private boolean bypassUndo = false;

    private boolean isIndestructible(Block block) {
        if (this.indestructible == null) {
            return this.mage.isIndestructible(block);
        }
        return this.indestructible.contains(block.getType()) || this.mage.isIndestructible(block);
    }

    public boolean isDestructible(Block block) {
        if (this.isIndestructible(block)) {
            return false;
        }
        if (!this.checkDestructible) {
            return true;
        }
        if (this.destructible == null) {
            return this.mage.isDestructible(block);
        }
        return this.destructible.contains(block.getType());
    }

    protected void setDestructible(Set<Material> materials) {
        this.checkDestructible = true;
        this.destructible = materials;
    }

    @Override
    protected void processParameters(ConfigurationNode parameters) {
        super.processParameters(parameters);
        this.indestructible = null;
        if (parameters.containsKey("indestructible")) {
            this.indestructible = parameters.getMaterials("indestructible", "");
        }
        if (parameters.containsKey("id")) {
            this.indestructible = parameters.getMaterials("id", "");
        }
        this.destructible = null;
        if (parameters.containsKey("destructible")) {
            this.destructible = this.controller.getMaterialSet(parameters.getString("destructible"));
        }
        this.checkDestructible = parameters.getBoolean("check_destructible", true);
        this.checkDestructible = parameters.getBoolean("cd", this.checkDestructible);
        this.bypassUndo = parameters.getBoolean("bypass_undo", false);
        this.bypassUndo = parameters.getBoolean("bu", this.bypassUndo);
    }

    public void registerForUndo(BlockList list) {
        if (!this.bypassUndo) {
            this.mage.registerForUndo(list);
        }
    }
}

