/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.blocks;

import com.elmakers.mine.bukkit.blocks.MaterialAndData;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.CuboidClipboard;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.blocks.ChestBlock;
import com.sk89q.worldedit.blocks.SignBlock;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;

public class Schematic {
    private final CuboidClipboard weSchematic;
    private org.bukkit.util.Vector center;
    private org.bukkit.util.Vector size;

    public Schematic(Object schematic) {
        this.weSchematic = (CuboidClipboard)schematic;
        try {
            Vector weSize = this.weSchematic.getSize();
            this.size = new org.bukkit.util.Vector(weSize.getBlockX(), weSize.getBlockY(), weSize.getBlockZ());
            this.center = new org.bukkit.util.Vector(Math.floor(this.size.getBlockX() / 2), 0.0, Math.floor(this.size.getBlockZ() / 2));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (this.center == null) {
            this.center = new org.bukkit.util.Vector(0, 0, 0);
        }
        if (this.size == null) {
            this.size = new org.bukkit.util.Vector(0, 0, 0);
        }
    }

    public boolean contains(org.bukkit.util.Vector v) {
        int x = v.getBlockX() + this.center.getBlockX();
        int y = v.getBlockY() + this.center.getBlockY();
        int z = v.getBlockZ() + this.center.getBlockZ();
        return x >= 0 && x <= this.size.getBlockX() && y >= 0 && y <= this.size.getBlockY() && z >= 0 && z <= this.size.getBlockZ();
    }

    public MaterialAndData getBlock(org.bukkit.util.Vector v) {
        int x = v.getBlockX() + this.center.getBlockX();
        int y = v.getBlockY() + this.center.getBlockY();
        int z = v.getBlockZ() + this.center.getBlockZ();
        try {
            Vector vector = new Vector(x, y, z);
            BaseBlock baseBlock = this.weSchematic.getBlock(vector);
            Material material = Material.getMaterial((int)baseBlock.getId());
            int materialData = baseBlock.getData();
            MaterialAndData blockData = new MaterialAndData(material, (byte)materialData);
            if (material == Material.SIGN_POST || material == Material.WALL_SIGN) {
                try {
                    if (baseBlock.hasNbtData()) {
                        SignBlock signBlock = new SignBlock(material.getId(), materialData);
                        CompoundTag nbtData = baseBlock.getNbtData();
                        signBlock.setNbtData(nbtData);
                        blockData.setSignLines(signBlock.getText());
                    }
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            } else if (material == Material.COMMAND) {
                try {
                    CompoundTag nbtRoot;
                    Map rootValues;
                    if (baseBlock.hasNbtData() && (rootValues = (nbtRoot = baseBlock.getNbtData()).getValue()).containsKey("Command")) {
                        Object commandValue = ((Tag)rootValues.get("Command")).getValue();
                        blockData.setCommandLine((String)commandValue);
                    }
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            } else if (material == Material.CHEST) {
                try {
                    if (baseBlock.hasNbtData()) {
                        ChestBlock chestBlock = new ChestBlock(materialData);
                        CompoundTag nbtRoot = baseBlock.getNbtData();
                        chestBlock.setNbtData(nbtRoot);
                        BaseItemStack[] items = chestBlock.getItems();
                        if (items != null && items.length > 0) {
                            ItemStack[] contents = new ItemStack[items.length];
                            int i = 0;
                            while (i < items.length) {
                                if (items[i] != null) {
                                    Material itemMaterial = Material.getMaterial((int)items[i].getType());
                                    short itemData = items[i].getData();
                                    int itemAmount = items[i].getAmount();
                                    ItemStack newStack = new ItemStack(itemMaterial, itemAmount, itemData);
                                    Map enchantments = items[i].getEnchantments();
                                    if (enchantments != null && enchantments.size() > 0) {
                                        for (Map.Entry enchantment : enchantments.entrySet()) {
                                            try {
                                                Enchantment enchantmentType = Enchantment.getById((int)((Integer)enchantment.getKey()));
                                                newStack.addEnchantment(enchantmentType, ((Integer)enchantment.getValue()).intValue());
                                            }
                                            catch (Exception exception) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                    contents[i] = newStack;
                                }
                                ++i;
                            }
                            blockData.setInventoryContents(contents);
                        }
                    }
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
            return blockData;
        }
        catch (ArrayIndexOutOfBoundsException vector) {
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return null;
    }
}

