/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.blocks;

import com.elmakers.mine.bukkit.blocks.BlockList;
import com.elmakers.mine.bukkit.blocks.MaterialBrush;
import com.elmakers.mine.bukkit.blocks.VolumeBatch;
import com.elmakers.mine.bukkit.plugins.magic.BrushSpell;
import com.elmakers.mine.bukkit.plugins.magic.Mage;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.FallingBlock;
import org.bukkit.util.Vector;

public class FillBatch
extends VolumeBatch {
    private final BlockList filledBlocks = new BlockList();
    private final MaterialBrush brush;
    private final World world;
    private final Mage mage;
    private final int absx;
    private final int absy;
    private final int absz;
    private final int dx;
    private final int dy;
    private final int dz;
    private final int x;
    private final int y;
    private final int z;
    private int ix = 0;
    private int iy = 0;
    private int iz = 0;
    private boolean spawnFallingBlocks = false;
    private Vector fallingBlockVelocity = null;

    public FillBatch(BrushSpell spell, Location p1, Location p2, MaterialBrush brush) {
        super(spell.getMage().getController(), p1.getWorld().getName());
        this.brush = brush;
        this.mage = spell.getMage();
        this.world = this.mage.getPlayer().getWorld();
        int deltax = p2.getBlockX() - p1.getBlockX();
        int deltay = p2.getBlockY() - p1.getBlockY();
        int deltaz = p2.getBlockZ() - p1.getBlockZ();
        this.absx = Math.abs(deltax) + 1;
        this.absy = Math.abs(deltay) + 1;
        this.absz = Math.abs(deltaz) + 1;
        this.dx = (int)Math.signum(deltax);
        this.dy = (int)Math.signum(deltay);
        this.dz = (int)Math.signum(deltaz);
        this.x = p1.getBlockX();
        this.y = p1.getBlockY();
        this.z = p1.getBlockZ();
    }

    public boolean checkDimension(int maxDimension) {
        return maxDimension <= 0 || this.absx <= maxDimension && this.absy <= maxDimension && this.absz <= maxDimension;
    }

    public boolean checkVolume(int maxVolume) {
        return maxVolume <= 0 || this.absx * this.absy * this.absz <= maxVolume;
    }

    @Override
    public int process(int maxBlocks) {
        int processedBlocks = 0;
        while (processedBlocks <= maxBlocks && this.ix < this.absx) {
            Block block = this.world.getBlockAt(this.x + this.ix * this.dx, this.y + this.iy * this.dy, this.z + this.iz * this.dz);
            this.brush.update(this.mage, block.getLocation());
            if (!block.getChunk().isLoaded()) {
                block.getChunk().load();
                return processedBlocks;
            }
            if (!this.brush.isReady()) {
                this.brush.prepare();
                return processedBlocks;
            }
            ++processedBlocks;
            if (this.mage.hasBuildPermission(block) && !this.mage.isIndestructible(block)) {
                Material previousMaterial = block.getType();
                byte previousData = block.getData();
                if (this.brush.isDifferent(block)) {
                    this.updateBlock(this.world.getName(), this.x, this.y, this.z);
                    this.filledBlocks.add(block);
                    this.brush.modify(block);
                    if (this.spawnFallingBlocks) {
                        FallingBlock falling = block.getWorld().spawnFallingBlock(block.getLocation(), previousMaterial, previousData);
                        falling.setDropItem(false);
                        if (this.fallingBlockVelocity != null) {
                            falling.setVelocity(this.fallingBlockVelocity);
                        }
                    }
                }
            }
            ++this.iy;
            if (this.iy < this.absy) continue;
            this.iy = 0;
            ++this.iz;
            if (this.iz < this.absz) continue;
            this.iz = 0;
            ++this.ix;
        }
        if (this.ix >= this.absx) {
            this.finish();
        }
        return processedBlocks;
    }

    @Override
    public void finish() {
        if (!this.finished) {
            super.finish();
            this.mage.registerForUndo(this.filledBlocks);
            this.mage.castMessage("Filled " + this.getXSize() + "x" + this.getYSize() + "x" + this.getZSize() + " area with " + this.brush.getMaterial().name().toLowerCase());
        }
    }

    public int getXSize() {
        return this.absx;
    }

    public int getYSize() {
        return this.absy;
    }

    public int getZSize() {
        return this.absz;
    }

    public void setTimeToLive(int timeToLive) {
        this.filledBlocks.setTimeToLive(timeToLive);
    }
}

