/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.blocks;

import com.elmakers.mine.bukkit.blocks.MaterialAndData;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.util.BlockVector;

public class BlockData
extends MaterialAndData {
    public static final BlockFace[] FACES = new BlockFace[]{BlockFace.WEST, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.UP, BlockFace.DOWN};
    public static final BlockFace[] SIDES = new BlockFace[]{BlockFace.WEST, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST};
    protected Block block;
    protected BlockVector location;
    protected String world;
    protected static Server server;

    public static void setServer(Server server) {
        BlockData.server = server;
    }

    public static long getBlockId(Block block) {
        return block.getWorld().getName().hashCode() << 28 ^ Integer.valueOf(block.getX()).hashCode() << 13 ^ Integer.valueOf(block.getY()).hashCode() << 7 ^ Integer.valueOf(block.getZ()).hashCode();
    }

    public long getId() {
        return this.world.hashCode() << 28 ^ Integer.valueOf(this.location.getBlockX()).hashCode() << 13 ^ Integer.valueOf(this.location.getBlockY()).hashCode() << 7 ^ Integer.valueOf(this.location.getBlockZ()).hashCode();
    }

    public static BlockFace getReverseFace(BlockFace blockFace) {
        switch (blockFace) {
            case NORTH: {
                return BlockFace.SOUTH;
            }
            case WEST: {
                return BlockFace.EAST;
            }
            case SOUTH: {
                return BlockFace.NORTH;
            }
            case EAST: {
                return BlockFace.WEST;
            }
            case UP: {
                return BlockFace.DOWN;
            }
            case DOWN: {
                return BlockFace.UP;
            }
        }
        return BlockFace.SELF;
    }

    public BlockData() {
    }

    public BlockData(Block block) {
        this.updateFrom(block);
        this.block = block;
        this.location = new BlockVector(block.getX(), block.getY(), block.getZ());
        this.world = block.getWorld().getName();
    }

    public BlockData(BlockData copy) {
        super(copy);
        this.location = copy.location;
        this.world = copy.world;
        this.block = copy.block;
    }

    public BlockData(Location location, Material material, byte data) {
        super(material, data);
        this.location = new BlockVector(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        this.world = location.getWorld().getName();
    }

    public BlockData(int x, int y, int z, String world, Material material, byte data) {
        super(material, data);
        this.location = new BlockVector(x, y, z);
        this.world = world;
    }

    protected boolean checkBlock() {
        if (this.block == null) {
            this.block = this.getBlock();
        }
        return this.block != null;
    }

    public Block getBlock() {
        Location blockLocation;
        if (this.block == null && this.location != null && server != null && (blockLocation = new Location(server.getWorld(this.world), (double)this.location.getBlockX(), (double)this.location.getBlockY(), (double)this.location.getBlockZ())) != null) {
            this.block = blockLocation.getBlock();
        }
        return this.block;
    }

    public BlockVector getPosition() {
        return this.location;
    }

    public void setPosition(BlockVector location) {
        this.location = location;
    }

    public boolean undo() {
        if (!this.checkBlock()) {
            return true;
        }
        Chunk chunk = this.block.getChunk();
        if (!chunk.isLoaded()) {
            chunk.load();
            return false;
        }
        if (this.isDifferent(this.block)) {
            this.modify(this.block);
        }
        return true;
    }

    public String toString() {
        return String.valueOf(this.location.getBlockX()) + "," + this.location.getBlockY() + "," + this.location.getBlockZ() + "," + this.world + "|" + this.getMaterial().getId() + ":" + this.getData();
    }

    public static BlockData fromString(String s) {
        BlockData result = null;
        if (s == null) {
            return null;
        }
        try {
            String[] pieces = StringUtils.split((String)s, (char)'|');
            String[] locationPieces = StringUtils.split((String)pieces[0], (char)',');
            int x = Integer.parseInt(locationPieces[0]);
            int y = Integer.parseInt(locationPieces[1]);
            int z = Integer.parseInt(locationPieces[2]);
            String world = locationPieces[3];
            String[] materialPieces = StringUtils.split((String)pieces[1], (char)':');
            int materialId = Integer.parseInt(materialPieces[0]);
            byte dataId = Byte.parseByte(materialPieces[1]);
            return new BlockData(x, y, z, world, Material.getMaterial((int)materialId), dataId);
        }
        catch (Exception exception) {
            return result;
        }
    }

    public String getWorldName() {
        return this.world;
    }
}

