/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.wand;

import com.elmakers.mine.bukkit.blocks.MaterialBrush;
import com.elmakers.mine.bukkit.plugins.magic.BrushSpell;
import com.elmakers.mine.bukkit.plugins.magic.CastingCost;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.wand.Wand;
import com.elmakers.mine.bukkit.utilities.RandomUtils;
import com.elmakers.mine.bukkit.utilities.WeightedPair;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WandLevel {
    private static TreeMap<Integer, WandLevel> levelMap = null;
    private static int[] levels = null;
    private final LinkedList<WeightedPair<Integer>> spellCountProbability = new LinkedList();
    private final LinkedList<WeightedPair<Integer>> materialCountProbability = new LinkedList();
    private final LinkedList<WeightedPair<String>> spellProbability = new LinkedList();
    private final LinkedList<WeightedPair<String>> materialProbability = new LinkedList();
    private final LinkedList<WeightedPair<Integer>> useProbability = new LinkedList();
    private final LinkedList<WeightedPair<Integer>> addUseProbability = new LinkedList();
    private final LinkedList<WeightedPair<Integer>> propertyCountProbability = new LinkedList();
    private final LinkedList<WeightedPair<Float>> costReductionProbability = new LinkedList();
    private final LinkedList<WeightedPair<Float>> powerProbability = new LinkedList();
    private final LinkedList<WeightedPair<Float>> damageReductionProbability = new LinkedList();
    private final LinkedList<WeightedPair<Float>> damageReductionPhysicalProbability = new LinkedList();
    private final LinkedList<WeightedPair<Float>> damageReductionProjectilesProbability = new LinkedList();
    private final LinkedList<WeightedPair<Float>> damageReductionFallingProbability = new LinkedList();
    private final LinkedList<WeightedPair<Float>> damageReductionFireProbability = new LinkedList();
    private final LinkedList<WeightedPair<Float>> damageReductionExplosionsProbability = new LinkedList();
    private final LinkedList<WeightedPair<Integer>> xpRegenerationProbability = new LinkedList();
    private final LinkedList<WeightedPair<Integer>> xpMaxProbability = new LinkedList();
    private final LinkedList<WeightedPair<Integer>> healthRegenerationProbability = new LinkedList();
    private final LinkedList<WeightedPair<Integer>> hungerRegenerationProbability = new LinkedList();
    private final LinkedList<WeightedPair<Float>> hasteProbability = new LinkedList();
    public static final int maxUses = 500;
    public static final int maxMaxXp = 1000;
    public static final int maxXpRegeneration = 50;
    public static final int maxRegeneration = 5;
    public static final float maxReduction = 0.9f;
    public static final float maxProtection = 0.9f;
    public static float maxFlySpeedIncrease = 0.1f;
    public static float maxWalkSpeedIncrease = 0.4f;
    public static float maxFlySpeed = 0.8f;
    public static float maxWalkSpeed = 0.8f;
    public static float maxPower = 1.0f;

    public static WandLevel getLevel(int level) {
        if (levelMap == null) {
            return null;
        }
        if (!levelMap.containsKey(level)) {
            if (level > levelMap.lastKey()) {
                return levelMap.lastEntry().getValue();
            }
            return levelMap.firstEntry().getValue();
        }
        return levelMap.get(level);
    }

    public static void mapLevels(ConfigurationNode template) {
        levelMap = new TreeMap();
        String[] levelStrings = StringUtils.split((String)template.getString("levels"), (String)",");
        levels = new int[levelStrings.length];
        int i = 0;
        while (i < levels.length) {
            WandLevel.levels[i] = Integer.parseInt(levelStrings[i]);
            ++i;
        }
        int level = 1;
        while (level <= levels[levels.length - 1]) {
            levelMap.put(level, new WandLevel(level, template));
            ++level;
        }
    }

    private WandLevel(int level, ConfigurationNode template) {
        int levelIndex = 0;
        int nextLevelIndex = 0;
        float distance = 1.0f;
        levelIndex = 0;
        while (levelIndex < levels.length) {
            if (level == levels[levelIndex] || levelIndex == levels.length - 1) {
                nextLevelIndex = levelIndex;
                distance = 0.0f;
                break;
            }
            if (level > levels[levelIndex]) {
                nextLevelIndex = levelIndex + 1;
                int previousLevel = levels[levelIndex];
                int nextLevel = levels[nextLevelIndex];
                distance = (float)(level - previousLevel) / (float)(nextLevel - previousLevel);
            }
            ++levelIndex;
        }
        RandomUtils.populateStringProbabilityMap(this.spellProbability, template.getNode("spells"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.spellCountProbability, template.getNode("spell_count"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateStringProbabilityMap(this.materialProbability, template.getNode("materials"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.materialCountProbability, template.getNode("material_count"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.useProbability, template.getNode("uses"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.addUseProbability, template.getNode("add_uses"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.propertyCountProbability, template.getNode("property_count"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.costReductionProbability, template.getNode("cost_reduction"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.damageReductionProbability, template.getNode("protection"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.damageReductionPhysicalProbability, template.getNode("protection_physical"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.damageReductionFallingProbability, template.getNode("protection_falling"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.damageReductionProjectilesProbability, template.getNode("protection_projectiles"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.damageReductionFireProbability, template.getNode("protection_fire"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.damageReductionExplosionsProbability, template.getNode("protection_explosions"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.xpRegenerationProbability, template.getNode("xp_regeneration"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.xpMaxProbability, template.getNode("xp_max"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.healthRegenerationProbability, template.getNode("health_regeneration"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.hungerRegenerationProbability, template.getNode("hunger_regeneration"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.hasteProbability, template.getNode("haste"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.powerProbability, template.getNode("power"), levelIndex, nextLevelIndex, distance);
    }

    /*
     * Handled impossible loop by duplicating code
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private boolean randomizeWand(Wand wand, boolean additive) {
        double costReduction;
        ConfigurationNode configurationNode;
        boolean addedMaterials;
        int maxXpCost;
        void var6_10;
        boolean addedSpells;
        block40: {
            Integer n;
            void v0;
            void var13_25;
            block39: {
                addedSpells = false;
                Set<String> wandSpells = wand.getSpells();
                LinkedList remainingSpells = new LinkedList();
                for (WeightedPair weightedPair : this.spellProbability) {
                    if (wandSpells.contains(weightedPair.getValue())) continue;
                    remainingSpells.add(weightedPair);
                }
                Object var6_9 = null;
                if (remainingSpells.size() > 0) {
                    Integer spellCount = (Integer)RandomUtils.weightedRandom(this.spellCountProbability);
                    int retries = 10;
                    int i = 0;
                    while (i < spellCount) {
                        String spellKey = (String)RandomUtils.weightedRandom(remainingSpells);
                        if (wand.addSpell(spellKey, false)) {
                            if (var6_10 == null) {
                                Spell spell = wand.getMaster().getSpell(spellKey);
                            }
                            addedSpells = true;
                        } else if (retries-- > 0) {
                            --i;
                        }
                        ++i;
                    }
                }
                boolean needsMaterials = false;
                maxXpCost = 0;
                Set<String> spells = wand.getSpells();
                for (String spellName : spells) {
                    Spell spell = wand.getMaster().getSpell(spellName);
                    if (spell == null) continue;
                    needsMaterials = needsMaterials || spell instanceof BrushSpell && !((BrushSpell)spell).hasBrushOverride();
                    List<CastingCost> list = spell.getCosts();
                    if (list == null) continue;
                    for (CastingCost castingCost : list) {
                        maxXpCost = Math.max(maxXpCost, castingCost.getXP());
                    }
                }
                addedMaterials = false;
                Set<String> wandMaterials = wand.getMaterialKeys();
                LinkedList remainingMaterials = new LinkedList();
                for (WeightedPair weightedPair : this.materialProbability) {
                    String materialKey = (String)weightedPair.getValue();
                    materialKey = materialKey.replace("|", ":");
                    if (wandMaterials.contains(weightedPair.getValue()) || !MaterialBrush.isValidMaterial(materialKey)) continue;
                    remainingMaterials.add(weightedPair);
                }
                if (needsMaterials && remainingMaterials.size() > 0) {
                    void var14_30;
                    int n2 = wand.getMaterialKeys().size();
                    Integer n3 = (Integer)RandomUtils.weightedRandom(this.materialCountProbability);
                    if (n2 == 0) {
                        Integer n4 = Math.max(1, n3);
                    }
                    int retries = 100;
                    int i = 0;
                    while (i < var14_30.intValue()) {
                        String materialKey = (String)RandomUtils.weightedRandom(remainingMaterials);
                        if (!wand.addMaterial(materialKey = materialKey.replace("|", ":"), false, false)) {
                            if (retries-- > 0) {
                                --i;
                            }
                        } else {
                            addedMaterials = true;
                        }
                        ++i;
                    }
                }
                Integer n5 = (Integer)RandomUtils.weightedRandom(this.propertyCountProbability);
                configurationNode = new ConfigurationNode();
                costReduction = wand.getCostReduction();
                if (!true) break block39;
                v0 = var13_25;
                n = v0.intValue() - 1;
                if (v0.intValue() <= 0) break block40;
            }
            do {
                int randomProperty = (int)(Math.random() * 10.0);
                switch (randomProperty) {
                    case 0: {
                        if (!(costReduction < (double)0.9f)) break;
                        costReduction = Math.min((double)0.9f, costReduction + (double)((Float)RandomUtils.weightedRandom(this.costReductionProbability)).floatValue());
                        configurationNode.setProperty("cost_reduction", costReduction);
                        break;
                    }
                    case 1: {
                        float power = wand.getPower();
                        if (!(power < maxPower)) break;
                        configurationNode.setProperty("power", Math.min(maxPower, power + ((Float)RandomUtils.weightedRandom(this.powerProbability)).floatValue()));
                        break;
                    }
                    case 2: {
                        float damageReduction = wand.getDamageReduction();
                        if (!(damageReduction < 0.9f)) break;
                        configurationNode.setProperty("protection", Math.min(0.9f, damageReduction + ((Float)RandomUtils.weightedRandom(this.damageReductionProbability)).floatValue()));
                        break;
                    }
                    case 3: {
                        float damageReductionPhysical = wand.getDamageReductionPhysical();
                        if (!(damageReductionPhysical < 0.9f)) break;
                        configurationNode.setProperty("protection_physical", Math.min(0.9f, damageReductionPhysical + ((Float)RandomUtils.weightedRandom(this.damageReductionPhysicalProbability)).floatValue()));
                        break;
                    }
                    case 4: {
                        float damageReductionProjectiles = wand.getDamageReductionProjectiles();
                        if (!(damageReductionProjectiles < 0.9f)) break;
                        configurationNode.setProperty("protection_projectiles", Math.min(0.9f, damageReductionProjectiles + ((Float)RandomUtils.weightedRandom(this.damageReductionProjectilesProbability)).floatValue()));
                        break;
                    }
                    case 5: {
                        float damageReductionFalling = wand.getDamageReductionFalling();
                        if (!(damageReductionFalling < 0.9f)) break;
                        configurationNode.setProperty("protection_falling", Math.min(0.9f, damageReductionFalling + ((Float)RandomUtils.weightedRandom(this.damageReductionFallingProbability)).floatValue()));
                        break;
                    }
                    case 6: {
                        float damageReductionFire = wand.getDamageReductionFire();
                        if (!(damageReductionFire < 0.9f)) break;
                        configurationNode.setProperty("protection_fire", Math.min(0.9f, damageReductionFire + ((Float)RandomUtils.weightedRandom(this.damageReductionFireProbability)).floatValue()));
                        break;
                    }
                    case 7: {
                        float damageReductionExplosions = wand.getDamageReductionExplosions();
                        if (!(damageReductionExplosions < 0.9f)) break;
                        configurationNode.setProperty("protection_explosions", Math.min(0.9f, damageReductionExplosions + ((Float)RandomUtils.weightedRandom(this.damageReductionExplosionsProbability)).floatValue()));
                        break;
                    }
                    case 10: {
                        int healthRegeneration = wand.getHealthRegeneration();
                        if (healthRegeneration >= 5) break;
                        configurationNode.setProperty("health_regeneration", Math.min(5, healthRegeneration + (Integer)RandomUtils.weightedRandom(this.healthRegenerationProbability)));
                        break;
                    }
                    case 11: {
                        int hungerRegeneration = wand.getHungerRegeneration();
                        if (hungerRegeneration >= 5) break;
                        configurationNode.setProperty("hunger_regeneration", Math.min(5, hungerRegeneration + (Integer)RandomUtils.weightedRandom(this.hungerRegenerationProbability)));
                        break;
                    }
                }
                v0 = var13_25;
                n = v0.intValue() - 1;
            } while (v0.intValue() > 0);
        }
        if (costReduction >= 1.0) {
            configurationNode.setProperty("xp_regeneration", 0);
            configurationNode.setProperty("xp_max", 0);
            configurationNode.setProperty("xp", 0);
        } else {
            int xpMax;
            int xpRegeneration = wand.getXpRegeneration();
            if (xpRegeneration < 50) {
                configurationNode.setProperty("xp_regeneration", Math.min(50, xpRegeneration + (Integer)RandomUtils.weightedRandom(this.xpRegenerationProbability)));
            }
            if ((xpMax = wand.getXpMax()) < 1000) {
                xpMax = Math.min(1000, xpMax + (Integer)RandomUtils.weightedRandom(this.xpMaxProbability));
                xpMax = Math.max(maxXpCost, xpMax);
                configurationNode.setProperty("xp_max", xpMax);
            }
            configurationNode.setProperty("xp", xpMax);
        }
        if (additive) {
            int wandUses = wand.getUses();
            if (wandUses > 0 && wandUses < 500) {
                configurationNode.setProperty("uses", Math.min(500, wandUses + (Integer)RandomUtils.weightedRandom(this.addUseProbability)));
            }
        } else {
            configurationNode.setProperty("uses", Math.min(500, (Integer)RandomUtils.weightedRandom(this.useProbability)));
            String spellName = "Nothing";
            if (var6_10 != null) {
                spellName = var6_10.getName();
            }
            String updatedName = wand.getName();
            wand.setName(updatedName.replace("{Spell}", spellName));
        }
        wand.configureProperties(configurationNode);
        return addedMaterials || addedSpells;
    }

    public static boolean randomizeWand(Wand wand, boolean additive, int level) {
        WandLevel wandLevel = WandLevel.getLevel(level);
        return wandLevel.randomizeWand(wand, additive);
    }

    public static Set<Integer> getLevels() {
        if (levels == null) {
            return null;
        }
        return levelMap.keySet();
    }

    public static int getMaxLevel() {
        if (levels == null) {
            return 0;
        }
        return levels[levels.length - 1];
    }
}

