/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.blocks.BlockList;
import com.elmakers.mine.bukkit.plugins.magic.BlockSpell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.Target;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;

public class SignSpell
extends BlockSpell {
    public SpellResult onCast(ConfigurationNode parameters) {
        String typeString = parameters.getString("type", "");
        if (typeString.equals("give")) {
            this.castMessage("Have some signs!");
            return this.giveMaterial(Material.SIGN, 8, (short)0, (byte)0) ? SpellResult.CAST : SpellResult.FAIL;
        }
        Target target = this.getTarget();
        if (target.isBlock()) {
            Block targetBlock = this.getFaceBlock();
            if (!this.hasBuildPermission(targetBlock)) {
                return SpellResult.INSUFFICIENT_PERMISSION;
            }
            if (targetBlock.getRelative(BlockFace.DOWN).getType() == Material.AIR) {
                targetBlock.setType(Material.WALL_SIGN);
                switch (target.getBlock().getFace(targetBlock)) {
                    case EAST: {
                        targetBlock.setData((byte)2);
                        break;
                    }
                    case WEST: {
                        targetBlock.setData((byte)3);
                        break;
                    }
                    case NORTH: {
                        targetBlock.setData((byte)4);
                        break;
                    }
                    case SOUTH: {
                        targetBlock.setData((byte)5);
                        break;
                    }
                    default: {
                        targetBlock.setData((byte)0);
                        break;
                    }
                }
            } else {
                targetBlock.setType(Material.SIGN_POST);
                float yaw = this.getLocation().getYaw();
                yaw = yaw < 180.0f ? yaw + 180.0f : yaw - 180.0f;
                targetBlock.setData((byte)(yaw * 15.0f / 360.0f));
            }
            if (targetBlock.getState() instanceof Sign) {
                Sign sign = (Sign)targetBlock.getState();
                String playerName = this.getPlayer().getName();
                playerName = String.valueOf(this.mage.getController().getMessagePrefix()) + playerName;
                sign.setLine(0, playerName);
                sign.setLine(1, "was here");
                Date currentDate = new Date();
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
                sign.setLine(2, dateFormat.format(currentDate));
                sign.setLine(3, timeFormat.format(currentDate));
                sign.update();
                this.castMessage("You leave a tag");
                BlockList signBlocks = new BlockList();
                signBlocks.add(targetBlock);
                this.registerForUndo(signBlocks);
                this.controller.updateBlock(targetBlock);
                return SpellResult.CAST;
            }
            this.sendMessage("Sign placement failed!");
            return SpellResult.FAIL;
        }
        if (target.isEntity() && target.getEntity() instanceof Player) {
            Player targetPlayer = (Player)target.getEntity();
            targetPlayer.sendMessage(String.valueOf(this.getPlayer().getName()) + " says hi!");
            this.sendMessage("You send " + targetPlayer.getName() + " a message");
            return SpellResult.CAST;
        }
        return SpellResult.NO_TARGET;
    }
}

