/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.blocks.BlockList;
import com.elmakers.mine.bukkit.blocks.BoundingBox;
import com.elmakers.mine.bukkit.plugins.magic.BlockSpell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public class PortalSpell
extends BlockSpell {
    public SpellResult onCast(ConfigurationNode parameters) {
        Block target = this.getTargetBlock();
        if (target == null) {
            this.castMessage("No target");
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(target)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        Material blockType = target.getType();
        Block portalBase = target.getRelative(BlockFace.UP);
        blockType = portalBase.getType();
        if (blockType != Material.AIR) {
            portalBase = this.getFaceBlock();
        }
        if ((blockType = portalBase.getType()) != Material.AIR && blockType != Material.SNOW) {
            this.castMessage("Can't create a portal there");
            return SpellResult.NO_TARGET;
        }
        int timeToLive = parameters.getInt("undo", 5000);
        BlockList portalBlocks = new BlockList();
        portalBlocks.setTimeToLive(timeToLive);
        this.controller.disablePhysics(1000);
        this.buildPortalBlocks(portalBase.getLocation(), BlockFace.NORTH, portalBlocks);
        this.registerForUndo(portalBlocks);
        return SpellResult.CAST;
    }

    protected void buildPortalBlocks(Location centerBlock, BlockFace facing, BlockList blockList) {
        Set<Material> destructible = this.mage.getController().getDestructibleMaterials();
        BoundingBox container = new BoundingBox(centerBlock.getBlockX(), centerBlock.getBlockY(), centerBlock.getBlockZ(), centerBlock.getBlockX() + 2, centerBlock.getBlockY() + 3, centerBlock.getBlockZ() + 1);
        container.fill(centerBlock.getWorld(), Material.PORTAL, destructible, blockList);
    }
}

