/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.blocks.BlockList;
import com.elmakers.mine.bukkit.blocks.FillBatch;
import com.elmakers.mine.bukkit.blocks.MaterialBrush;
import com.elmakers.mine.bukkit.plugins.magic.BrushSpell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.plugins.magic.TargetType;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;

public class FillSpell
extends BrushSpell {
    private static final int DEFAULT_MAX_DIMENSION = 128;
    private Block targetBlock = null;

    public SpellResult onCast(ConfigurationNode parameters) {
        boolean singleBlock;
        Block targetBlock = this.getTargetBlock();
        boolean bl = singleBlock = this.getTargetType() != TargetType.SELECT;
        if (targetBlock == null) {
            this.castMessage("No target");
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(targetBlock)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        MaterialBrush buildWith = this.getMaterialBrush();
        if (singleBlock) {
            this.deactivate();
            BlockList filledBlocks = new BlockList();
            filledBlocks.setTimeToLive(parameters.getInt("undo", 0));
            filledBlocks.add(targetBlock);
            buildWith.setTarget(targetBlock.getLocation());
            buildWith.update(this.mage, targetBlock.getLocation());
            buildWith.modify(targetBlock);
            this.controller.updateBlock(targetBlock);
            Material material = buildWith.getMaterial();
            this.castMessage("Painting with " + material.name().toLowerCase());
            this.registerForUndo(filledBlocks);
            return SpellResult.CAST;
        }
        Double ftxValue = parameters.getDouble("ftx", null);
        Double ftyValue = parameters.getDouble("fty", null);
        Double ftzValue = parameters.getDouble("ftz", null);
        if (ftxValue != null && ftzValue != null && ftyValue != null) {
            Location targetLocation = this.getLocation();
            targetLocation = new Location(targetLocation.getWorld(), ftxValue.doubleValue(), ftyValue.doubleValue(), ftzValue.doubleValue(), targetLocation.getYaw(), targetLocation.getPitch());
            this.targetBlock = targetLocation.getBlock();
        }
        if (this.targetBlock != null) {
            Location centerLocation = targetBlock.getLocation();
            Location secondLocation = this.targetBlock.getLocation();
            centerLocation.setX(Math.floor((centerLocation.getX() + secondLocation.getX()) / 2.0));
            centerLocation.setY(Math.floor((centerLocation.getY() + secondLocation.getY()) / 2.0));
            centerLocation.setZ(Math.floor((centerLocation.getZ() + secondLocation.getZ()) / 2.0));
            buildWith.setTarget(this.targetBlock.getLocation(), centerLocation);
            FillBatch batch = new FillBatch(this, secondLocation, targetBlock.getLocation(), buildWith);
            int maxDimension = parameters.getInteger("max_dimension", 128);
            maxDimension = (int)(this.mage.getConstructionMultiplier() * (float)maxDimension);
            if (!batch.checkDimension(maxDimension)) {
                this.sendMessage("Dimension is too big!");
                return SpellResult.FAIL;
            }
            this.mage.addPendingBlockBatch(batch);
            this.deactivate();
            return SpellResult.CAST;
        }
        this.targetBlock = targetBlock;
        this.activate();
        Material material = buildWith.getMaterial();
        this.castMessage("Cast again to fill with " + material.name().toLowerCase());
        return SpellResult.TARGET_SELECTED;
    }

    public boolean onCancel() {
        if (this.targetBlock != null) {
            this.sendMessage("Cancelled fill");
            this.deactivate();
            return true;
        }
        return false;
    }

    public void onDeactivate() {
        this.targetBlock = null;
    }
}

