/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic;

import com.elmakers.mine.bukkit.blocks.MaterialBrush;
import com.elmakers.mine.bukkit.plugins.magic.BlockSpell;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.util.Vector;

public abstract class BrushSpell
extends BlockSpell {
    private MaterialBrush brush;
    private boolean hasBrush = false;

    protected void processParameters(ConfigurationNode parameters) {
        super.processParameters(parameters);
        String materialKey = parameters.getString("material", null);
        materialKey = parameters.getString("m", materialKey);
        if (materialKey != null) {
            this.brush = new MaterialBrush(this.controller, this.getLocation(), materialKey);
            if (parameters.containsKey("mm")) {
                this.brush.update(parameters.getString("mm"));
                this.brush.update(materialKey);
            }
            Double dmxValue = parameters.getDouble("dmx", null);
            Double dmyValue = parameters.getDouble("dmy", null);
            Double dmzValue = parameters.getDouble("dmz", null);
            if (dmxValue != null || dmyValue != null || dmzValue != null) {
                Vector offset = new Vector(dmxValue == null ? 0.0 : dmxValue, dmyValue == null ? 0.0 : dmyValue, dmzValue == null ? 0.0 : dmzValue);
                this.brush.clearCloneTarget();
                this.brush.setTargetOffset(offset);
            }
        } else {
            this.brush = null;
        }
    }

    protected void loadTemplate(ConfigurationNode node) {
        super.loadTemplate(node);
        this.hasBrush = this.parameters.containsKey("material");
    }

    public MaterialBrush getMaterialBrush() {
        if (this.brush != null) {
            return this.brush;
        }
        return this.mage.getBrush();
    }

    public boolean hasBrushOverride() {
        return this.brush != null || this.hasBrush;
    }
}

