/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.blocks.RegenerateBatch;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.plugins.magic.TargetType;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.block.Block;

public class RegenerateSpell
extends Spell {
    private static final int DEFAULT_MAX_DIMENSION = 128;
    private Block targetBlock = null;

    public SpellResult onCast(ConfigurationNode parameters) {
        boolean singleBlock;
        Block targetBlock = this.getTargetBlock();
        boolean bl = singleBlock = this.getTargetType() != TargetType.SELECT;
        if (targetBlock == null) {
            this.castMessage("No target");
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(targetBlock)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        if (singleBlock) {
            this.deactivate();
            World world = targetBlock.getWorld();
            Chunk chunk = targetBlock.getChunk();
            world.regenerateChunk(chunk.getX(), chunk.getZ());
            return SpellResult.CAST;
        }
        if (this.targetBlock != null) {
            RegenerateBatch batch = new RegenerateBatch(this, this.targetBlock.getLocation(), targetBlock.getLocation());
            int maxDimension = parameters.getInteger("max_dimension", 128);
            maxDimension = (int)(this.mage.getConstructionMultiplier() * (float)maxDimension);
            if (!batch.checkDimension(maxDimension)) {
                this.sendMessage("Dimension is too big!");
                return SpellResult.FAIL;
            }
            this.mage.addPendingBlockBatch(batch);
            this.deactivate();
            return SpellResult.CAST;
        }
        this.targetBlock = targetBlock;
        this.activate();
        this.castMessage("Cast again to regenerate area");
        return SpellResult.TARGET_SELECTED;
    }

    public boolean onCancel() {
        if (this.targetBlock != null) {
            this.sendMessage("Cancelled regenerate");
            this.deactivate();
            return true;
        }
        return false;
    }

    public void onDeactivate() {
        this.targetBlock = null;
    }
}

