/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.blocks.BlockRecurse;
import com.elmakers.mine.bukkit.blocks.MaterialBrush;
import com.elmakers.mine.bukkit.blocks.ReplaceMaterialAction;
import com.elmakers.mine.bukkit.plugins.magic.BrushSpell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Material;
import org.bukkit.block.Block;

public class RecurseSpell
extends BrushSpell {
    private final BlockRecurse blockRecurse = new BlockRecurse();

    public SpellResult onCast(ConfigurationNode parameters) {
        Block targetBlock = this.getTargetBlock();
        if (targetBlock == null) {
            this.castMessage("No target");
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(targetBlock)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        MaterialBrush buildWith = this.getMaterialBrush();
        int size = parameters.getInt("size", 8);
        size = (int)(this.mage.getRadiusMultiplier() * (float)size);
        this.blockRecurse.setMaxRecursion(size);
        Material targetMaterial = targetBlock.getType();
        ReplaceMaterialAction action = new ReplaceMaterialAction(this.mage, targetBlock, buildWith);
        if (targetMaterial == Material.STATIONARY_WATER) {
            action.addReplaceable(Material.WATER);
        } else if (targetMaterial == Material.WATER) {
            action.addReplaceable(Material.STATIONARY_WATER);
        } else if (targetMaterial == Material.STATIONARY_LAVA) {
            action.addReplaceable(Material.LAVA);
        } else if (targetMaterial == Material.LAVA) {
            action.addReplaceable(Material.STATIONARY_LAVA);
        }
        this.blockRecurse.recurse(targetBlock, action);
        this.mage.registerForUndo(action.getBlocks());
        this.controller.updateBlock(targetBlock);
        Material material = buildWith.getMaterial();
        this.castMessage("Filled " + action.getBlocks().size() + " blocks with " + material.name().toLowerCase());
        return SpellResult.CAST;
    }
}

