/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.blocks.BlockList;
import com.elmakers.mine.bukkit.blocks.MaterialBrush;
import com.elmakers.mine.bukkit.effects.EffectUtils;
import com.elmakers.mine.bukkit.effects.ParticleType;
import com.elmakers.mine.bukkit.plugins.magic.BrushSpell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.util.Vector;

public class IterateSpell
extends BrushSpell {
    private int DEFAULT_SIZE = 16;

    public SpellResult onCast(ConfigurationNode parameters) {
        Block target;
        int timeToLive = parameters.getInt("undo", 0);
        boolean incrementData = parameters.getBoolean("increment_data", false);
        int radius = parameters.getInt("radius", 0);
        radius = (int)((float)radius * this.mage.getRadiusMultiplier());
        int size = parameters.getInt("size", this.DEFAULT_SIZE);
        boolean reverse = parameters.getBoolean("reverse", false);
        size = (int)(this.mage.getConstructionMultiplier() * (float)size);
        boolean reverseTargeting = parameters.getBoolean("transparent_reverse", false);
        if (reverseTargeting) {
            this.setReverseTargeting(true);
        }
        if ((target = this.getTargetBlock()) == null) {
            this.castMessage("No target");
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(target) || !this.hasBuildPermission(this.getPlayer().getLocation().getBlock())) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        int iterateBlocks = (int)this.getPlayer().getLocation().distance(target.getLocation());
        if (iterateBlocks <= 0) {
            return SpellResult.NO_TARGET;
        }
        iterateBlocks = Math.min(iterateBlocks, size);
        Vector targetLoc = new Vector(target.getX(), target.getY(), target.getZ());
        Vector playerLoc = new Vector(this.getPlayer().getLocation().getX(), this.getPlayer().getLocation().getY() + 1.0, this.getPlayer().getLocation().getZ());
        Vector aim = null;
        if (reverse) {
            aim = playerLoc;
            aim.subtract(targetLoc);
            aim.normalize();
        } else {
            aim = targetLoc;
            aim.subtract(playerLoc);
            aim.normalize();
            targetLoc = playerLoc;
            targetLoc.add(aim);
            targetLoc.add(aim);
        }
        MaterialBrush buildWith = this.getMaterialBrush();
        buildWith.setTarget(target.getLocation());
        buildWith.update(this.mage, target.getLocation());
        BlockList iteratedBlocks = new BlockList();
        int dr = 0;
        while (dr <= radius) {
            int spokes = 1;
            if (dr > 0) {
                spokes = radius == 2 ? (dr == 1 ? 8 : 12) : 4;
            }
            int dspoke = 0;
            while (dspoke < spokes) {
                Vector currentLoc = targetLoc.clone();
                if (dr > 0) {
                    double y;
                    double z;
                    Vector perp;
                    Vector axis;
                    double q = (double)dspoke * Math.PI * 2.0 / (double)spokes;
                    if (aim.getY() > 0.7) {
                        axis = new Vector(1, 0, 0);
                        perp = aim.clone().crossProduct(axis).multiply(dr);
                        double x = perp.getZ() * Math.sin(q) - perp.getX() * Math.cos(q);
                        z = perp.getZ() * Math.cos(q) - perp.getX() * Math.sin(q);
                        perp.setX(x);
                        perp.setZ(z);
                        currentLoc.add(perp);
                    } else if (aim.getX() > 0.7) {
                        axis = new Vector(0, 1, 0);
                        perp = aim.clone().crossProduct(axis).multiply(dr);
                        y = perp.getZ() * Math.sin(q) - perp.getY() * Math.cos(q);
                        z = perp.getZ() * Math.cos(q) - perp.getY() * Math.sin(q);
                        perp.setY(y);
                        perp.setZ(z);
                        currentLoc.add(perp);
                    } else {
                        axis = new Vector(0, 1, 0);
                        perp = aim.clone().crossProduct(axis).multiply(dr);
                        y = perp.getX() * Math.sin(q) - perp.getY() * Math.cos(q);
                        double x = perp.getX() * Math.cos(q) - perp.getY() * Math.sin(q);
                        perp.setY(y);
                        perp.setX(x);
                        currentLoc.add(perp);
                    }
                }
                int i = 0;
                while (i < iterateBlocks) {
                    Block currentTarget = target.getWorld().getBlockAt(currentLoc.getBlockX(), currentLoc.getBlockY(), currentLoc.getBlockZ());
                    if (!this.isTargetable(currentTarget.getType()) && this.isDestructible(currentTarget) && this.hasBuildPermission(currentTarget)) {
                        iteratedBlocks.add(currentTarget);
                        buildWith.update(this.mage, currentTarget.getLocation());
                        if (incrementData) {
                            byte data = buildWith.getData();
                            data = (byte)(i > 15 ? 15 : (byte)i);
                            buildWith.setData(data);
                        }
                        buildWith.modify(currentTarget);
                        this.controller.updateBlock(currentTarget);
                        Location effectLocation = currentTarget.getLocation();
                        effectLocation.add(0.5, 0.5, 0.5);
                        if (dr == 0) {
                            Material material = buildWith.getMaterial();
                            if (material == Material.AIR) {
                                EffectUtils.playEffect(effectLocation, ParticleType.LARGE_EXPLOSION, 0.3f, 0.3f, 0.3f, 1.0f, 1);
                            } else {
                                effectLocation.getWorld().playEffect(effectLocation, Effect.STEP_SOUND, material.getId());
                            }
                        }
                    }
                    currentLoc.add(aim);
                    ++i;
                }
                ++dspoke;
            }
            ++dr;
        }
        if (iteratedBlocks.size() > 0) {
            iteratedBlocks.setTimeToLive(timeToLive);
            this.mage.registerForUndo(iteratedBlocks);
        }
        this.castMessage("Filled " + iteratedBlocks.size() + " blocks");
        return SpellResult.CAST;
    }
}

