/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.blocks.BlockList;
import com.elmakers.mine.bukkit.plugins.magic.BlockSpell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.Target;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class DisintegrateSpell
extends BlockSpell {
    private static final int DEFAULT_PLAYER_DAMAGE = 1;
    private static final int DEFAULT_ENTITY_DAMAGE = 100;

    public SpellResult onCast(ConfigurationNode parameters) {
        Entity targetEntity;
        Target target = this.getTarget();
        if (target == null) {
            this.castMessage("No target");
            return SpellResult.NO_TARGET;
        }
        int playerDamage = parameters.getInteger("player_damage", 1);
        int entityDamage = parameters.getInteger("entity_damage", 100);
        if (target.isEntity() && (targetEntity = target.getEntity()) instanceof LivingEntity) {
            LivingEntity li = (LivingEntity)targetEntity;
            if (li instanceof Player) {
                li.damage((double)(this.mage.getDamageMultiplier() * (float)playerDamage), (Entity)this.getPlayer());
            } else {
                li.damage((double)(this.mage.getDamageMultiplier() * (float)entityDamage), (Entity)this.getPlayer());
            }
            this.castMessage("ZOT!");
            return SpellResult.CAST;
        }
        if (!target.hasTarget()) {
            this.castMessage("No target");
            return SpellResult.NO_TARGET;
        }
        Block targetBlock = target.getBlock();
        if (!this.hasBuildPermission(targetBlock)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        if (this.mage.isIndestructible(targetBlock)) {
            return SpellResult.NO_TARGET;
        }
        BlockList disintigrated = new BlockList();
        disintigrated.add(targetBlock);
        if (this.isUnderwater()) {
            targetBlock.setType(Material.STATIONARY_WATER);
        } else {
            targetBlock.setType(Material.AIR);
        }
        this.mage.registerForUndo(disintigrated);
        this.castMessage("ZAP!");
        return SpellResult.CAST;
    }
}

