/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.populator;

import com.elmakers.mine.bukkit.plugins.magic.MagicController;
import com.elmakers.mine.bukkit.plugins.magic.populator.MagicRunnable;
import com.elmakers.mine.bukkit.plugins.magic.wand.LostWand;
import com.elmakers.mine.bukkit.plugins.magic.wand.Wand;
import java.util.LinkedList;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;

public class WandCleanupRunnable
extends MagicRunnable {
    private final LinkedList<LostWand> lostWands = new LinkedList();
    private final World world;
    private final MagicController controller;
    private final String owner;
    private final boolean removeAll;

    public WandCleanupRunnable(MagicController controller, World world, String owner) {
        super(controller.getLogger());
        this.world = world;
        this.controller = controller;
        this.lostWands.addAll(controller.getLostWands());
        this.removeAll = false;
        this.owner = owner == null ? "" : owner;
    }

    public WandCleanupRunnable(MagicController controller, World world) {
        super(controller.getLogger());
        this.world = world;
        this.controller = controller;
        this.removeAll = true;
        this.owner = "";
        this.lostWands.addAll(controller.getLostWands());
    }

    public void finish() {
        super.finish();
        this.lostWands.clear();
    }

    public void run() {
        Entity[] entities;
        Chunk chunk;
        if (this.lostWands.isEmpty()) {
            this.finish();
            return;
        }
        LostWand lostWand = this.lostWands.getFirst();
        Location location = lostWand.getLocation();
        if (this.world != null && !location.getWorld().getName().equals(this.world.getName())) {
            this.lostWands.removeFirst();
            return;
        }
        String lostWandOwner = lostWand.getOwner();
        String string = lostWandOwner = lostWandOwner == null ? "" : lostWandOwner;
        if (!this.removeAll) {
            if (this.owner.length() == 0 && lostWandOwner.length() > 0) {
                this.lostWands.removeFirst();
                return;
            }
            if (this.owner.length() > 0 && !lostWandOwner.equals(this.owner)) {
                this.lostWands.removeFirst();
                return;
            }
        }
        if (!(chunk = location.getChunk()).isLoaded()) {
            chunk.load();
            return;
        }
        Entity[] entityArray = entities = chunk.getEntities();
        int n = entities.length;
        int n2 = 0;
        while (n2 < n) {
            Wand wand;
            Item item;
            ItemStack itemStack;
            Entity entity = entityArray[n2];
            if (entity instanceof Item && Wand.isWand(itemStack = (item = (Item)entity).getItemStack()) && (wand = new Wand(this.controller, itemStack)).getId().equals(lostWand.getId())) {
                this.logger.info("Removed lost wand " + lostWand.getName() + " (" + lostWand.getOwner() + "), id " + lostWand.getId() + " in " + location.getWorld().getName() + " at " + location.getBlockX() + " " + location.getBlockY() + " " + location.getBlockZ());
                this.controller.removeLostWand(lostWand.getId());
                item.remove();
                this.lostWands.removeFirst();
                return;
            }
            ++n2;
        }
        this.lostWands.removeFirst();
        this.controller.removeLostWand(lostWand.getId());
        this.logger.info("Could not find wand " + lostWand.getName() + " (" + lostWand.getOwner() + "), id " + lostWand.getId() + ", removing from list");
    }
}

