/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic;

import com.elmakers.mine.bukkit.blocks.BlockAction;
import com.elmakers.mine.bukkit.blocks.MaterialAndData;
import com.elmakers.mine.bukkit.effects.EffectPlayer;
import com.elmakers.mine.bukkit.effects.EffectSingle;
import com.elmakers.mine.bukkit.effects.EffectTrail;
import com.elmakers.mine.bukkit.effects.ParticleType;
import com.elmakers.mine.bukkit.plugins.magic.CastingCost;
import com.elmakers.mine.bukkit.plugins.magic.Mage;
import com.elmakers.mine.bukkit.plugins.magic.MagicController;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.plugins.magic.TargetType;
import com.elmakers.mine.bukkit.utilities.CSVParser;
import com.elmakers.mine.bukkit.utilities.Messages;
import com.elmakers.mine.bukkit.utilities.Target;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Spell
implements Comparable<Spell>,
Cloneable {
    protected MagicController controller;
    protected Mage mage;
    protected static CSVParser csv = new CSVParser();
    private String key;
    private String name;
    private String description;
    private String usage;
    private String category;
    private MaterialAndData icon = new MaterialAndData(Material.AIR);
    private List<CastingCost> costs = null;
    private List<CastingCost> activeCosts = null;
    protected ConfigurationNode parameters = new ConfigurationNode();
    private boolean allowMaxRange = false;
    private boolean pvpRestricted = false;
    private int range = 32;
    private static int maxRange = 511;
    private double viewHeight = 1.65;
    private double step = 0.2;
    private int cooldown = 0;
    private int duration = 0;
    private long lastCast = 0L;
    private long castCount = 0L;
    private long lastMessageSent = 0L;
    private int verticalSearchDistance = 8;
    private boolean targetingComplete;
    private int targetHeightRequired = 1;
    private Class<? extends Entity> targetEntityType = null;
    private Location location;
    private double xRotation;
    private double yRotation;
    private double length;
    private double hLength;
    private double xOffset;
    private double yOffset;
    private double zOffset;
    private int lastX;
    private int lastY;
    private int lastZ;
    private int targetX;
    private int targetY;
    private int targetZ;
    private Set<Material> targetThroughMaterials = new HashSet<Material>();
    private boolean reverseTargeting = false;
    private boolean isActive = false;
    private Map<SpellResult, List<EffectPlayer>> effects = new HashMap<SpellResult, List<EffectPlayer>>();
    private Target target = null;
    private TargetType targetType = TargetType.OTHER;

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    protected static String getBuiltinClasspath() {
        String baseClass = Spell.class.getName();
        return baseClass.substring(0, baseClass.lastIndexOf(46));
    }

    public static Spell loadSpell(String name, ConfigurationNode node, MagicController controller) {
        Object newObject;
        String builtinClassPath = Spell.getBuiltinClasspath();
        String className = node.getString("class");
        if (className == null) {
            return null;
        }
        if (className.indexOf(46) <= 0) {
            className = String.valueOf(builtinClassPath) + ".spells." + className;
        }
        Class<?> spellClass = null;
        try {
            spellClass = Class.forName(className);
        }
        catch (Throwable ex) {
            controller.getLogger().warning("Error loading spell: " + name + ", " + ex.getMessage());
            return null;
        }
        try {
            newObject = spellClass.newInstance();
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        if (newObject == null || !(newObject instanceof Spell)) {
            return null;
        }
        Spell newSpell = (Spell)newObject;
        newSpell.initialize(controller);
        newSpell.loadTemplate(name, node);
        return newSpell;
    }

    public void checkActiveCosts() {
        if (this.activeCosts == null) {
            return;
        }
        for (CastingCost cost : this.activeCosts) {
            if (!cost.has(this.mage)) {
                this.deactivate();
                return;
            }
            cost.use(this.mage);
        }
    }

    public void checkActiveDuration() {
        if (this.duration > 0 && this.lastCast < System.currentTimeMillis() - (long)this.duration) {
            this.deactivate();
        }
    }

    protected void activate() {
        this.onActivate();
        this.mage.activateSpell(this);
        this.isActive = true;
    }

    protected void deactivate() {
        this.onDeactivate();
        this.mage.deactivateSpell(this);
        this.isActive = false;
    }

    protected List<CastingCost> parseCosts(ConfigurationNode node) {
        if (node == null) {
            return null;
        }
        ArrayList<CastingCost> castingCosts = new ArrayList<CastingCost>();
        List<String> costKeys = node.getKeys();
        for (String key : costKeys) {
            castingCosts.add(new CastingCost(key, node.getDouble(key, 1.0)));
        }
        return castingCosts;
    }

    public void configure(ConfigurationNode node) {
    }

    protected void loadTemplate(String key, ConfigurationNode node) {
        this.key = key;
        this.loadTemplate(node);
    }

    protected void loadTemplate(ConfigurationNode node) {
        this.name = this.key;
        this.name = Messages.get("spells." + this.key + ".name", this.name);
        this.description = Messages.get("spells." + this.key + ".description", this.description);
        this.usage = Messages.get("spells." + this.key + ".usage", this.usage);
        this.icon = node.getMaterialAndData("icon", this.icon.getMaterial());
        this.category = node.getString("category", this.category);
        this.parameters = node.getNode("parameters", this.parameters);
        this.pvpRestricted = node.getBoolean("pvp_restricted", this.pvpRestricted);
        this.costs = this.parseCosts(node.getNode("costs"));
        this.activeCosts = this.parseCosts(node.getNode("active_costs"));
        this.effects.clear();
        if (node.containsKey("effects")) {
            ConfigurationNode effectsNode = node.getNode("effects");
            SpellResult[] spellResultArray = SpellResult.values();
            int n = spellResultArray.length;
            int n2 = 0;
            while (n2 < n) {
                List<Object> effectNodes;
                SpellResult resultType = spellResultArray[n2];
                String typeName = resultType.name().toLowerCase();
                if (effectsNode.containsKey(typeName) && (effectNodes = effectsNode.getList(typeName)) != null) {
                    ArrayList<EffectPlayer> players = new ArrayList<EffectPlayer>();
                    for (Object o : effectNodes) {
                        Object oClass;
                        Map effectValues;
                        if (!(o instanceof Map) || !(effectValues = (Map)o).containsKey("class") || !((oClass = effectValues.get("class")) instanceof String)) continue;
                        String effectClass = (String)oClass;
                        try {
                            Class<?> genericClass = Class.forName("com.elmakers.mine.bukkit.effects." + effectClass);
                            if (!EffectPlayer.class.isAssignableFrom(genericClass)) {
                                throw new Exception("Must extend EffectPlayer");
                            }
                            Class<?> playerClass = genericClass;
                            EffectPlayer player = (EffectPlayer)playerClass.newInstance();
                            ConfigurationNode effectNode = new ConfigurationNode(effectValues);
                            player.load((Plugin)this.controller.getPlugin(), effectNode);
                            players.add(player);
                        }
                        catch (Exception ex) {
                            this.controller.getLogger().info("Error creating effect class: " + effectClass + " " + ex.getMessage());
                        }
                    }
                    this.effects.put(resultType, players);
                }
                ++n2;
            }
        }
        this.initializeDefaultSound(SpellResult.FAIL, Sound.NOTE_BASS_DRUM, 0.9f, 1.2f);
        this.initializeDefaultSound(SpellResult.INSUFFICIENT_RESOURCES, Sound.NOTE_BASS, 1.0f, 1.2f);
        this.initializeDefaultSound(SpellResult.INSUFFICIENT_PERMISSION, Sound.NOTE_BASS, 1.1f, 1.5f);
        this.initializeDefaultSound(SpellResult.COOLDOWN, Sound.NOTE_SNARE_DRUM, 1.1f, 0.9f);
        this.initializeDefaultSound(SpellResult.NO_TARGET, Sound.NOTE_STICKS, 1.1f, 0.9f);
        if (!this.effects.containsKey((Object)SpellResult.TARGET_SELECTED)) {
            ArrayList<EffectPlayer> effectList = new ArrayList<EffectPlayer>();
            EffectSingle targetHighlight = new EffectSingle((Plugin)this.controller.getPlugin());
            targetHighlight.setSound(Sound.ANVIL_USE);
            targetHighlight.setParticleType(ParticleType.HAPPY_VILLAGER);
            targetHighlight.setLocationType("target");
            targetHighlight.setOffset(0.5f, 0.5f, 0.5f);
            effectList.add(targetHighlight);
            EffectTrail trail = new EffectTrail((Plugin)this.controller.getPlugin());
            trail.setParticleType(ParticleType.WATER_DRIPPING);
            effectList.add(trail);
            this.effects.put(SpellResult.TARGET_SELECTED, effectList);
        }
        if (!this.effects.containsKey((Object)SpellResult.COST_FREE) && this.effects.containsKey((Object)SpellResult.CAST)) {
            this.effects.put(SpellResult.COST_FREE, this.effects.get((Object)SpellResult.CAST));
        }
    }

    protected void initializeDefaultSound(SpellResult result, Sound sound, float volume, float pitch) {
        if (this.effects.containsKey((Object)result)) {
            return;
        }
        EffectSingle defaultEffect = new EffectSingle((Plugin)this.controller.getPlugin());
        defaultEffect.setSound(sound, volume, pitch);
        ArrayList<EffectSingle> effectList = new ArrayList<EffectSingle>();
        effectList.add(defaultEffect);
        this.effects.put(result, effectList);
    }

    public void setMage(Mage mage) {
        this.mage = mage;
    }

    public final String getKey() {
        return this.key;
    }

    public final String getName() {
        return this.name;
    }

    public final MaterialAndData getIcon() {
        return this.icon;
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getUsage() {
        return this.usage;
    }

    public final String getCategory() {
        return this.category;
    }

    public boolean isMatch(String spell, String[] params) {
        if (params == null) {
            params = new String[]{};
        }
        return this.key.equalsIgnoreCase(spell) && this.parameters.equals(params);
    }

    @Override
    public int compareTo(Spell other) {
        return this.name.compareTo(other.name);
    }

    public boolean cast() {
        return this.cast(new String[0]);
    }

    public static void addParameters(String[] extraParameters, ConfigurationNode parameters) {
        if (extraParameters != null) {
            int i = 0;
            while (i < extraParameters.length - 1) {
                parameters.setProperty(extraParameters[i], extraParameters[i + 1]);
                i += 2;
            }
        }
    }

    public boolean cast(String[] extraParameters) {
        this.target = null;
        this.location = this.mage.getLocation();
        this.initializeTargeting();
        if (this.pvpRestricted && !this.controller.isPVPAllowed(this.mage.getLocation())) {
            this.sendMessage(Messages.get("costs.insufficient_permissions"));
            return false;
        }
        ConfigurationNode parameters = new ConfigurationNode(this.parameters);
        Spell.addParameters(extraParameters, parameters);
        this.cooldown = parameters.getInt("cooldown", this.cooldown);
        long currentTime = System.currentTimeMillis();
        float cooldownReduction = this.mage.getCooldownReduction();
        if (cooldownReduction < 1.0f && !this.isActive && this.cooldown > 0) {
            int reducedCooldown = (int)Math.ceil((1.0f - cooldownReduction) * (float)this.cooldown);
            if (this.lastCast != 0L && this.lastCast > currentTime - (long)reducedCooldown) {
                long seconds = (this.lastCast - (currentTime - (long)reducedCooldown)) / 1000L;
                if (seconds > 1L) {
                    this.sendMessage(Messages.get("cooldown.wait_seconds").replace("$seconds", Long.valueOf(seconds).toString()));
                } else {
                    this.sendMessage(Messages.get("cooldown.wait_moment"));
                }
                this.processResult(SpellResult.COOLDOWN);
                return false;
            }
        }
        if (this.costs != null && !this.isActive) {
            for (CastingCost cost : this.costs) {
                if (cost.has(this.mage)) continue;
                this.sendMessage(Messages.get("costs.insufficient_resources").replace("$cost", cost.getDescription(this.mage)));
                this.processResult(SpellResult.INSUFFICIENT_RESOURCES);
                return false;
            }
        }
        this.lastCast = currentTime;
        this.processParameters(parameters);
        SpellResult result = this.onCast(parameters);
        this.processResult(result);
        if (result == SpellResult.CAST || result == SpellResult.AREA) {
            if (this.costs != null) {
                for (CastingCost cost : this.costs) {
                    cost.use(this.mage);
                }
            }
            ++this.castCount;
        } else if (result == SpellResult.INSUFFICIENT_PERMISSION) {
            this.sendMessage(Messages.get("costs.insufficient_permissions"));
        }
        return result == SpellResult.CAST;
    }

    protected void initializeTargeting() {
        this.length = 0.0;
        this.targetHeightRequired = 1;
        this.xRotation = (this.location.getYaw() + 90.0f) % 360.0f;
        this.yRotation = this.location.getPitch() * -1.0f;
        this.reverseTargeting = false;
        this.targetX = (int)Math.floor(this.location.getX());
        this.targetY = (int)Math.floor(this.location.getY() + this.viewHeight);
        this.targetZ = (int)Math.floor(this.location.getZ());
        this.lastX = this.targetX;
        this.lastY = this.targetY;
        this.lastZ = this.targetZ;
        this.targetingComplete = false;
    }

    protected void processResult(SpellResult result) {
        if (result == SpellResult.CAST || result == SpellResult.AREA) {
            this.controller.onCast(this.mage, this, result);
        }
        Location mageLocation = this.mage.getEyeLocation();
        if (this.effects.containsKey((Object)result) && mageLocation != null) {
            Location targetLocation = null;
            if (this.target != null) {
                targetLocation = this.target.getLocation();
            }
            List<EffectPlayer> resultEffects = this.effects.get((Object)result);
            for (EffectPlayer player : resultEffects) {
                player.setMaterial(this.mage.getBrush());
                player.setColor(this.mage.getEffectColor());
                player.start(mageLocation, targetLocation);
            }
        }
    }

    protected void processParameters(ConfigurationNode parameters) {
        this.duration = parameters.getInt("duration", this.duration);
        this.range = parameters.getInteger("range", this.range);
        this.allowMaxRange = parameters.getBoolean("allow_max_range", this.allowMaxRange);
        if (parameters.containsKey("target_through")) {
            this.targetThroughMaterials = parameters.getMaterials("target_through");
        } else if (parameters.containsKey("transparent")) {
            this.targetThroughMaterials.clear();
            this.targetThroughMaterials.addAll(this.controller.getMaterialSet(parameters.getString("transparent")));
        } else {
            this.targetThroughMaterials.clear();
            this.targetThroughMaterials.addAll(this.controller.getMaterialSet("transparent"));
        }
        if (this.isUnderwater()) {
            this.targetThroughMaterials.add(Material.WATER);
            this.targetThroughMaterials.add(Material.STATIONARY_WATER);
        }
        if (parameters.containsKey("target")) {
            String targetTypeName = parameters.getString("target");
            try {
                this.targetType = TargetType.valueOf(targetTypeName.toUpperCase());
            }
            catch (Exception ex) {
                this.controller.getLogger().warning("Invalid target_type: " + targetTypeName);
                this.targetType = TargetType.OTHER;
            }
        }
        if (parameters.containsKey("target_type")) {
            String entityTypeName = parameters.getString("target_type");
            try {
                Class<?> typeClass = Class.forName("org.bukkit.entity." + entityTypeName);
                if (Entity.class.isAssignableFrom(typeClass)) {
                    this.targetEntityType = typeClass;
                } else {
                    this.controller.getLogger().warning("Entity type: " + entityTypeName + " not assignable to Entity");
                }
            }
            catch (Throwable ex) {
                this.controller.getLogger().warning("Unknown entity type: " + entityTypeName);
                this.targetEntityType = null;
            }
        }
    }

    public String getPermissionNode() {
        return "Magic.cast." + this.key;
    }

    public boolean hasSpellPermission(Player player) {
        if (player == null) {
            return true;
        }
        return this.controller.hasPermission(player, this.getPermissionNode(), true);
    }

    public abstract SpellResult onCast(ConfigurationNode var1);

    public boolean onCancel() {
        return false;
    }

    public void onPlayerQuit(PlayerQuitEvent event) {
    }

    public void onPlayerDeath(EntityDeathEvent event) {
    }

    public void onPlayerDamage(EntityDamageEvent event) {
    }

    public static byte getItemData(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        return (byte)stack.getDurability();
    }

    public Player getPlayer() {
        return this.mage.getPlayer();
    }

    public CommandSender getCommandSender() {
        return this.mage.getCommandSender();
    }

    public boolean hasBuildPermission(Block block) {
        return this.mage.hasBuildPermission(block);
    }

    public void targetThrough(Material mat) {
        this.targetThroughMaterials.add(mat);
    }

    public void targetThrough(Set<Material> mat) {
        this.targetThroughMaterials.clear();
        this.targetThroughMaterials.addAll(mat);
    }

    public void noTargetThrough(Material mat) {
        this.targetThroughMaterials.remove(mat);
    }

    public boolean isTargetable(Material mat) {
        boolean targetThrough = this.targetThroughMaterials.contains(mat);
        if (this.reverseTargeting) {
            return targetThrough;
        }
        return !targetThrough;
    }

    public void setReverseTargeting(boolean reverse) {
        this.reverseTargeting = reverse;
    }

    public boolean isReverseTargeting() {
        return this.reverseTargeting;
    }

    public void setTargetHeightRequired(int height) {
        this.targetHeightRequired = height;
    }

    public int getTargetHeightRequired() {
        return this.targetHeightRequired;
    }

    public void setTarget(Location location) {
        this.target = new Target(this.getPlayer(), location.getBlock());
    }

    public boolean isOkToStandIn(Material mat) {
        return mat == Material.AIR || mat == Material.WATER || mat == Material.STATIONARY_WATER || mat == Material.SNOW || mat == Material.TORCH || mat == Material.SIGN_POST || mat == Material.REDSTONE_TORCH_ON || mat == Material.REDSTONE_TORCH_OFF || mat == Material.YELLOW_FLOWER || mat == Material.RED_ROSE || mat == Material.RED_MUSHROOM || mat == Material.BROWN_MUSHROOM || mat == Material.LONG_GRASS;
    }

    public boolean isWater(Material mat) {
        return mat == Material.WATER || mat == Material.STATIONARY_WATER;
    }

    public boolean isOkToStandOn(Material mat) {
        return mat != Material.AIR && mat != Material.LAVA && mat != Material.STATIONARY_LAVA;
    }

    public boolean isSafeLocation(Block block) {
        if (!block.getChunk().isLoaded()) {
            block.getChunk().load(true);
            return false;
        }
        if (block.getY() > 255) {
            return false;
        }
        Block blockOneUp = block.getRelative(BlockFace.UP);
        Block blockTwoUp = blockOneUp.getRelative(BlockFace.UP);
        return this.isOkToStandOn(block.getType()) && this.isOkToStandIn(blockOneUp.getType()) && this.isOkToStandIn(blockTwoUp.getType());
    }

    public boolean isSafeLocation(Location loc) {
        return this.isSafeLocation(loc.getBlock());
    }

    public Location tryFindPlaceToStand(Location targetLoc) {
        return this.tryFindPlaceToStand(targetLoc, 4, 253);
    }

    public Location tryFindPlaceToStand(Location targetLoc, int minY, int maxY) {
        Location location = this.findPlaceToStand(targetLoc, minY, maxY);
        return location == null ? targetLoc : location;
    }

    public Location findPlaceToStand(Location targetLoc, int minY, int maxY) {
        if (!targetLoc.getBlock().getChunk().isLoaded()) {
            return null;
        }
        int targetY = targetLoc.getBlockY();
        if (targetY >= minY && targetY <= maxY && this.isSafeLocation(targetLoc)) {
            return targetLoc;
        }
        Location location = null;
        if (targetY < minY) {
            location = targetLoc.clone();
            location.setY((double)minY);
            location = this.findPlaceToStand(location, true, minY, maxY);
        } else if (targetY > maxY) {
            location = targetLoc.clone();
            location.setY((double)maxY);
            location = this.findPlaceToStand(location, false, minY, maxY);
        } else {
            location = this.findPlaceToStand(targetLoc, true, minY, maxY);
            if (location == null) {
                location = this.findPlaceToStand(targetLoc, false, minY, maxY);
            }
        }
        return location;
    }

    public Location findPlaceToStand(Location target, boolean goUp) {
        return this.findPlaceToStand(target, goUp, 4, 253);
    }

    public Location findPlaceToStand(Location target, boolean goUp, int minY, int maxY) {
        int direction = goUp ? 1 : -1;
        Location targetLocation = target.clone();
        while ((double)minY <= targetLocation.getY() && targetLocation.getY() <= (double)maxY) {
            Block block = targetLocation.getBlock();
            if (!(!this.isSafeLocation(block) || goUp && this.isUnderwater() && this.isWater(block.getType()))) {
                targetLocation.setY(targetLocation.getY() + 1.0);
                return targetLocation;
            }
            targetLocation.setY(targetLocation.getY() + (double)direction);
        }
        return null;
    }

    public Block getPlayerBlock() {
        Player player = this.getPlayer();
        if (player == null) {
            return null;
        }
        Block playerBlock = null;
        Location playerLoc = player.getLocation();
        int x = (int)Math.round(playerLoc.getX() - 0.5);
        int y = (int)Math.round(playerLoc.getY() - 0.5);
        int z = (int)Math.round(playerLoc.getZ() - 0.5);
        int dy = 0;
        while (dy > -3 && (playerBlock == null || this.isOkToStandIn(playerBlock.getType()))) {
            playerBlock = this.getPlayer().getWorld().getBlockAt(x, y + dy, z);
            --dy;
        }
        return playerBlock;
    }

    public BlockFace getPlayerFacing() {
        float playerRot = this.getPlayerRotation();
        BlockFace direction = BlockFace.NORTH;
        if (playerRot <= 45.0f || playerRot > 315.0f) {
            direction = BlockFace.SOUTH;
        } else if (playerRot > 45.0f && playerRot <= 135.0f) {
            direction = BlockFace.WEST;
        } else if (playerRot > 135.0f && playerRot <= 225.0f) {
            direction = BlockFace.NORTH;
        } else if (playerRot > 225.0f && playerRot <= 315.0f) {
            direction = BlockFace.EAST;
        }
        return direction;
    }

    public static BlockFace goLeft(BlockFace direction) {
        switch (direction) {
            case EAST: {
                return BlockFace.NORTH;
            }
            case NORTH: {
                return BlockFace.WEST;
            }
            case WEST: {
                return BlockFace.SOUTH;
            }
            case SOUTH: {
                return BlockFace.EAST;
            }
        }
        return direction;
    }

    public static BlockFace goRight(BlockFace direction) {
        switch (direction) {
            case EAST: {
                return BlockFace.SOUTH;
            }
            case SOUTH: {
                return BlockFace.WEST;
            }
            case WEST: {
                return BlockFace.NORTH;
            }
            case NORTH: {
                return BlockFace.EAST;
            }
        }
        return direction;
    }

    protected Location getProjectileSpawnLocation() {
        Block spawnBlock = this.getPlayerBlock();
        int height = 2;
        double hLength = 2.0;
        double xOffset = hLength * Math.cos(Math.toRadians(this.xRotation));
        double zOffset = hLength * Math.sin(Math.toRadians(this.xRotation));
        Vector aimVector = new Vector(xOffset + 0.5, (double)height + 0.5, zOffset + 0.5);
        Location location = new Location(this.getPlayer().getWorld(), (double)spawnBlock.getX() + aimVector.getX(), (double)spawnBlock.getY() + aimVector.getY(), (double)spawnBlock.getZ() + aimVector.getZ(), this.getPlayer().getLocation().getYaw(), this.getPlayer().getLocation().getPitch());
        return location;
    }

    protected Location getLocation() {
        Player player = this.getPlayer();
        if (player != null) {
            return player.getLocation();
        }
        return this.location;
    }

    protected Location getEyeLocation() {
        Player player = this.getPlayer();
        if (player != null) {
            return player.getEyeLocation();
        }
        Location location = this.getLocation();
        if (location == null) {
            return null;
        }
        location.setY(location.getY() + 1.5);
        return location;
    }

    public double getYRotation() {
        return this.yRotation;
    }

    public double getXRotation() {
        return this.xRotation;
    }

    public float getPlayerRotation() {
        float playerRot = this.getPlayer().getLocation().getYaw();
        while (playerRot < 0.0f) {
            playerRot += 360.0f;
        }
        while (playerRot > 360.0f) {
            playerRot -= 360.0f;
        }
        return playerRot;
    }

    public TargetType getTargetType() {
        return this.targetType;
    }

    public Target getTarget() {
        Player player = this.getPlayer();
        if (this.targetType == TargetType.SELF && player != null) {
            this.target = new Target(player, (Entity)player);
            return this.target;
        }
        this.findTargetBlock();
        Block block = this.getCurBlock();
        Target targetBlock = new Target(player, block);
        Target targetEntity = this.getTargetEntity();
        this.target = targetEntity == null || targetBlock.getDistance() < targetEntity.getDistance() || this.targetType == TargetType.NONE ? (this.targetType == TargetType.ANY && player != null ? new Target(player, (Entity)player) : targetBlock) : (!this.pvpRestricted || this.controller.isPVPAllowed(targetEntity.getLocation()) ? targetEntity : (this.targetType == TargetType.ANY && player != null ? new Target(player, (Entity)player) : new Target(player)));
        return this.target;
    }

    public Target getCurrentTarget() {
        return this.target;
    }

    public Block getTargetBlock() {
        return this.getTarget().getBlock();
    }

    protected Target getTargetEntity() {
        if (this.targetEntityType == null) {
            return null;
        }
        List<Target> scored = this.getAllTargetEntities();
        if (scored.size() <= 0) {
            return null;
        }
        return scored.get(0);
    }

    protected List<Target> getAllTargetEntities() {
        List entities = this.getPlayer().getWorld().getEntities();
        ArrayList<Target> scored = new ArrayList<Target>();
        for (Entity entity : entities) {
            Target newScore;
            if (entity == this.getPlayer() || this.targetEntityType != null && !this.targetEntityType.isAssignableFrom(entity.getClass()) || (newScore = new Target(this.getPlayer(), entity, this.getMaxRange())).getScore() <= 0) continue;
            scored.add(newScore);
        }
        Collections.sort(scored);
        return scored;
    }

    public Block getFaceBlock() {
        this.findTargetBlock();
        if (this.getCurBlock() != null) {
            return this.getLastBlock();
        }
        return null;
    }

    public Block getNextBlock() {
        this.lastX = this.targetX;
        this.lastY = this.targetY;
        this.lastZ = this.targetZ;
        int scaledRange = this.getMaxRange();
        do {
            this.length += this.step;
            this.hLength = this.length * Math.cos(Math.toRadians(this.yRotation));
            this.yOffset = this.length * Math.sin(Math.toRadians(this.yRotation));
            this.xOffset = this.hLength * Math.cos(Math.toRadians(this.xRotation));
            this.zOffset = this.hLength * Math.sin(Math.toRadians(this.xRotation));
            this.targetX = (int)Math.floor(this.xOffset + this.location.getX());
            this.targetY = (int)Math.floor(this.yOffset + this.location.getY() + this.viewHeight);
            this.targetZ = (int)Math.floor(this.zOffset + this.location.getZ());
        } while (this.length <= (double)scaledRange && this.targetX == this.lastX && this.targetY == this.lastY && this.targetZ == this.lastZ);
        if (this.length > (double)scaledRange || this.targetY > 255) {
            if (this.allowMaxRange) {
                return this.getBlockAt(this.targetX, this.targetY, this.targetZ);
            }
            return null;
        }
        return this.getBlockAt(this.targetX, this.targetY, this.targetZ);
    }

    public Block getCurBlock() {
        int scaledRange = this.getMaxRange();
        if (this.length > (double)scaledRange && !this.allowMaxRange) {
            return null;
        }
        return this.getBlockAt(this.targetX, this.targetY, this.targetZ);
    }

    public Block getLastBlock() {
        return this.getBlockAt(this.lastX, this.lastY, this.lastZ);
    }

    public Block getBlockAt(int x, int y, int z) {
        World world = this.getPlayer().getWorld();
        return world.getBlockAt(x, y, z);
    }

    public void castMessage(String message) {
        if (this.canSendMessage()) {
            this.mage.castMessage(message);
            this.lastMessageSent = System.currentTimeMillis();
        }
    }

    public void sendMessage(String message) {
        if (this.canSendMessage()) {
            this.mage.sendMessage(message);
            this.lastMessageSent = System.currentTimeMillis();
        }
    }

    private boolean canSendMessage() {
        if (this.lastMessageSent == 0L) {
            return true;
        }
        int throttle = this.controller.getMessageThrottle();
        long now = System.currentTimeMillis();
        return this.lastMessageSent < now - (long)throttle;
    }

    public void setTime(long time) {
        this.getPlayer().getWorld().setTime(time);
    }

    public long getTime() {
        return this.getPlayer().getWorld().getTime();
    }

    public boolean isUnderwater() {
        Block playerBlock = this.getPlayerBlock();
        return (playerBlock = playerBlock.getRelative(BlockFace.UP)).getType() == Material.WATER || playerBlock.getType() == Material.STATIONARY_WATER;
    }

    public void initialize(MagicController instance) {
        this.controller = instance;
        this.targetThroughMaterials.clear();
    }

    public boolean cancel() {
        return this.onCancel();
    }

    protected void findTargetBlock() {
        if (this.targetingComplete) {
            return;
        }
        int scaledRange = this.getMaxRange();
        while (this.getNextBlock() != null && this.length <= (double)scaledRange) {
            Block block = this.getCurBlock();
            if (!this.isTargetable(block.getType())) continue;
            boolean enoughSpace = true;
            int i = 1;
            while (i < this.targetHeightRequired) {
                if (!this.isTargetable((block = block.getRelative(BlockFace.UP)).getType())) {
                    enoughSpace = false;
                    break;
                }
                ++i;
            }
            if (enoughSpace) break;
        }
        this.targetingComplete = true;
    }

    public long getCastCount() {
        return this.castCount;
    }

    protected int getMaxRange() {
        return Math.min(maxRange, (int)(this.mage.getRangeMultiplier() * (float)this.range));
    }

    protected int getMaxRangeSquared() {
        int maxRange = this.getMaxRange();
        return maxRange * maxRange;
    }

    protected void setMaxRange(int range, boolean allow) {
        this.range = range;
        this.allowMaxRange = allow;
    }

    protected Material getMaterial(String matName, List<Material> materials) {
        Material material = Material.AIR;
        StringBuffer simplify = new StringBuffer("_");
        matName = matName.replace(simplify, new StringBuffer(""));
        for (Material checkMat : materials) {
            String checkName = checkMat.name().replace(simplify, new StringBuffer(""));
            if (!checkName.equalsIgnoreCase(matName)) continue;
            material = checkMat;
            break;
        }
        return material;
    }

    protected boolean giveMaterial(Material materialType, int amount, short damage, byte data) {
        ItemStack itemStack = new ItemStack(materialType, amount, damage, Byte.valueOf(data));
        boolean active = false;
        int i = 8;
        while (i >= 0) {
            ItemStack current = this.getPlayer().getInventory().getItem(i);
            if (current == null || current.getType() == Material.AIR) {
                this.getPlayer().getInventory().setItem(i, itemStack);
                active = true;
                break;
            }
            --i;
        }
        if (!active) {
            this.getPlayer().getInventory().addItem(new ItemStack[]{itemStack});
        }
        return true;
    }

    public List<CastingCost> getCosts() {
        return this.costs;
    }

    public List<CastingCost> getActiveCosts() {
        return this.activeCosts;
    }

    public boolean isInCircle(int x, int z, int R) {
        return x * x + z * z - R * R <= 0;
    }

    /*
     * Unable to fully structure code
     */
    public void coverSurface(Location center, int radius, BlockAction action) {
        y = center.getBlockY();
        dx = -radius;
        while (dx < radius) {
            dz = -radius;
            while (dz < radius) {
                block5: {
                    block6: {
                        if (!this.isInCircle(dx, dz, radius)) break block5;
                        x = center.getBlockX() + dx;
                        z = center.getBlockZ() + dz;
                        block = this.getPlayer().getWorld().getBlockAt(x, y, z);
                        depth = 0;
                        if (!this.targetThroughMaterials.contains(block.getType())) ** GOTO lbl19
                        while (depth < this.verticalSearchDistance && this.targetThroughMaterials.contains(block.getType())) {
                            ++depth;
                            block = block.getRelative(BlockFace.DOWN);
                        }
                        break block6;
lbl-1000:
                        // 1 sources

                        {
                            ++depth;
                            block = block.getRelative(BlockFace.UP);
lbl19:
                            // 2 sources

                            ** while (depth < this.verticalSearchDistance && !this.targetThroughMaterials.contains((Object)block.getType()))
                        }
lbl20:
                        // 1 sources

                        block = block.getRelative(BlockFace.DOWN);
                    }
                    coveringBlock = block.getRelative(BlockFace.UP);
                    if (!this.targetThroughMaterials.contains(block.getType()) && this.targetThroughMaterials.contains(coveringBlock.getType())) {
                        action.perform(block);
                    }
                }
                ++dz;
            }
            ++dx;
        }
    }

    protected boolean isTransparent(Material material) {
        return this.targetThroughMaterials.contains(material);
    }

    public void onActivate() {
    }

    public void onDeactivate() {
    }

    public Mage getMage() {
        return this.mage;
    }

    public void load(ConfigurationNode node) {
        try {
            this.castCount = node.getLong("cast_count", 0L);
            this.lastCast = node.getLong("last_cast", 0L);
            this.onLoad(node);
        }
        catch (Exception ex) {
            this.controller.getPlugin().getLogger().warning("Failed to load data for spell " + this.name + ": " + ex.getMessage());
        }
    }

    public void save(ConfigurationNode node) {
        try {
            node.setProperty("cast_count", this.castCount);
            node.setProperty("last_cast", this.lastCast);
            this.onSave(node);
        }
        catch (Exception ex) {
            this.controller.getPlugin().getLogger().warning("Failed to save data for spell " + this.name + ": " + ex.getMessage());
        }
    }

    public void onLoad(ConfigurationNode node) {
    }

    public void onSave(ConfigurationNode node) {
    }

    protected static Collection<PotionEffect> getPotionEffects(ConfigurationNode parameters) {
        PotionEffectType[] effectTypes;
        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
        PotionEffectType[] potionEffectTypeArray = effectTypes = PotionEffectType.values();
        int n = effectTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String parameterName;
            PotionEffectType effectType = potionEffectTypeArray[n2];
            if (effectType != null && parameters.containsKey(parameterName = "effect_" + effectType.getName().toLowerCase())) {
                String value = parameters.getString(parameterName);
                String[] pieces = value.split(",");
                try {
                    Integer ticks = Integer.parseInt(pieces[0]);
                    Integer power = 1;
                    if (pieces.length > 0) {
                        power = Integer.parseInt(pieces[1]);
                    }
                    PotionEffect effect = new PotionEffect(effectType, ticks.intValue(), power.intValue(), true);
                    effects.add(effect);
                }
                catch (Exception ex) {
                    Bukkit.getLogger().warning("Error parsing potion effect for " + effectType + ": " + value + ": " + parameters.getKeys());
                }
            }
            ++n2;
        }
        return effects;
    }

    protected void applyPotionEffects(Location location, int radius, Collection<PotionEffect> potionEffects) {
        if (potionEffects == null || radius <= 0 || potionEffects.size() == 0) {
            return;
        }
        int radiusSquared = radius * 2;
        List entities = location.getWorld().getEntities();
        for (Entity entity : entities) {
            Mage targetMage;
            Player targetPlayer;
            if (!(entity instanceof LivingEntity) || entity instanceof Player && ((targetPlayer = (Player)entity).getName().equals(this.mage.getName()) && this.getTargetType() != TargetType.ANY && this.getTargetType() != TargetType.SELF || (targetMage = this.controller.getMage(targetPlayer)).isSuperProtected()) || this.targetEntityType != null && !this.targetEntityType.isAssignableFrom(entity.getClass()) || !(entity.getLocation().distanceSquared(location) < (double)radiusSquared)) continue;
            LivingEntity living = (LivingEntity)entity;
            living.addPotionEffects(potionEffects);
        }
    }

    protected String getBlockSkin(Material blockType) {
        String skinName = null;
        switch (blockType) {
            case CACTUS: {
                skinName = "MHF_Cactus";
                break;
            }
            case CHEST: {
                skinName = "MHF_Chest";
                break;
            }
            case MELON_BLOCK: {
                skinName = "MHF_Melon";
                break;
            }
            case TNT: {
                if (Math.random() > 0.5) {
                    skinName = "MHF_TNT";
                    break;
                }
                skinName = "MHF_TNT2";
                break;
            }
            case LOG: {
                skinName = "MHF_OakLog";
                break;
            }
            case PUMPKIN: {
                skinName = "MHF_Pumpkin";
            }
        }
        return skinName;
    }

    protected String getMobSkin(EntityType mobType) {
        String mobSkin = null;
        switch (mobType) {
            case BLAZE: {
                mobSkin = "MHF_Blaze";
                break;
            }
            case CAVE_SPIDER: {
                mobSkin = "MHF_CaveSpider";
                break;
            }
            case CHICKEN: {
                mobSkin = "MHF_Chicken";
                break;
            }
            case COW: {
                mobSkin = "MHF_Cow";
                break;
            }
            case ENDERMAN: {
                mobSkin = "MHF_Enderman";
                break;
            }
            case GHAST: {
                mobSkin = "MHF_Ghast";
                break;
            }
            case IRON_GOLEM: {
                mobSkin = "MHF_Golem";
                break;
            }
            case MAGMA_CUBE: {
                mobSkin = "MHF_LavaSlime";
                break;
            }
            case MUSHROOM_COW: {
                mobSkin = "MHF_MushroomCow";
                break;
            }
            case OCELOT: {
                mobSkin = "MHF_Ocelot";
                break;
            }
            case PIG: {
                mobSkin = "MHF_Pig";
                break;
            }
            case PIG_ZOMBIE: {
                mobSkin = "MHF_PigZombie";
                break;
            }
            case SHEEP: {
                mobSkin = "MHF_Sheep";
                break;
            }
            case SLIME: {
                mobSkin = "MHF_Slime";
                break;
            }
            case SPIDER: {
                mobSkin = "MHF_Spider";
                break;
            }
            case SQUID: {
                mobSkin = "MHF_Squid";
                break;
            }
            case VILLAGER: {
                mobSkin = "MHF_Villager";
            }
        }
        return mobSkin;
    }
}

