/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utilities;

import com.elmakers.mine.bukkit.utilities.NMSUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class InventoryUtils
extends NMSUtils {
    protected static Object getNMSCopy(ItemStack stack) {
        Object nms = null;
        try {
            Method copyMethod = class_CraftItemStack.getMethod("asNMSCopy", ItemStack.class);
            nms = copyMethod.invoke(null, stack);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return nms;
    }

    protected static Object getTag(Object mcItemStack) {
        Object tag = null;
        try {
            Field tagField = class_ItemStack.getField("tag");
            tag = tagField.get(mcItemStack);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return tag;
    }

    public static ItemStack getCopy(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        try {
            Object craft = InventoryUtils.getNMSCopy(stack);
            Method mirrorMethod = class_CraftItemStack.getMethod("asCraftMirror", craft.getClass());
            stack = (ItemStack)mirrorMethod.invoke(null, craft);
        }
        catch (Throwable ex) {
            stack = null;
        }
        return stack;
    }

    public static String getMeta(ItemStack stack, String tag, String defaultValue) {
        String result = InventoryUtils.getMeta(stack, tag);
        return result == null ? defaultValue : result;
    }

    public static boolean hasMeta(ItemStack stack, String tag) {
        return InventoryUtils.getNode(stack, tag) != null;
    }

    public static Object getNode(ItemStack stack, String tag) {
        Object tagObject;
        Object meta;
        block6: {
            Object craft;
            block5: {
                if (stack == null) {
                    return null;
                }
                meta = null;
                craft = InventoryUtils.getHandle(stack);
                if (craft != null) break block5;
                return null;
            }
            tagObject = InventoryUtils.getTag(craft);
            if (tagObject != null) break block6;
            return null;
        }
        try {
            Method getMethod = class_NBTTagCompound.getMethod("get", String.class);
            meta = getMethod.invoke(tagObject, tag);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return meta;
    }

    public static Object createNode(ItemStack stack, String tag) {
        if (stack == null) {
            return null;
        }
        Object outputObject = InventoryUtils.getNode(stack, tag);
        if (outputObject == null) {
            Object tagObject;
            block7: {
                Object craft;
                block6: {
                    craft = InventoryUtils.getHandle(stack);
                    if (craft != null) break block6;
                    return null;
                }
                tagObject = InventoryUtils.getTag(craft);
                if (tagObject != null) break block7;
                return null;
            }
            try {
                outputObject = class_NBTTagCompound.newInstance();
                Method setMethod = class_NBTTagCompound.getMethod("set", String.class, class_NBTBase);
                setMethod.invoke(tagObject, tag, outputObject);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        return outputObject;
    }

    public static String getMeta(Object node, String tag, String defaultValue) {
        String meta = InventoryUtils.getMeta(node, tag);
        return meta == null || meta.length() == 0 ? defaultValue : meta;
    }

    public static String getMeta(Object node, String tag) {
        if (node == null || !class_NBTTagCompound.isInstance(node)) {
            return null;
        }
        String meta = null;
        try {
            Method getStringMethod = class_NBTTagCompound.getMethod("getString", String.class);
            meta = (String)getStringMethod.invoke(node, tag);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return meta;
    }

    public static void setMeta(Object node, String tag, String value) {
        if (node == null || !class_NBTTagCompound.isInstance(node)) {
            return;
        }
        try {
            Method setStringMethod = class_NBTTagCompound.getMethod("setString", String.class, String.class);
            setStringMethod.invoke(node, tag, value);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public static String getMeta(ItemStack stack, String tag) {
        Object tagObject;
        String meta;
        block6: {
            Object craft;
            block5: {
                if (stack == null) {
                    return null;
                }
                meta = null;
                craft = InventoryUtils.getHandle(stack);
                if (craft != null) break block5;
                return null;
            }
            tagObject = InventoryUtils.getTag(craft);
            if (tagObject != null) break block6;
            return null;
        }
        try {
            Method getStringMethod = class_NBTTagCompound.getMethod("getString", String.class);
            meta = (String)getStringMethod.invoke(tagObject, tag);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return meta;
    }

    public static void setMeta(ItemStack stack, String tag, String value) {
        if (stack == null) {
            return;
        }
        try {
            Object craft = InventoryUtils.getHandle(stack);
            Object tagObject = InventoryUtils.getTag(craft);
            Method setStringMethod = class_NBTTagCompound.getMethod("setString", String.class, String.class);
            setStringMethod.invoke(tagObject, tag, value);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public static void addGlow(ItemStack stack) {
        if (stack == null) {
            return;
        }
        try {
            Object craft = InventoryUtils.getHandle(stack);
            Object tagObject = InventoryUtils.getTag(craft);
            Object enchList = class_NBTTagList.newInstance();
            Method setMethod = class_NBTTagCompound.getMethod("set", String.class, class_NBTBase);
            setMethod.invoke(tagObject, "ench", enchList);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static Inventory createInventory(InventoryHolder holder, int size, String name) {
        Inventory inventory = null;
        try {
            Constructor inventoryConstructor = class_CraftInventoryCustom.getConstructor(InventoryHolder.class, Integer.TYPE, String.class);
            inventory = (Inventory)inventoryConstructor.newInstance(holder, size, ChatColor.translateAlternateColorCodes((char)'&', (String)name));
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return inventory;
    }

    public static boolean inventorySetItem(Inventory inventory, int index, ItemStack item) {
        try {
            Method setItemMethod = class_CraftInventoryCustom.getMethod("setItem", Integer.TYPE, ItemStack.class);
            setItemMethod.invoke((Object)inventory, index, item);
            return true;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean setInventoryResults(Inventory inventory, ItemStack item) {
        try {
            Method getResultsMethod = inventory.getClass().getMethod("getResultInventory", new Class[0]);
            Object inv = getResultsMethod.invoke((Object)inventory, new Object[0]);
            Method setItemMethod = inv.getClass().getMethod("setItem", Integer.TYPE, class_ItemStack);
            setItemMethod.invoke(inv, 0, InventoryUtils.getHandle(item));
            return true;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static void addPotionEffect(LivingEntity entity, Color color) {
        InventoryUtils.addPotionEffect(entity, color.asRGB());
    }

    public static void clearPotionEffect(LivingEntity entity) {
        InventoryUtils.addPotionEffect(entity, 0);
    }

    public static void addPotionEffect(LivingEntity entity, int color) {
        try {
            Method geHandleMethod = class_CraftLivingEntity.getMethod("getHandle", new Class[0]);
            Object entityLiving = geHandleMethod.invoke((Object)entity, new Object[0]);
            Method getDataWatcherMethod = class_Entity.getMethod("getDataWatcher", new Class[0]);
            Object dataWatcher = getDataWatcherMethod.invoke(entityLiving, new Object[0]);
            Method watchMethod = class_DataWatcher.getMethod("watch", Integer.TYPE, Object.class);
            watchMethod.invoke(dataWatcher, 7, color);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void setInvulnerable(Entity entity) {
        try {
            Object handle = InventoryUtils.getHandle(entity);
            Field invulnerableField = class_Entity.getDeclaredField("invulnerable");
            invulnerableField.setAccessible(true);
            invulnerableField.set(handle, true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void removePotionEffect(LivingEntity entity) {
        InventoryUtils.addPotionEffect(entity, 0);
    }
}

